package com.xebialabs.deployit.checks;

import com.xebialabs.deployit.exception.DeployitException;
import com.xebialabs.deployit.exception.HttpResponseCodeResult;

public class Checks {

    public static void checkArgument(boolean expression, String message, Object... params) {
        if (!expression) {
            throw new IncorrectArgumentException(message, params);
        }
    }

    public static <T> T checkNotNull(T arg, String name) {
        if (arg == null) {
            throw new MissingArgumentException(name);
        }
        return arg;
    }

    public static void checkTrue(boolean condition, String message, Object... messageParams) {
        if (!condition) {
            throw new ConditionFailedException(message, messageParams);
        }
    }


    @SuppressWarnings("serial")
    @HttpResponseCodeResult(statusCode = 400)
    public static class MissingArgumentException extends DeployitException {
        public MissingArgumentException(final String parameter) {
            super("Parameter %s is missing", parameter);
        }
    }

    @SuppressWarnings("serial")
    @HttpResponseCodeResult
    public static class ConditionFailedException extends DeployitException {
        private ConditionFailedException(final String messageTemplate, final Object... params) {
            super(messageTemplate, params);
        }
    }

    @SuppressWarnings("serial")
    @HttpResponseCodeResult(statusCode = 400)
    public static class IncorrectArgumentException extends DeployitException {
        public IncorrectArgumentException(final String message, final Object... params) {
            super(message, params);
        }
    }

}
