/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.translation;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.Change;
import java.io.Serializable;

public class DefaultChange<T extends Serializable>
implements Change<T> {
    private T oldCI;
    private T newCI;

    public static <C extends Serializable> DefaultChange<C> with(C oldCI, C newCI) {
        return new DefaultChange<C>(oldCI, newCI);
    }

    DefaultChange(T anOldCI, T aNewCI) {
        Preconditions.checkArgument((anOldCI != null || aNewCI != null ? 1 : 0) != 0, (Object)"Old and new revision cannot both be null");
        this.oldCI = anOldCI;
        this.newCI = aNewCI;
    }

    public Class<T> getConfigurationItemClass() {
        return (this.oldCI == null ? this.newCI : this.oldCI).getClass();
    }

    public boolean isAddition() {
        return this.oldCI == null;
    }

    public boolean isModification() {
        return this.oldCI != null && this.newCI != null;
    }

    public boolean isDeletion() {
        return this.newCI == null;
    }

    public T getOldRevision() {
        return this.oldCI;
    }

    public T getNewRevision() {
        return this.newCI;
    }
}

