/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.LdapContextFactory;
import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.jcr.Session;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.core.security.principal.PrincipalIteratorAdapter;
import org.apache.jackrabbit.core.security.principal.PrincipalProvider;
import org.apache.jackrabbit.core.security.principal.UnknownPrincipal;

public class LdapPrincipalProvider
implements PrincipalProvider {
    private String userProvider;

    public void init(Properties options) {
        this.userProvider = (String)options.get("userProvider");
    }

    public void close() {
    }

    public Principal getPrincipal(String principalName) {
        try {
            return new LdapPrincipal(principalName);
        }
        catch (InvalidNameException e) {
            return new UnknownPrincipal(principalName);
        }
    }

    public PrincipalIterator getPrincipals(int searchType) {
        throw new UnsupportedOperationException("Cannot invoke getPrincipals(int) on LdapPrincipalProvider: not implemented.");
    }

    public boolean canReadPrincipal(Session session, Principal principalToRead) {
        return true;
    }

    public PrincipalIterator findPrincipals(String simpleFilter) {
        throw new UnsupportedOperationException("Cannot invoke findPrincipals(String) on LdapPrincipalProvider: not implemented.");
    }

    public PrincipalIterator findPrincipals(String simpleFilter, int searchType) {
        throw new UnsupportedOperationException("Cannot invoke findPrincipals(String, int) on LdapPrincipalProvider: not implemented.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrincipalIterator getGroupMembership(Principal principal) {
        PrincipalIteratorAdapter principalIteratorAdapter;
        Hashtable<String, String> ldapEnvironment = new Hashtable<String, String>();
        ldapEnvironment.put("java.naming.factory.initial", LdapContextFactory.class.getName());
        ldapEnvironment.put("java.naming.provider.url", this.userProvider);
        InitialDirContext dc = new InitialDirContext(ldapEnvironment);
        try {
            ArrayList groupPrincipals = Lists.newArrayList();
            String memberName = principal.getName();
            this.collectGroupsForMember(principal, dc, memberName, groupPrincipals);
            principalIteratorAdapter = new PrincipalIteratorAdapter((Collection)groupPrincipals);
        }
        catch (Throwable throwable) {
            try {
                dc.close();
                throw throwable;
            }
            catch (NamingException exc) {
                throw new RuntimeException("Cannot retrieve groups from LDAP server", exc);
            }
        }
        dc.close();
        return principalIteratorAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void collectGroupsForMember(Principal principal, DirContext dc, String memberDn, List<Principal> groupPrincipalsCollector) throws NamingException {
        ArrayList dnsFound = Lists.newArrayList();
        SearchControls controls = new SearchControls(2, 0L, 0, null, false, false);
        NamingEnumeration<SearchResult> groupsFound = dc.search("", "uniquemember=" + memberDn, controls);
        try {
            while (groupsFound.hasMore()) {
                SearchResult group = groupsFound.next();
                dnsFound.add(group.getNameInNamespace());
                Attribute cn = group.getAttributes().get("cn");
                groupPrincipalsCollector.add((Principal)((Object)new LdapGroup(principal, (String)cn.get())));
            }
        }
        finally {
            groupsFound.close();
        }
        for (String each : dnsFound) {
            this.collectGroupsForMember(principal, dc, each, groupPrincipalsCollector);
        }
    }

    public static final class SimplePrincipal
    implements Principal {
        private String name;

        public SimplePrincipal(String name) {
            Checks.checkNotNull(name, "Name cannot be null");
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimplePrincipal that = (SimplePrincipal)o;
            return this.name.equals(that.name);
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    public static final class LdapPrincipal
    implements Principal,
    Serializable {
        private final String name;
        private final LdapName ldapName;

        public LdapPrincipal(String name) throws InvalidNameException {
            Checks.checkNotNull(name, "Name of a principal cannot be null");
            this.ldapName = new LdapName(name);
            this.name = name;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Principal) {
                try {
                    return this.ldapName.equals(new LdapName(((Principal)object).getName()));
                }
                catch (InvalidNameException e) {
                    return false;
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.ldapName.hashCode();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String toString() {
            return this.ldapName.toString();
        }
    }

    public static class LdapGroup
    implements Group {
        private Principal member;
        private String cn;

        public LdapGroup(Principal member, String cn) {
            this.member = member;
            this.cn = cn;
        }

        public String getName() {
            return this.cn;
        }

        public boolean addMember(Principal user) {
            throw new UnsupportedOperationException("Cannot add a member to an LdapGroup. Use LDAP directly.");
        }

        public boolean removeMember(Principal user) {
            throw new UnsupportedOperationException("Cannot remove a member from an LdapGroup. Use LDAP directly.");
        }

        public boolean isMember(Principal member) {
            return member.getName().equals(this.member.getName());
        }

        public Enumeration<? extends Principal> members() {
            return new IteratorEnumeration(Collections.singleton(this.member).iterator());
        }
    }
}

