/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyType;
import com.xebialabs.deployit.repository.ArchetypeEntity;
import com.xebialabs.deployit.repository.ArtifactEntity;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.JcrRepositoryService;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.typedescriptor.ConfigurationItemDescriptorRepositoryHolder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.value.ReferenceValue;

class EntityNodeWriter<T extends RepositoryObjectEntity> {
    private final Session session;
    private final T entity;
    private final Node node;
    private boolean basicsWritten = false;

    public EntityNodeWriter(Session session, T entity, Node node) {
        this.session = session;
        this.entity = entity;
        this.node = node;
    }

    public void writeBasics() throws RepositoryException {
        this.copyConfigurationItemTypeName();
        this.setArchetypeReferenceProperty();
        this.basicsWritten = true;
    }

    public void write() throws RepositoryException {
        if (!this.basicsWritten) {
            this.writeBasics();
        }
        this.copyData();
        this.copyValuesIntoNode();
        this.copyMetadata();
    }

    private void copyConfigurationItemTypeName() throws RepositoryException {
        this.node.setProperty("$configuration.item.type", ((RepositoryObjectEntity)this.entity).getConfigurationItemTypeName());
    }

    private void setArchetypeReferenceProperty() throws RepositoryException {
        ArchetypeEntity archetype = ((RepositoryObjectEntity)this.entity).getConfigurationItemArchetype();
        if (archetype != null) {
            String archetypeId = archetype.getId();
            Node archetypeNode = this.session.getNode(JcrPathHelper.getAbsolutePathFromId(archetypeId));
            this.node.setProperty("$archetype", archetypeNode);
        } else if (this.node.hasProperty("$archetype")) {
            this.node.getProperty("$archetype").remove();
        }
    }

    private void copyData() throws RepositoryException {
        ArtifactEntity artifact;
        if (this.entity instanceof ArtifactEntity && (artifact = (ArtifactEntity)this.entity).containsData()) {
            Binary binary = this.session.getValueFactory().createBinary(artifact.getData());
            this.node.setProperty("$data", binary);
        }
    }

    private void copyValuesIntoNode() throws RepositoryException {
        ConfigurationItemDescriptor ciDescriptor = ConfigurationItemDescriptorRepositoryHolder.getDescriptor(this.entity);
        block8: for (ConfigurationItemPropertyDescriptor pd : ciDescriptor.getPropertyDescriptors()) {
            if (((RepositoryObjectEntity)this.entity).getValue(pd.getName()) == null) {
                this.removePropertyFromNode(pd);
                continue;
            }
            switch (pd.getType()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: {
                    if (pd.isPassword()) {
                        this.copyPasswordIntoNode(pd);
                        continue block8;
                    }
                }
                case ENUM: {
                    this.copyPrimitivePropertyIntoNode(pd);
                    continue block8;
                }
                case LIST_OF_OBJECTS: {
                    this.copyListOfObjectsPropertyIntoNode(pd);
                    continue block8;
                }
                case SET_OF_STRINGS: {
                    this.copySetOfStringsPropertyIntoNode(pd);
                    continue block8;
                }
                case CI: {
                    this.copyConfigurationItemPropertyIntoNode(pd);
                    continue block8;
                }
                case SET_OF_CIS: {
                    this.copySetOfConfigurationItemsPropertyIntoNode(pd);
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("Cannot convert property " + pd.getName() + " because it is of unsupported type " + pd.getType());
                }
            }
        }
    }

    private void copyPasswordIntoNode(ConfigurationItemPropertyDescriptor pd) throws RepositoryException {
        String password = this.convertObjectValueToString(pd, ((RepositoryObjectEntity)this.entity).getValue(pd.getName()));
        if (!"********".equals(password)) {
            this.node.setProperty(pd.getName(), password);
        }
    }

    private void copyMetadata() throws RepositoryException {
        this.node.setProperty("$id", ((RepositoryObjectEntity)this.entity).getId());
        if (((RepositoryObjectEntity)this.entity).getOverrideLastModified() != null) {
            this.node.setProperty("$lastModified", ((RepositoryObjectEntity)this.entity).getOverrideLastModified());
        } else {
            this.node.setProperty("$lastModified", Calendar.getInstance());
        }
        if (((RepositoryObjectEntity)this.entity).getCreatingTaskId() != null) {
            this.node.setProperty("$creatingTaskId", ((RepositoryObjectEntity)this.entity).getCreatingTaskId());
        }
    }

    private void removePropertyFromNode(ConfigurationItemPropertyDescriptor pd) throws RepositoryException {
        try {
            this.node.getProperty(pd.getName()).remove();
        }
        catch (PathNotFoundException ignored) {
            // empty catch block
        }
        if (pd.getType() == ConfigurationItemPropertyType.LIST_OF_OBJECTS) {
            for (ConfigurationItemPropertyDescriptor eachNestedPd : pd.getPropertyDescriptors()) {
                try {
                    this.node.getProperty(JcrRepositoryService.generateJcrPropertyNameForNestedProperty(eachNestedPd)).remove();
                }
                catch (PathNotFoundException ignored) {
                    // empty catch block
                }
            }
        }
    }

    private void copyPrimitivePropertyIntoNode(ConfigurationItemPropertyDescriptor pd) throws RepositoryException {
        String valueAsString = this.convertObjectValueToString(pd, ((RepositoryObjectEntity)this.entity).getValue(pd.getName()));
        this.node.setProperty(pd.getName(), valueAsString);
    }

    private void copyListOfObjectsPropertyIntoNode(ConfigurationItemPropertyDescriptor pd) throws RepositoryException {
        ValueFactory valueFactory = this.session.getValueFactory();
        Collection<?> valueAsCollection = this.convertObjectValueToCollection(pd, ((RepositoryObjectEntity)this.entity).getValue(pd.getName()));
        for (ConfigurationItemPropertyDescriptor eachNestedPd : pd.getPropertyDescriptors()) {
            ArrayList jcrValueList = Lists.newArrayList();
            for (Object each : valueAsCollection) {
                String stringValue;
                if (!(each instanceof Map)) {
                    throw new IllegalArgumentException("Element in property " + pd.getName() + " of repository entity " + ((RepositoryObjectEntity)this.entity).getId() + " is not a Map: " + each);
                }
                Object objectValue = ((Map)each).get(eachNestedPd.getName());
                if (objectValue == null) {
                    stringValue = "";
                } else if (objectValue instanceof String) {
                    stringValue = (String)objectValue;
                } else {
                    throw new IllegalArgumentException("Property " + eachNestedPd.getName() + " in element in property " + pd.getName() + " of repository entity " + ((RepositoryObjectEntity)this.entity).getId() + " is not a String: " + objectValue);
                }
                jcrValueList.add(valueFactory.createValue(stringValue));
            }
            Value[] jcrValues = jcrValueList.toArray(new Value[jcrValueList.size()]);
            this.node.setProperty(JcrRepositoryService.generateJcrPropertyNameForNestedProperty(eachNestedPd), jcrValues);
        }
        this.node.setProperty(pd.getName(), "property-set");
    }

    private void copySetOfStringsPropertyIntoNode(ConfigurationItemPropertyDescriptor pd) throws RepositoryException {
        ValueFactory valueFactory = this.session.getValueFactory();
        Collection<?> valueAsCollection = this.convertObjectValueToCollection(pd, ((RepositoryObjectEntity)this.entity).getValue(pd.getName()));
        ArrayList jcrValueList = Lists.newArrayList();
        for (Object each : valueAsCollection) {
            if (!(each instanceof String)) {
                throw new IllegalArgumentException("Element in property " + pd.getName() + " of repository entity " + ((RepositoryObjectEntity)this.entity).getId() + " is not a String: " + each);
            }
            String stringValue = (String)each;
            jcrValueList.add(valueFactory.createValue(stringValue));
        }
        Value[] jcrValues = jcrValueList.toArray(new Value[jcrValueList.size()]);
        this.node.setProperty(pd.getName(), jcrValues);
    }

    private void copyConfigurationItemPropertyIntoNode(ConfigurationItemPropertyDescriptor pd) throws RepositoryException {
        if (pd.asContainment()) {
            return;
        }
        String referencedCiId = this.convertObjectValueToString(pd, ((RepositoryObjectEntity)this.entity).getValue(pd.getName()));
        Node referencedCi = this.session.getNode(JcrPathHelper.getAbsolutePathFromId(referencedCiId));
        this.node.setProperty(pd.getName(), referencedCi);
    }

    private void copySetOfConfigurationItemsPropertyIntoNode(ConfigurationItemPropertyDescriptor pd) throws RepositoryException {
        if (pd.asContainment()) {
            return;
        }
        Collection<?> valueAsCollection = this.convertObjectValueToCollection(pd, ((RepositoryObjectEntity)this.entity).getValue(pd.getName()));
        ArrayList jcrReferenceList = Lists.newArrayList();
        for (Object each : valueAsCollection) {
            if (!(each instanceof String)) {
                throw new IllegalArgumentException("Element in property " + pd.getName() + " of repository entity " + ((RepositoryObjectEntity)this.entity).getId() + " is not a String: " + each);
            }
            String referencedCiId = (String)each;
            Node referencedCi = this.session.getNode(JcrPathHelper.getAbsolutePathFromId(referencedCiId));
            jcrReferenceList.add(new ReferenceValue(referencedCi));
        }
        Value[] jcrReferenceValues = jcrReferenceList.toArray(new Value[jcrReferenceList.size()]);
        this.node.setProperty(pd.getName(), jcrReferenceValues);
    }

    private String convertObjectValueToString(ConfigurationItemPropertyDescriptor pd, Object value) {
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("Property " + pd.getName() + " of repository entity " + ((RepositoryObjectEntity)this.entity).getId() + " is not a String: " + value);
        }
        return (String)value;
    }

    private Collection<?> convertObjectValueToCollection(ConfigurationItemPropertyDescriptor pd, Object value) {
        if (!(value instanceof Collection)) {
            throw new IllegalArgumentException("Property " + pd.getName() + " of repository entity " + ((RepositoryObjectEntity)this.entity).getId() + " is not a Collection: " + value);
        }
        return (Collection)value;
    }
}

