/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.UsernameAndPasswordCredentials;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.TaskRegistry;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class ExecutionEngine {
    @Autowired
    private TaskRegistry taskRegistry;
    @Autowired
    private TaskExecutor taskExecutor;
    private static final Logger logger = LoggerFactory.getLogger(ExecutionEngine.class);

    public String register(Task task) {
        Preconditions.checkNotNull((Object)task, (Object)"Should not pass in a null task");
        UsernameAndPasswordCredentials creds = this.getCurrentCredentials();
        task.setOwner(creds.getUsername());
        return this.taskRegistry.registerTask(task);
    }

    public Task getTask(String id) {
        return this.taskRegistry.getTask(id);
    }

    private UsernameAndPasswordCredentials sanityCheckTask(String id, Task task, String action) {
        Preconditions.checkState((task != null ? 1 : 0) != 0, (String)"Cannot %s a task that is not registered with id [%s]", (Object[])new Object[]{action, id});
        UsernameAndPasswordCredentials creds = this.getCurrentCredentials();
        if (!creds.getUsername().equals(task.getOwner())) {
            throw new PermissionDeniedException(String.format("Cannot %s a task registered by another user", action));
        }
        return creds;
    }

    protected UsernameAndPasswordCredentials getCurrentCredentials() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Preconditions.checkNotNull((Object)authentication, (Object)"No authentication present, are you logged in?");
        Preconditions.checkState((boolean)(authentication instanceof UsernameAndPasswordCredentials), (Object)"Security credentials are not of the right type");
        return (UsernameAndPasswordCredentials)authentication;
    }

    public void execute(String id) {
        Task task = this.taskRegistry.getTask(id);
        UsernameAndPasswordCredentials creds = this.sanityCheckTask(id, task, "start");
        this.setCredentialsIfNotPresent(task, creds);
        FutureTask<Object> future = new FutureTask<Object>(task, null);
        task.setWrappingTask(future);
        this.taskExecutor.execute(future);
    }

    private void setCredentialsIfNotPresent(Task task, UsernameAndPasswordCredentials creds) {
        if (task.getOwnerCredentials() == null) {
            task.setOwnerCredentials(creds);
        }
    }

    public void stopExecution(String taskId) {
        Task task = this.taskRegistry.getTask(taskId);
        UsernameAndPasswordCredentials credentials = this.sanityCheckTask(taskId, task, "stop");
        this.setCredentialsIfNotPresent(task, credentials);
        task.stop();
    }

    public void abortExecution(String taskId) {
        Task task = this.taskRegistry.getTask(taskId);
        UsernameAndPasswordCredentials credentials = this.sanityCheckTask(taskId, task, "abort");
        this.setCredentialsIfNotPresent(task, credentials);
        task.abort();
    }

    public void cancel(String taskId) {
        Task task = this.taskRegistry.getTask(taskId);
        UsernameAndPasswordCredentials credentials = this.sanityCheckTask(taskId, task, "cancel");
        this.setCredentialsIfNotPresent(task, credentials);
        this.taskRegistry.cancelTask(taskId);
    }

    public List<Task> getAllIncompleteTasksForCurrentUser() {
        return this.taskRegistry.getIncompleteTasksForUser(this.getCurrentCredentials().getUsername());
    }

    @PreDestroy
    public void shutdownTasks() {
        this.requestStopOnTasks();
        this.waitForTasksToBeStopped();
        this.taskRegistry.destroy();
    }

    private void waitForTasksToBeStopped() {
        for (Task task : this.taskRegistry.getTasks()) {
            if (!task.isExecuting()) continue;
            try {
                logger.info("Waiting for task {} to stop", (Object)task.getId());
                FutureTask<Object> wrappingTask = task.getWrappingTask();
                if (wrappingTask == null) continue;
                wrappingTask.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                logger.error("Could not wait for task {} to be stopped...", (Object)task.getId());
            }
        }
    }

    private void requestStopOnTasks() {
        for (Task task : this.taskRegistry.getTasks()) {
            if (!task.isExecuting()) continue;
            task.stop();
        }
    }
}

