/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.repository.ArtifactEntity;
import java.io.File;
import java.util.Set;

public abstract class DeployableArtifactImporter {
    public abstract boolean canHandle(ConfigurationItemDescriptor var1);

    protected abstract void doImport(ArtifactEntity var1, File var2);

    public void importArtifact(ArtifactEntity artifact, File artifactFile, ConfigurationItemDescriptor typeDescriptor) {
        this.doImport(artifact, artifactFile);
        if (typeDescriptor.getPropertyDescriptor("placeholders") != null) {
            Set<String> placeholders = this.parsePlaceholders(artifact, artifactFile);
            this.setPlaceholdersInArtifact(artifact, placeholders);
        }
    }

    private void setPlaceholdersInArtifact(ArtifactEntity artifact, Set<String> placeholders) {
        artifact.addValue("placeholders", placeholders);
    }

    protected Set<String> parsePlaceholders(ArtifactEntity artifact, File artifactFile) {
        return Sets.newHashSet();
    }
}

