/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.event;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.event.Event;
import com.xebialabs.deployit.event.EventCallback;
import com.xebialabs.deployit.task.Task;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventBus {
    private static final Map<Class<?>, List<EventCallback<?>>> EVENT_LISTENERS = new HashMap();

    public static synchronized <E extends Event> void registerForEvent(Class<E> event, EventCallback<E> callback) {
        ArrayList callbackList = EVENT_LISTENERS.get(event);
        if (callbackList == null) {
            callbackList = Lists.newArrayList();
            EVENT_LISTENERS.put(event, callbackList);
        }
        callbackList.add(callback);
    }

    public static void deregisterForEvent(Class<Task.TaskStateChangeEvent> event, EventCallback<Task.TaskStateChangeEvent> callback) {
        List<EventCallback<?>> callbackList = EVENT_LISTENERS.get(event);
        if (callbackList != null) {
            callbackList.remove(callback);
        }
    }

    public static synchronized <E extends Event> void publish(E event) {
        List<EventCallback<?>> callbackList = EVENT_LISTENERS.get(event.getClass());
        if (callbackList == null || callbackList.size() == 0) {
            return;
        }
        for (EventCallback<?> c : callbackList) {
            c.receive(event);
        }
    }
}

