/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer;

import ai.digital.configuration.central.deploy.ClientProperties;
import ai.digital.deploy.core.common.security.permission.DeployitPermissions$;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.xebialabs.deployit.checksum.ChecksumAlgorithmProvider;
import com.xebialabs.deployit.core.sql.RepositoryHelper;
import com.xebialabs.deployit.engine.spi.artifact.resolution.ResolvedArtifactFile;
import com.xebialabs.deployit.engine.spi.command.CreateCisCommand;
import com.xebialabs.deployit.engine.spi.command.RepositoryBaseCommand;
import com.xebialabs.deployit.io.ArtifactFileUtils;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.CompositePackage;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.server.api.importer.ImportedPackage;
import com.xebialabs.deployit.server.api.importer.Importer;
import com.xebialabs.deployit.server.api.importer.ImportingContext;
import com.xebialabs.deployit.server.api.importer.ListableImporter;
import com.xebialabs.deployit.server.api.importer.PackageInfo;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.importer.DefaultImportingContext;
import com.xebialabs.deployit.service.importer.ImporterException;
import com.xebialabs.deployit.service.importer.ImporterService;
import com.xebialabs.deployit.service.importer.XmlManifestDarImporter;
import com.xebialabs.deployit.service.importer.package$;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xldeploy.packager.placeholders.PlaceholdersUtil$;
import com.xebialabs.xldeploy.packager.placeholders.SourceArtifactScanner;
import com.xebialabs.xlplatform.artifact.resolution.ArtifactResolverRegistry$;
import com.xebialabs.xlplatform.utils.ResourceManagement$;
import de.schlichtherle.truezip.file.TFile;
import jakarta.annotation.PostConstruct;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import nl.javadude.scannit.Scannit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\rEb\u0001B\u001b7\u0001\u0005C\u0001B\u0014\u0001\u0003\u0002\u0004%\ta\u0014\u0005\t-\u0002\u0011\t\u0019!C\u0001/\"A\u0001\r\u0001B\u0001B\u0003&\u0001\u000b\u0003\u0005b\u0001\t\u0005\r\u0011\"\u0001c\u0011!I\u0007A!a\u0001\n\u0003Q\u0007\u0002\u00037\u0001\u0005\u0003\u0005\u000b\u0015B2\t\u00115\u0004!\u00111A\u0005\u00029D\u0001\"\u001e\u0001\u0003\u0002\u0004%\tA\u001e\u0005\tq\u0002\u0011\t\u0011)Q\u0005_\"A\u0011\u0010\u0001BA\u0002\u0013\u0005!\u0010\u0003\u0006\u0002\f\u0001\u0011\t\u0019!C\u0001\u0003\u001bA\u0011\"!\u0005\u0001\u0005\u0003\u0005\u000b\u0015B>\t\u0015\u0005M\u0001A!a\u0001\n\u0003\t)\u0002\u0003\u0006\u00024\u0001\u0011\t\u0019!C\u0001\u0003kA!\"!\u000f\u0001\u0005\u0003\u0005\u000b\u0015BA\f\u0011)\tY\u0004\u0001BA\u0002\u0013\u0005\u0011Q\b\u0005\u000b\u0003\u001f\u0002!\u00111A\u0005\u0002\u0005E\u0003BCA+\u0001\t\u0005\t\u0015)\u0003\u0002@!Q\u0011q\u000b\u0001\u0003\u0002\u0004%\t!!\u0017\t\u0015\u0005\u001d\u0004A!a\u0001\n\u0003\tI\u0007\u0003\u0006\u0002n\u0001\u0011\t\u0011)Q\u0005\u00037Bq!a\u001c\u0001\t\u0003\t\t\bC\u0005\u0002\"\u0002\u0011\r\u0011\"\u0003\u0002$\"A\u00111\u0019\u0001!\u0002\u0013\t)\u000bC\u0005\u0002F\u0002\u0011\r\u0011\"\u0003\u0002H\"A\u0011Q\u001b\u0001!\u0002\u0013\tI\rC\u0005\u0002X\u0002\u0011\r\u0011\"\u0003\u0002Z\"A\u0011\u0011 \u0001!\u0002\u0013\tY\u000eC\u0005\u0002|\u0002\u0001\r\u0011\"\u0003\u0002~\"I!1\u0002\u0001A\u0002\u0013%!Q\u0002\u0005\t\u0005#\u0001\u0001\u0015)\u0003\u0002\u0000\"9!1\u0003\u0001\u0005\u0002\tU\u0001b\u0002B\u0014\u0001\u0011\u0005#\u0011\u0006\u0005\b\u0005W\u0001A\u0011\u0001B\u0017\u0011\u001d\u0011\t\u0004\u0001C!\u0005gAqA!\u0014\u0001\t\u0003\u0012y\u0005C\u0004\u0003\\\u0001!\tB!\u0018\t\u000f\tE\u0004\u0001\"\u0003\u0003t!9!\u0011\u0010\u0001\u0005\n\tm\u0004b\u0002BI\u0001\u0011%!1\u0013\u0005\b\u0005S\u0003A\u0011\u0002BV\u0011\u001d\u0011\t\f\u0001C\u0005\u0005gCqAa0\u0001\t\u0013\u0011\t\rC\u0004\u0003H\u0002!IA!3\t\u000f\t\r\b\u0001\"\u0003\u0003f\"9!1 \u0001\u0005\n\tu\bbBB\u0003\u0001\u0011%1q\u0001\u0005\b\u0005\u001f\u0004A\u0011BB\u0007\u0011\u001d\u0019\t\u0002\u0001C\u0005\u0007'Aqaa\u0006\u0001\t\u0013\u0019I\u0002C\u0004\u0004$\u0001!Ia!\n\t\u000f\tm\u0003\u0001\"\u0003\u0004,\t\u0019\u0012*\u001c9peR,'oU3sm&\u001cW-S7qY*\u0011q\u0007O\u0001\tS6\u0004xN\u001d;fe*\u0011\u0011HO\u0001\bg\u0016\u0014h/[2f\u0015\tYD(\u0001\u0005eKBdw._5u\u0015\tid(A\u0005yK\nL\u0017\r\\1cg*\tq(A\u0002d_6\u001c\u0001aE\u0002\u0001\u0005*\u0003\"a\u0011%\u000e\u0003\u0011S!!\u0012$\u0002\t1\fgn\u001a\u0006\u0002\u000f\u0006!!.\u0019<b\u0013\tIEI\u0001\u0004PE*,7\r\u001e\t\u0003\u00172k\u0011AN\u0005\u0003\u001bZ\u0012q\"S7q_J$XM]*feZL7-Z\u0001\u0012e\u0016\u0004xn]5u_JL8+\u001a:wS\u000e,W#\u0001)\u0011\u0005E#V\"\u0001*\u000b\u0005MS\u0014A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011QK\u0015\u0002\u0012%\u0016\u0004xn]5u_JL8+\u001a:wS\u000e,\u0017!\u0006:fa>\u001c\u0018\u000e^8ssN+'O^5dK~#S-\u001d\u000b\u00031z\u0003\"!\u0017/\u000e\u0003iS\u0011aW\u0001\u0006g\u000e\fG.Y\u0005\u0003;j\u0013A!\u00168ji\"9qLAA\u0001\u0002\u0004\u0001\u0016a\u0001=%c\u0005\u0011\"/\u001a9pg&$xN]=TKJ4\u0018nY3!\u0003-\u0011x\u000e\\3TKJ4\u0018nY3\u0016\u0003\r\u0004\"\u0001Z4\u000e\u0003\u0015T!A\u001a\u001e\u0002\u0011M,7-\u001e:jifL!\u0001[3\u0003\u0017I{G.Z*feZL7-Z\u0001\u0010e>dWmU3sm&\u001cWm\u0018\u0013fcR\u0011\u0001l\u001b\u0005\b?\u0016\t\t\u00111\u0001d\u00031\u0011x\u000e\\3TKJ4\u0018nY3!\u0003%1\u0018\r\\5eCR|'/F\u0001p!\t\u00018/D\u0001r\u0015\t\u0011\b(\u0001\u0006wC2LG-\u0019;j_:L!\u0001^9\u0003\u0013Y\u000bG.\u001b3bi>\u0014\u0018!\u0004<bY&$\u0017\r^8s?\u0012*\u0017\u000f\u0006\u0002Yo\"9q\fCA\u0001\u0002\u0004y\u0017A\u0003<bY&$\u0017\r^8sA\u000591oY1o]\u0016\u0014X#A>\u0011\u0007q\f9!D\u0001~\u0015\tqx0\u0001\u0007qY\u0006\u001cW\r[8mI\u0016\u00148O\u0003\u0003\u0002\u0002\u0005\r\u0011\u0001\u00039bG.\fw-\u001a:\u000b\u0007\u0005\u0015A(\u0001\u0005yY\u0012,\u0007\u000f\\8z\u0013\r\tI! \u0002\u0016'>,(oY3BeRLg-Y2u'\u000e\fgN\\3s\u0003-\u00198-\u00198oKJ|F%Z9\u0015\u0007a\u000by\u0001C\u0004`\u0017\u0005\u0005\t\u0019A>\u0002\u0011M\u001c\u0017M\u001c8fe\u0002\n1c\u00197jK:$8i\u001c8gS\u001e,(/\u0019;j_:,\"!a\u0006\u0011\t\u0005e\u0011qF\u0007\u0003\u00037QA!!\b\u0002 \u00051A-\u001a9m_fTA!!\t\u0002$\u000591-\u001a8ue\u0006d'\u0002BA\u0013\u0003O\tQbY8oM&<WO]1uS>t'\u0002BA\u0015\u0003W\tq\u0001Z5hSR\fGN\u0003\u0002\u0002.\u0005\u0011\u0011-[\u0005\u0005\u0003c\tYB\u0001\tDY&,g\u000e\u001e)s_B,'\u000f^5fg\u000692\r\\5f]R\u001cuN\u001c4jOV\u0014\u0018\r^5p]~#S-\u001d\u000b\u00041\u0006]\u0002\u0002C0\u000f\u0003\u0003\u0005\r!a\u0006\u0002)\rd\u0017.\u001a8u\u0007>tg-[4ve\u0006$\u0018n\u001c8!\u0003A\u0011X\r]8tSR|'/\u001f%fYB,'/\u0006\u0002\u0002@A!\u0011\u0011IA&\u001b\t\t\u0019E\u0003\u0003\u0002F\u0005\u001d\u0013aA:rY*\u0019\u0011\u0011\n\u001e\u0002\t\r|'/Z\u0005\u0005\u0003\u001b\n\u0019E\u0001\tSKB|7/\u001b;pefDU\r\u001c9fe\u0006!\"/\u001a9pg&$xN]=IK2\u0004XM]0%KF$2\u0001WA*\u0011!y\u0016#!AA\u0002\u0005}\u0012!\u0005:fa>\u001c\u0018\u000e^8ss\"+G\u000e]3sA\u0005I2\r[3dWN,X.\u00117h_JLG\u000f[7Qe>4\u0018\u000eZ3s+\t\tY\u0006\u0005\u0003\u0002^\u0005\rTBAA0\u0015\r\t\tGO\u0001\tG\",7m[:v[&!\u0011QMA0\u0005e\u0019\u0005.Z2lgVl\u0017\t\\4pe&$\b.\u001c)s_ZLG-\u001a:\u0002;\rDWmY6tk6\fEnZ8sSRDW\u000e\u0015:pm&$WM]0%KF$2\u0001WA6\u0011!yF#!AA\u0002\u0005m\u0013AG2iK\u000e\\7/^7BY\u001e|'/\u001b;i[B\u0013xN^5eKJ\u0004\u0013A\u0002\u001fj]&$h\b\u0006\t\u0002t\u0005U\u0014qOA=\u0003w\ni(a \u0002\u0002B\u00111\n\u0001\u0005\u0006\u001dZ\u0001\r\u0001\u0015\u0005\u0006CZ\u0001\ra\u0019\u0005\u0006[Z\u0001\ra\u001c\u0005\u0006sZ\u0001\ra\u001f\u0005\b\u0003'1\u0002\u0019AA\f\u0011\u001d\tYD\u0006a\u0001\u0003\u007fAq!a\u0016\u0017\u0001\u0004\tY\u0006K\u0002\u0017\u0003\u000b\u0003B!a\"\u0002\u001e6\u0011\u0011\u0011\u0012\u0006\u0005\u0003\u0017\u000bi)\u0001\u0006b]:|G/\u0019;j_:TA!a$\u0002\u0012\u00069a-Y2u_JL(\u0002BAJ\u0003+\u000bQAY3b]NTA!a&\u0002\u001a\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002\u001c\u0006\u0019qN]4\n\t\u0005}\u0015\u0011\u0012\u0002\n\u0003V$xn^5sK\u0012\f\u0011\"[7q_J$XM]:\u0016\u0005\u0005\u0015\u0006CBAT\u0003[\u000b\t,\u0004\u0002\u0002**\u0019\u00111\u0016$\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003_\u000bIK\u0001\u0003MSN$\b\u0003BAZ\u0003\u007fk!!!.\u000b\u0007]\n9L\u0003\u0003\u0002:\u0006m\u0016aA1qS*\u0019\u0011Q\u0018\u001e\u0002\rM,'O^3s\u0013\u0011\t\t-!.\u0003\u0011%k\u0007o\u001c:uKJ\f!\"[7q_J$XM]:!\u0003\u0019awnZ4feV\u0011\u0011\u0011\u001a\t\u0005\u0003\u0017\f\t.\u0004\u0002\u0002N*!\u0011qZAM\u0003\u0015\u0019HN\u001a\u001bk\u0013\u0011\t\u0019.!4\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\n\u0001#[:D_2dWm\u0019;j_:\\\u0015N\u001c3\u0016\u0005\u0005m\u0007cB-\u0002^\u0006\u0005\u00181_\u0005\u0004\u0003?T&!\u0003$v]\u000e$\u0018n\u001c82!\u0011\t\u0019/a<\u000e\u0005\u0005\u0015(\u0002BAt\u0003S\fqA]3gY\u0016\u001cGO\u0003\u0003\u0002:\u0006-(bAAwu\u00051\u0001\u000f\\;hS:LA!!=\u0002f\na\u0001K]8qKJ$\u0018pS5oIB\u0019\u0011,!>\n\u0007\u0005](LA\u0004C_>dW-\u00198\u0002#%\u001c8i\u001c7mK\u000e$\u0018n\u001c8LS:$\u0007%\u0001\u000ej[B|'\u000f^1cY\u0016\u0004\u0016mY6bO\u0016$\u0015N]3di>\u0014\u00180\u0006\u0002\u0002\u0000B!!\u0011\u0001B\u0004\u001b\t\u0011\u0019AC\u0002\u0003\u0006\u0019\u000b!![8\n\t\t%!1\u0001\u0002\u0005\r&dW-\u0001\u0010j[B|'\u000f^1cY\u0016\u0004\u0016mY6bO\u0016$\u0015N]3di>\u0014\u0018p\u0018\u0013fcR\u0019\u0001La\u0004\t\u0011}s\u0012\u0011!a\u0001\u0003\u007f\f1$[7q_J$\u0018M\u00197f!\u0006\u001c7.Y4f\t&\u0014Xm\u0019;pef\u0004\u0013!D5oSRLU\u000e]8si\u0016\u00148\u000fF\u0001YQ\r\u0001#\u0011\u0004\t\u0005\u00057\u0011\u0019#\u0004\u0002\u0003\u001e)!\u00111\u0012B\u0010\u0015\t\u0011\t#A\u0004kC.\f'\u000f^1\n\t\t\u0015\"Q\u0004\u0002\u000e!>\u001cHoQ8ogR\u0014Xo\u0019;\u0002;\u001d,G/S7q_J$\u0018M\u00197f!\u0006\u001c7.Y4f\t&\u0014Xm\u0019;pef$\"!a@\u0002;M,G/S7q_J$\u0018M\u00197f!\u0006\u001c7.Y4f\t&\u0014Xm\u0019;pef$2\u0001\u0017B\u0018\u0011\u001d\tYP\ta\u0001\u0003\u007f\fA\u0002\\5tiB\u000b7m[1hKN$\"A!\u000e\u0011\r\u0005\u001d\u0016Q\u0016B\u001c!\u0011\u0011IDa\u0012\u000f\t\tm\"1\t\t\u0004\u0005{QVB\u0001B \u0015\r\u0011\t\u0005Q\u0001\u0007yI|w\u000e\u001e \n\u0007\t\u0015#,\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005\u0013\u0012YE\u0001\u0004TiJLgn\u001a\u0006\u0004\u0005\u000bR\u0016!D5na>\u0014H\u000fU1dW\u0006<W\r\u0006\u0003\u00038\tE\u0003b\u0002B*I\u0001\u0007!QK\u0001\u0007g>,(oY3\u0011\t\u0005M&qK\u0005\u0005\u00053\n)L\u0001\u0007J[B|'\u000f^*pkJ\u001cW-A\bdQ\u0016\u001c7\u000eU3s[&\u001c8/[8o)\u0015A&q\fB7\u0011\u001d\u0011\t'\na\u0001\u0005G\n!\u0002]3s[&\u001c8/[8o!\u0011\u0011)G!\u001b\u000e\u0005\t\u001d$b\u0001B1K&!!1\u000eB4\u0005)\u0001VM]7jgNLwN\u001c\u0005\b\u0005_*\u0003\u0019\u0001B\u001c\u0003QygnQ8oM&<WO]1uS>t\u0017\n^3ng\u0006AAm\\%na>\u0014H\u000f\u0006\u0004\u00038\tU$q\u000f\u0005\b\u0005'2\u0003\u0019\u0001B+\u0011\u00199d\u00051\u0001\u00022\u0006\u00012oY1o!2\f7-\u001a5pY\u0012,'o\u001d\u000b\u00061\nu$q\u0011\u0005\b\u0005\u007f:\u0003\u0019\u0001BA\u0003=IW\u000e]8si\u0016$\u0007+Y2lC\u001e,\u0007\u0003BAZ\u0005\u0007KAA!\"\u00026\ny\u0011*\u001c9peR,G\rU1dW\u0006<W\rC\u0004\u0003\n\u001e\u0002\rAa#\u0002\u0007\r$\b\u0010\u0005\u0003\u00024\n5\u0015\u0002\u0002BH\u0003k\u0013\u0001#S7q_J$\u0018N\\4D_:$X\r\u001f;\u00021I,7o\u001c7wK\u0006sG-\u00128sS\u000eD\u0017I\u001d;jM\u0006\u001cG\u000fF\u0002Y\u0005+CqAa&)\u0001\u0004\u0011I*\u0001\bt_V\u00148-Z!si&4\u0017m\u0019;\u0011\t\tm%QU\u0007\u0003\u0005;SAAa(\u0003\"\u0006A\u0011M\u001d;jM\u0006\u001cGO\u0003\u0003\u0003$\u0006%\u0018aA;e[&!!q\u0015BO\u00059\u0019v.\u001e:dK\u0006\u0013H/\u001b4bGR\fQ#[:BeRLg-Y2u!J,WI\u001c:jG\",G\r\u0006\u0003\u0002t\n5\u0006b\u0002BXS\u0001\u0007!\u0011T\u0001\u000bI\u0016\u0004Hn\\=bE2,\u0017!D2iK\u000e\\\u0017*\u001c9peR,G\rF\u0002Y\u0005kCqAa.+\u0001\u0004\u0011I,A\u0006qC\u000e\\\u0017mZ3J]\u001a|\u0007\u0003BAZ\u0005wKAA!0\u00026\nY\u0001+Y2lC\u001e,\u0017J\u001c4p\u0003\u00152\u0018\r\\5eCR,\u0017\t\u001d9mS\u000e\fG/[8o\t&\u0014Xm\u0019;pef\u001cFO];diV\u0014X\rF\u0002Y\u0005\u0007DqA!2,\u0001\u0004\u00119$A\u0007baBd\u0017nY1uS>t\u0017\nZ\u0001\u000fGJ,\u0017\r^3F]RLG/[3t)\u001dA&1\u001aBg\u0005#DqAa -\u0001\u0004\u0011\t\tC\u0004\u0003P2\u0002\r!a=\u0002\u0013%\u001cX\u000b]4sC\u0012,\u0007b\u0002BjY\u0001\u0007!Q[\u0001\u0012i>\u001c%/Z1uK\u000e{G\u000e\\3di>\u0014\bCBAT\u0005/\u0014Y.\u0003\u0003\u0003Z\u0006%&aA*fiB!!Q\u001cBp\u001b\t\u0011\t+\u0003\u0003\u0003b\n\u0005&!E\"p]\u001aLw-\u001e:bi&|g.\u0013;f[\u00061b-\u001b7uKJ,\u00050[:uS:<\u0007+Y2lC\u001e,7\u000f\u0006\u0003\u0003h\nE\bC\u0002B\u001d\u0005S\u0014Y/\u0003\u0003\u0003Z\n-\u0003\u0003BAr\u0005[LAAa<\u0002f\n\u0011\u0002K]8qKJ$\u0018\u0010R3tGJL\u0007\u000f^8s\u0011\u001d\u0011\u00190\fa\u0001\u0005k\fqA^3sg&|g\u000e\u0005\u0003\u0003^\n]\u0018\u0002\u0002B}\u0005C\u0013qAV3sg&|g.\u0001\u0010de\u0016\fG/\u001a(fgR,GmQ8oM&<WO]1uS>t\u0017\n^3ngR)\u0001La@\u0004\u0004!91\u0011\u0001\u0018A\u0002\tm\u0017AA2j\u0011\u001d\u0011\u0019N\fa\u0001\u0005+\f\u0001B^1mS\u0012\fG/\u001a\u000b\u00041\u000e%\u0001bBB\u0006_\u0001\u0007!Q[\u0001\ti>\u001c%/Z1uKR!\u00111_B\b\u0011\u001d\u00119\f\ra\u0001\u0005s\u000bq!\u00199q\u001d\u0006lW\r\u0006\u0003\u00038\rU\u0001b\u0002B\\c\u0001\u0007!\u0011X\u0001\u0013gV\u00147\u000b\u001e:j]\u001e\fe\r^3s\u0019\u0006\u001cH\u000f\u0006\u0004\u00038\rm1q\u0004\u0005\b\u0007;\u0011\u0004\u0019\u0001B\u001c\u0003\u0005\u0019\bbBB\u0011e\u0001\u0007!qG\u0001\u0004g\u0016\u0004\u0018aE:vEN#(/\u001b8h\u0005\u00164wN]3MCN$HC\u0002B\u001c\u0007O\u0019I\u0003C\u0004\u0004\u001eM\u0002\rAa\u000e\t\u000f\r\u00052\u00071\u0001\u00038Q)\u0001l!\f\u00040!9!q\u001a\u001bA\u0002\u0005M\bb\u0002B\\i\u0001\u0007!\u0011\u0018")
public class ImporterServiceImpl
implements ImporterService {
    private RepositoryService repositoryService;
    private RoleService roleService;
    private Validator validator;
    private SourceArtifactScanner scanner;
    private ClientProperties clientConfiguration;
    private RepositoryHelper repositoryHelper;
    private ChecksumAlgorithmProvider checksumAlgorithmProvider;
    private final java.util.List<Importer> importers;
    private final Logger logger;
    private final Function1<PropertyKind, Object> isCollectionKind;
    private File importablePackageDirectory;

    public RepositoryService repositoryService() {
        return this.repositoryService;
    }

    public void repositoryService_$eq(RepositoryService x$1) {
        this.repositoryService = x$1;
    }

    public RoleService roleService() {
        return this.roleService;
    }

    public void roleService_$eq(RoleService x$1) {
        this.roleService = x$1;
    }

    public Validator validator() {
        return this.validator;
    }

    public void validator_$eq(Validator x$1) {
        this.validator = x$1;
    }

    public SourceArtifactScanner scanner() {
        return this.scanner;
    }

    public void scanner_$eq(SourceArtifactScanner x$1) {
        this.scanner = x$1;
    }

    public ClientProperties clientConfiguration() {
        return this.clientConfiguration;
    }

    public void clientConfiguration_$eq(ClientProperties x$1) {
        this.clientConfiguration = x$1;
    }

    public RepositoryHelper repositoryHelper() {
        return this.repositoryHelper;
    }

    public void repositoryHelper_$eq(RepositoryHelper x$1) {
        this.repositoryHelper = x$1;
    }

    public ChecksumAlgorithmProvider checksumAlgorithmProvider() {
        return this.checksumAlgorithmProvider;
    }

    public void checksumAlgorithmProvider_$eq(ChecksumAlgorithmProvider x$1) {
        this.checksumAlgorithmProvider = x$1;
    }

    private java.util.List<Importer> importers() {
        return this.importers;
    }

    private Logger logger() {
        return this.logger;
    }

    private Function1<PropertyKind, Object> isCollectionKind() {
        return this.isCollectionKind;
    }

    private File importablePackageDirectory() {
        return this.importablePackageDirectory;
    }

    private void importablePackageDirectory_$eq(File x$1) {
        this.importablePackageDirectory = x$1;
    }

    @PostConstruct
    public void initImporters() {
        Set importerClasses = Scannit.getInstance().getSubTypesOf(Importer.class);
        this.logger().debug("Found importers: {}", (Object)importerClasses);
        ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(importerClasses).asScala().filter((Function1 & Serializable)cls -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$initImporters$1(cls)))).foreach((Function1 & Serializable)importerClass -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$initImporters$2(this, importerClass)));
        this.importers().sort((o1, o2) -> o1.getClass().getSimpleName().compareTo(o2.getClass().getSimpleName()));
        this.importers().add((Importer)new XmlManifestDarImporter(this.repositoryService()));
        this.logger().debug("Importer {} registered.", XmlManifestDarImporter.class);
        this.logger().info("Importers configured in XL Deploy: {}", this.importers());
    }

    @Override
    public File getImportablePackageDirectory() {
        return this.importablePackageDirectory();
    }

    public void setImportablePackageDirectory(File importablePackageDirectory) {
        this.importablePackageDirectory_$eq(importablePackageDirectory);
    }

    @Override
    public java.util.List<String> listPackages() {
        return Lists.newArrayList((Iterable)CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(this.importers()).asScala().withFilter((Function1 & Serializable)importer -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$listPackages$1(importer))).flatMap((Function1 & Serializable)importer -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(((ListableImporter)importer).list(this.importablePackageDirectory())).asScala().map((Function1 & Serializable)pkgFound -> pkgFound))).sorted((Ordering)Ordering.String$.MODULE$)).asJava());
    }

    @Override
    public String importPackage(ImportSource source) {
        String string;
        block5: {
            try {
                Option option = CollectionConverters$.MODULE$.ListHasAsScala(this.importers()).asScala().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.canHandle(source)));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Importer importer = (Importer)some.value();
                    string = this.doImport(source, importer);
                    break block5;
                }
                if (None$.MODULE$.equals(option)) {
                    throw new ImporterException("The selected file does not have the expected format for an importable package", new Object[0]);
                }
                throw new MatchError((Object)option);
            }
            finally {
                source.cleanUp();
            }
        }
        return string;
    }

    public void checkPermission(Permission permission, String onConfigurationItems) {
        if (!permission.getPermissionHandler().hasPermission(onConfigurationItems)) {
            throw PermissionDeniedException.forPermission((Permission)permission, (String)onConfigurationItems);
        }
    }

    private String doImport(ImportSource source, Importer importer) {
        String string;
        DefaultImportingContext ctx = new DefaultImportingContext();
        PackageInfo packageInfo = importer.preparePackage(source, (ImportingContext)ctx);
        try {
            boolean upgrade = this.isUpgrade(packageInfo);
            this.checkPermission(upgrade, packageInfo);
            this.checkImported(packageInfo);
            ImportedPackage importedPackage = importer.importEntities(packageInfo, (ImportingContext)ctx);
            this.scanPlaceholders(importedPackage, ctx);
            HashSet toCreate = Sets.newHashSet();
            this.createEntities(importedPackage, upgrade, toCreate);
            this.logger().info("entities to create before filtering existing: " + toCreate.size() + ", " + toCreate);
            Set existing = this.repositoryService().selectExistingPaths(CollectionConverters$.MODULE$.MutableSetHasAsJava((scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala((Set)toCreate).asScala().map((Function1 & Serializable)c -> com.xebialabs.deployit.repository.sql.base.package$.MODULE$.idToPath(c.getId()))).asJava());
            existing.forEach(e -> toCreate.removeIf(c -> com.xebialabs.deployit.repository.sql.base.package$.MODULE$.idToPath(c.getId()).equals(e)));
            this.logger().info("entities to create after filtering existing : " + toCreate.size() + ", " + toCreate);
            this.validate(toCreate);
            if (upgrade) {
                importedPackage.getVersion().setApplication((Application)this.repositoryService().read(packageInfo.getApplicationId()));
            }
            CreateCisCommand event = new CreateCisCommand((java.util.List)Lists.newArrayList((Iterable)toCreate));
            this.repositoryHelper().publishCommand((RepositoryBaseCommand)event);
            string = importedPackage.getVersion().getId();
        }
        finally {
            importer.cleanUp(packageInfo, (ImportingContext)ctx);
        }
        return string;
    }

    private void scanPlaceholders(ImportedPackage importedPackage, ImportingContext ctx) {
        if (importedPackage.getVersion() instanceof DeploymentPackage) {
            ((java.util.List)ctx.getAttribute("temporaryFiles")).add(new TFile(Files.createTempDir()));
            CollectionConverters$.MODULE$.SetHasAsScala(package$.MODULE$.getAllArtifacts(importedPackage.getDeployables())).asScala().foreach((Function1 & Serializable)sourceArtifact -> {
                ImporterServiceImpl.$anonfun$scanPlaceholders$1(this, sourceArtifact);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void resolveAndEnrichArtifact(SourceArtifact sourceArtifact) {
        try {
            ResourceManagement$.MODULE$.using((Closeable)ArtifactResolverRegistry$.MODULE$.resolve(sourceArtifact), (Function1 & Serializable)resolve -> {
                ResourceManagement$.MODULE$.using((Closeable)resolve.openStream(), (Function1 & Serializable)is -> {
                    ImporterServiceImpl.$anonfun$resolveAndEnrichArtifact$2($this, sourceArtifact$1, resolve, is);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
        }
        catch (IOException iOException) {
            throw new ImporterException("Could not open stream of uri " + sourceArtifact.getFileUri() + " of unresolved artifact " + sourceArtifact, new Object[0]);
        }
    }

    private boolean isArtifactPreEnriched(SourceArtifact deployable) {
        boolean isPreEnrichedArtifact = PlaceholdersUtil$.MODULE$.SourceArtifactUtil(deployable).hasCheckSum() && deployable.hasProperty("preScannedPlaceholders") && BoxesRunTime.unboxToBoolean((Object)deployable.getProperty("preScannedPlaceholders"));
        this.logger().info("Artifact " + deployable + " is " + (isPreEnrichedArtifact ? "" : "not") + " pre-enriched");
        return isPreEnrichedArtifact;
    }

    private void checkImported(PackageInfo packageInfo) {
        String id = IdGenerator.generateId((String)packageInfo.getApplicationId(), (String)packageInfo.getApplicationVersion());
        if (this.repositoryService().exists(id)) {
            throw new ImporterException("Already imported version %s of application %s", packageInfo.getApplicationVersion(), packageInfo.getApplicationName());
        }
        String dirs = this.subStringBeforeLast(packageInfo.getApplicationId(), "/");
        if (!this.repositoryService().exists(dirs)) {
            throw new ImporterException("The directory structure [%s] specified for the import of application [%s] does not exist.", dirs, this.appName(packageInfo));
        }
        if (packageInfo.getApplicationName().contains("/")) {
            this.validateApplicationDirectoryStructure(packageInfo.getApplicationId());
            return;
        }
    }

    private void validateApplicationDirectoryStructure(String applicationId) {
        int lastSlashIndex = applicationId.lastIndexOf("/");
        if (lastSlashIndex > 0) {
            String parentPath = applicationId.substring(0, lastSlashIndex);
            ConfigurationItem parentCi = this.repositoryService().read(parentPath);
            if (parentCi.getType().instanceOf(Type.valueOf(Application.class))) {
                throw new ImporterException("Application [%s] cannot be created under [%s]. Creating applications within other applications is not supported.", applicationId, parentPath);
            }
            return;
        }
    }

    private void createEntities(ImportedPackage importedPackage, boolean isUpgrade, Set<ConfigurationItem> toCreateCollector) {
        Object object = !isUpgrade ? BoxesRunTime.boxToBoolean((boolean)toCreateCollector.add((ConfigurationItem)importedPackage.getApplication())) : BoxedUnit.UNIT;
        Version version = importedPackage.getVersion();
        toCreateCollector.add((ConfigurationItem)version);
        this.filterExistingPackages(version).withFilter((Function1 & Serializable)pd -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$createEntities$1(this, pd))).foreach((Function1 & Serializable)pd -> {
            ImporterServiceImpl.$anonfun$createEntities$2(this, version, toCreateCollector, pd);
            return BoxedUnit.UNIT;
        });
    }

    private scala.collection.immutable.Set<PropertyDescriptor> filterExistingPackages(Version version) {
        scala.collection.immutable.Set propertyDescriptors = CollectionConverters$.MODULE$.CollectionHasAsScala(version.getType().getDescriptor().getPropertyDescriptors()).asScala().toSet();
        if (!(version instanceof CompositePackage)) {
            return propertyDescriptors;
        }
        return (scala.collection.immutable.Set)propertyDescriptors.filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$filterExistingPackages$1(x$2)));
    }

    private void createNestedConfigurationItems(ConfigurationItem ci, Set<ConfigurationItem> toCreateCollector) {
        Collection propertyDescriptors = ci.getType().getDescriptor().getPropertyDescriptors();
        CollectionConverters$.MODULE$.CollectionHasAsScala(propertyDescriptors).asScala().withFilter((Function1 & Serializable)propertyDescriptor -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$createNestedConfigurationItems$1(this, propertyDescriptor))).foreach((Function1 & Serializable)propertyDescriptor -> {
            ImporterServiceImpl.$anonfun$createNestedConfigurationItems$2(this, ci, toCreateCollector, propertyDescriptor);
            return BoxedUnit.UNIT;
        });
    }

    private void validate(Set<ConfigurationItem> toCreate) {
        Seq msgs = (Seq)CollectionConverters$.MODULE$.SetHasAsScala(toCreate).asScala().foldLeft((Object)scala.package$.MODULE$.Seq().empty(), (Function2 & Serializable)(acc, tc) -> {
            Seq validated = CollectionConverters$.MODULE$.ListHasAsScala(this.validator().validate(tc, (java.util.List)Lists.newArrayList((Iterable)toCreate))).asScala().toSeq();
            if (validated.nonEmpty()) {
                return (Seq)acc.$plus$plus((IterableOnce)validated);
            }
            return acc;
        });
        if (msgs.nonEmpty()) {
            throw new ImporterException("Import failed with the following validation errors %s", msgs.mkString(", "));
        }
    }

    private boolean isUpgrade(PackageInfo packageInfo) {
        boolean locationSpecified = packageInfo.getApplicationName().contains("/");
        List applications = CollectionConverters$.MODULE$.ListHasAsScala(this.repositoryService().list(new SearchParameters().setType(Type.valueOf(Application.class)).setName(this.appName(packageInfo)).setAncestor(packageInfo.getApplicationRoot()))).asScala().toList();
        boolean bl = false;
        .colon.colon colon2 = null;
        List list = applications;
        if (Nil$.MODULE$.equals(list)) {
            return false;
        }
        if (list instanceof .colon.colon) {
            bl = true;
            colon2 = (.colon.colon)list;
            ConfigurationItemData app = (ConfigurationItemData)colon2.head();
            List list2 = colon2.next$access$1();
            if (Nil$.MODULE$.equals(list2) && locationSpecified) {
                String string = app.getId();
                String string2 = packageInfo.getApplicationId();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    throw new ImporterException("The manifest contains the path [%s] to import the application into, but the application exists at the path [%s]", packageInfo.getApplicationId(), app.getId());
                }
            }
        }
        if (bl) {
            ConfigurationItemData app = (ConfigurationItemData)colon2.head();
            List list3 = colon2.next$access$1();
            if (Nil$.MODULE$.equals(list3)) {
                String appId = app.getId();
                packageInfo.setDirectories(appId.substring(packageInfo.getApplicationRoot().length(), appId.length() - packageInfo.getApplicationName().length()));
                return true;
            }
        }
        if (bl) {
            ConfigurationItemData app = (ConfigurationItemData)colon2.head();
            throw new IllegalStateException("Found more than 1 [" + app.getType() + "] with the same name: [" + applications.mkString(", ") + "]");
        }
        throw new MatchError((Object)list);
    }

    private String appName(PackageInfo packageInfo) {
        return this.subStringAfterLast(packageInfo.getApplicationId(), "/");
    }

    private String subStringAfterLast(String s, String sep) {
        if (!s.contains(sep)) {
            return s;
        }
        return s.substring(s.lastIndexOf(sep) + sep.length());
    }

    private String subStringBeforeLast(String s, String sep) {
        if (!s.contains(sep)) {
            return s;
        }
        return s.substring(0, s.lastIndexOf(sep));
    }

    private void checkPermission(boolean isUpgrade, PackageInfo packageInfo) {
        Permission requiredPermission = isUpgrade ? DeployitPermissions$.MODULE$.IMPORT_UPGRADE() : DeployitPermissions$.MODULE$.IMPORT_INITIAL();
        this.checkPermission(requiredPermission, packageInfo.getApplicationId());
    }

    public static final /* synthetic */ boolean $anonfun$isCollectionKind$1(PropertyKind kind) {
        return kind == PropertyKind.SET_OF_CI || kind == PropertyKind.LIST_OF_CI;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$initImporters$1(Class cls) {
        if (cls.isInterface()) return false;
        if (Modifier.isAbstract(cls.getModifiers())) return false;
        Class clazz = cls;
        Class<XmlManifestDarImporter> clazz2 = XmlManifestDarImporter.class;
        if (clazz == null) {
            if (clazz2 == null) return false;
            return true;
        } else if (clazz.equals(clazz2)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$initImporters$2(ImporterServiceImpl $this, Class importerClass) {
        boolean bl;
        try {
            $this.logger().debug("Importer {} registered.", (Object)importerClass);
            bl = $this.importers().add((Importer)importerClass.newInstance());
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not instantiate importer: " + importerClass, e);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$listPackages$1(Importer importer) {
        return importer instanceof ListableImporter;
    }

    public static final /* synthetic */ void $anonfun$scanPlaceholders$1(ImporterServiceImpl $this, SourceArtifact sourceArtifact) {
        if (ArtifactFileUtils.hasRealOrResolvedFile((Artifact)sourceArtifact)) {
            $this.logger().info("Artifact {} is a resolved artifact", (Object)sourceArtifact);
            if (!$this.isArtifactPreEnriched(sourceArtifact)) {
                PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sourceArtifact).addChecksumAndScan($this.scanner(), (Function0 & Serializable)() -> $this.checksumAlgorithmProvider().getMessageDigest());
                return;
            }
            return;
        }
        $this.logger().info("Resolving artifact " + sourceArtifact + " from url " + sourceArtifact.getFileUri());
        $this.resolveAndEnrichArtifact(sourceArtifact);
    }

    public static final /* synthetic */ void $anonfun$resolveAndEnrichArtifact$2(ImporterServiceImpl $this, SourceArtifact sourceArtifact$1, ResolvedArtifactFile resolve$1, InputStream is) {
        if (!$this.isArtifactPreEnriched(sourceArtifact$1)) {
            PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sourceArtifact$1).addChecksumAndScan($this.scanner(), resolve$1.getFileName(), is, (Function0 & Serializable)() -> $this.checksumAlgorithmProvider().getMessageDigest());
        }
        sourceArtifact$1.setFile(LocalFile.valueOf((File)new File(resolve$1.getFileName())));
    }

    public static final /* synthetic */ boolean $anonfun$createEntities$1(ImporterServiceImpl $this, PropertyDescriptor pd) {
        return BoxesRunTime.unboxToBoolean((Object)$this.isCollectionKind().apply((Object)pd.getKind()));
    }

    public static final /* synthetic */ void $anonfun$createEntities$2(ImporterServiceImpl $this, Version version$1, Set toCreateCollector$1, PropertyDescriptor pd) {
        Collection cis = (Collection)pd.get((ConfigurationItem)version$1);
        toCreateCollector$1.addAll(Sets.newHashSet((Iterable)cis));
        cis.forEach(ci -> $this.createNestedConfigurationItems((ConfigurationItem)ci, toCreateCollector$1));
    }

    public static final /* synthetic */ boolean $anonfun$filterExistingPackages$1(PropertyDescriptor x$2) {
        String string = x$2.getName();
        String string2 = "packages";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createNestedConfigurationItems$1(ImporterServiceImpl $this, PropertyDescriptor propertyDescriptor) {
        return BoxesRunTime.unboxToBoolean((Object)$this.isCollectionKind().apply((Object)propertyDescriptor.getKind())) && !propertyDescriptor.getName().toLowerCase().contains("dependencies");
    }

    public static final /* synthetic */ boolean $anonfun$createNestedConfigurationItems$3(Set toCreateCollector$2, ConfigurationItem embedded) {
        return !toCreateCollector$2.contains(embedded);
    }

    public static final /* synthetic */ void $anonfun$createNestedConfigurationItems$4(ImporterServiceImpl $this, Set toCreateCollector$2, ConfigurationItem embedded) {
        toCreateCollector$2.add(embedded);
        $this.createNestedConfigurationItems(embedded, toCreateCollector$2);
    }

    public static final /* synthetic */ void $anonfun$createNestedConfigurationItems$2(ImporterServiceImpl $this, ConfigurationItem ci$1, Set toCreateCollector$2, PropertyDescriptor propertyDescriptor) {
        CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)propertyDescriptor.get(ci$1)).asScala().withFilter((Function1 & Serializable)embedded -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$createNestedConfigurationItems$3(toCreateCollector$2, embedded))).foreach((Function1 & Serializable)embedded -> {
            ImporterServiceImpl.$anonfun$createNestedConfigurationItems$4($this, toCreateCollector$2, embedded);
            return BoxedUnit.UNIT;
        });
    }

    @Autowired
    public ImporterServiceImpl(RepositoryService repositoryService, RoleService roleService, Validator validator, SourceArtifactScanner scanner, ClientProperties clientConfiguration, RepositoryHelper repositoryHelper, ChecksumAlgorithmProvider checksumAlgorithmProvider) {
        this.repositoryService = repositoryService;
        this.roleService = roleService;
        this.validator = validator;
        this.scanner = scanner;
        this.clientConfiguration = clientConfiguration;
        this.repositoryHelper = repositoryHelper;
        this.checksumAlgorithmProvider = checksumAlgorithmProvider;
        this.importers = Lists.newArrayList();
        this.logger = LoggerFactory.getLogger(ImporterServiceImpl.class);
        this.isCollectionKind = (Function1 & Serializable)kind -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$isCollectionKind$1(kind));
        this.importablePackageDirectory = new File(this.clientConfiguration().getImportablePackageDirectory());
    }
}

