package com.xebialabs.deployit.security.policy

import org.springframework.security.core.Authentication
import org.springframework.stereotype.Component

@Component
class DefaultUserGroupMembershipCreationPolicy extends UserGroupMembershipCreationPolicy {

  override def order(): Int = 1000 // Is the default catch-all policy, should be last to try out

  override def policyApplies(authentication: Authentication): Boolean = true // catch-all

  override def updateUserGroupMembership(authentication: Authentication): Unit = {
    // no-op
  }
}
