package com.xebialabs.deployit.service.deployment;

import ai.digital.deploy.core.common.TypeCalculator;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeFilterDeployedGenerator extends AbstractChainGenerator {

    private static final Logger logger = LoggerFactory.getLogger(TypeFilterDeployedGenerator.class);

    public TypeFilterDeployedGenerator(DeployedGenerator processor) {
        super(processor);
    }

    @Override
    public GeneratedDeployeds generateDeployed(DeploymentContext deploymentContext, Deployable deployable, Container container) {
        TypeCalculator typeCalculator = deploymentContext.getBeanSupplier().getBean(TypeCalculator.class);
        Type deployedType = deploymentContext.getTypeSupplier().getType(deployable, container);
        if (deployedType != null && typeCalculator.findDeployedTypesForDeployableAndContainerTypes(deployable.getType(), container.getType()).contains(deployedType)) {
            GeneratedDeployeds generatedDeployeds = nextGenerator.generateDeployed(deploymentContext, deployable, container);
            logger.debug("'{}' generated following deployeds [{}]", nextGenerator.getClass().getName(), generatedDeployeds);
            return generatedDeployeds;
        }
        return new GeneratedDeployeds();
    }
}
