package com.xebialabs.deployit.security.policy

import com.xebialabs.deployit.service.profile.{XldUserGroupServiceHolder}
import org.springframework.security.core.Authentication
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class ExternalUserGroupMembershipCreationPolicy
  extends UserGroupMembershipCreationPolicy {

  override def order(): Int = 20

  override def policyApplies(authentication: Authentication): Boolean = {
    null != authentication &&
      null != authentication.getPrincipal &&
      !authentication.getPrincipal.isInstanceOf[String]
  }

  override def updateUserGroupMembership(authentication: Authentication): Unit = {
    val username = authentication.getName
    val groups = authentication.getAuthorities.asScala.map(_.getAuthority).toSet
    XldUserGroupServiceHolder.getXldGroupService.updateGroupsMembershipForUser(username, groups)
  }
}
