/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.principaldata;

import com.xebialabs.deployit.security.principaldata.LdapDataHelper;
import com.xebialabs.deployit.security.principaldata.UserData;
import com.xebialabs.deployit.security.principaldata.UserDataProvider;
import java.lang.reflect.Method;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.authentication.AbstractLdapAuthenticator;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.search.LdapUserSearch;

class LdapUserDataProvider
implements UserDataProvider {
    private static final Logger logger = LoggerFactory.getLogger(LdapUserDataProvider.class);
    private final String mailAttribute = "mail";
    private final String displayNameAttribute = "displayName";
    private LdapUserSearch userSearch;

    public LdapUserDataProvider(LdapAuthenticationProvider authProvider) {
        try {
            BindAuthenticator authenticator = LdapUserDataProvider.invokePrivateMethod(authProvider, LdapAuthenticationProvider.class, "getAuthenticator", BindAuthenticator.class);
            this.userSearch = LdapUserDataProvider.invokePrivateMethod(authenticator, AbstractLdapAuthenticator.class, "getUserSearch", LdapUserSearch.class);
        }
        catch (Exception ex) {
            logger.warn("Error constructing LdapDataProviderBase", (Throwable)ex);
        }
    }

    public LdapUserDataProvider(LdapUserSearch userSearch) {
        this.userSearch = userSearch;
    }

    private static <T, R> R invokePrivateMethod(Object target, Class<T> targetClass, String methodName, Class<R> returnType) throws Exception {
        Method method = targetClass.getDeclaredMethod(methodName, new Class[0]);
        method.setAccessible(true);
        return returnType.cast(method.invoke(target, new Object[0]));
    }

    @Override
    public UserData getUserData(String username) {
        return this.searchForUserData(username).map(data -> {
            String email = LdapDataHelper.readStringAttribute(username, data, "mail");
            String fullName = LdapDataHelper.readStringAttribute(username, data, "displayName");
            return new UserData(email, fullName);
        }).orElse(UserData.NOT_FOUND);
    }

    private Optional<DirContextOperations> searchForUserData(String username) {
        try {
            return Optional.ofNullable(this.userSearch.searchForUser(username));
        }
        catch (UsernameNotFoundException e) {
            logger.info("User with username: {} not found", (Object)username);
        }
        catch (Exception e) {
            logger.warn("Error accessing LDAP server", (Throwable)e);
        }
        return Optional.empty();
    }
}

