package com.xebialabs.deployit.service.profile

import java.util.concurrent.atomic.AtomicReference

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

object ProfileServiceHolder {
  val profileService: AtomicReference[ProfileService] = new AtomicReference[ProfileService]()
  def getProfileService: ProfileService = profileService.get()
}

@Component
class ProfileServiceHolder {
  @Autowired
  def this(profileService: ProfileService) = {
    this()
    ProfileServiceHolder.profileService.set(profileService)
  }
}
