package com.xebialabs.deployit.service.importer.source;

import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.util.GuavaFiles;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamSource implements ImportSource {

    private final String fileName;
    private final InputStream stream;

    private FileSource file;
    private final File tempDir;

    public InputStreamSource(String fileName, InputStream stream) {
        this.fileName = fileName;
        this.stream = stream;
        tempDir = Files.createTempDir();
    }

    @Override
    public File getFile() {
        if (file == null) {
            streamToTempFile();
        }

        return file.getFile();
    }

    private void streamToTempFile() {
        try {
            String fileNameCopy = this.fileName;
            int slash = fileNameCopy.lastIndexOf('/');
            if (slash != -1 && slash != fileNameCopy.length() - 1) {
                fileNameCopy = fileNameCopy.substring(slash);
            }

            final File tempFile = new File(tempDir, fileNameCopy);
            new ByteSource() {
                @Override
                public InputStream openStream() throws IOException {
                    return stream;
                }
            }.copyTo(Files.asByteSink(tempFile));
            file = new FileSource(tempFile, true);
        } catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void cleanUp() {
        if (file != null) {
            file.cleanUp();
        }
        GuavaFiles.deleteQuietly(tempDir);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[" + (file != null ? file : "no file on disk") + "]";
    }
}
