package com.xebialabs.deployit.security.principaldata

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.util.concurrent.atomic.AtomicReference

object PrincipalDataProviderHolder {
  val principalDataProvider: AtomicReference[PrincipalDataProvider] = new AtomicReference[PrincipalDataProvider]()
  def getPrincipalDataProvider: PrincipalDataProvider = principalDataProvider.get()
}

@Component
class PrincipalDataProviderHolder {
  @Autowired
  def this(principalDataProvider: PrincipalDataProvider) = {
    this()
    PrincipalDataProviderHolder.principalDataProvider.set(principalDataProvider)
  }
}
