package com.xebialabs.deployit.listener.authentication

import com.xebialabs.deployit.engine.spi.event.{DeployitEventListener, LoginEvent}
import com.xebialabs.deployit.service.profile.{ProfileServiceHolder, XldUserProfileServiceHolder}
import grizzled.slf4j.Logging
import nl.javadude.t2bus.Subscribe

@DeployitEventListener
class LoginEventListener extends Logging {
  @Subscribe
  def receiveLoginEvent(loginEvent: LoginEvent): Unit = {
    ProfileServiceHolder.getProfileService.registerLoginTime(loginEvent.getUsername)
    XldUserProfileServiceHolder.getXldUserProfileService.registerLoginTime(loginEvent.getUsername)
  }
}
