/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.plugin.api.deployment.ResolvedPlaceholder;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployedContainer;
import com.xebialabs.deployit.service.deployment.DeployedApplicationFactory;
import com.xebialabs.deployit.service.deployment.DeployedGenerator;
import com.xebialabs.deployit.service.deployment.DeploymentContext;
import com.xebialabs.deployit.service.deployment.GeneratedDeployeds;
import com.xebialabs.deployit.service.deployment.ResolvedPlaceholderGenerator;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import com.xebialabs.deployit.service.replacement.DictionaryValueException;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderScanner;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BasicDeployedGenerator
implements DeployedGenerator {
    private static final Logger logger = LoggerFactory.getLogger(BasicDeployedGenerator.class);

    BasicDeployedGenerator() {
    }

    @Override
    public GeneratedDeployeds generateDeployed(DeploymentContext deploymentContext, Deployable deployable, Container container) {
        Type deployedType = deploymentContext.getTypeSupplier().getType(deployable, container);
        GeneratedDeployeds generatedDeployeds = new GeneratedDeployeds();
        if (deployedType != null) {
            generatedDeployeds.addDeployed(this.basicDeployed(deploymentContext, deployable, container, deployedType));
        }
        return generatedDeployeds;
    }

    private Deployed basicDeployed(DeploymentContext deploymentContext, Deployable deployable, Container container, Type deployedType) {
        Descriptor deployedDesc = DescriptorRegistry.getDescriptor((Type)deployedType);
        ConsolidatedDictionary dictionary = deploymentContext.dictionaryFilteredByContainer(container);
        Deployed deployed = (Deployed)deployedDesc.newInstance(this.deployedId(deploymentContext, deployable, container));
        deployed.setDeployable(deployable);
        deployed.setContainer(container);
        try {
            dictionary.resolveDeployedName((EmbeddedDeployedContainer)deployed);
        }
        catch (DictionaryValueException e) {
            throw new DeployedApplicationFactory.IncorrectDeployedException(e, "Couldn't generate name for deployed from [%s]", deployable.getName());
        }
        logger.debug("'{}' generated following deployeds [{}]", (Object)this.getClass().getName(), (Object)deployed.getName());
        DeployedApplication deployedApplication = deploymentContext.getDeployedApplication();
        Set<ResolvedPlaceholder> resolvedPlaceholders = ResolvedPlaceholderGenerator.generate(deployedApplication, dictionary, container.getId());
        deployedApplication.add$ResolvedPlaceholders(resolvedPlaceholders);
        return deployed;
    }

    private String deployedId(DeploymentContext deploymentContext, Deployable deployable, Container container) {
        boolean deployableNameHasPlaceholders = MustachePlaceholderScanner.hasPlaceholders((String)deployable.getName());
        Optional<Deployed> existingDeployed = deploymentContext.getExistingDeployedSupplier().getExistingDeployedWithContainer(deployable, container);
        if (!existingDeployed.isPresent() || deployableNameHasPlaceholders) {
            return deploymentContext.getDeployedIdGenerator().generatedId(container, deployable);
        }
        return existingDeployed.get().getId();
    }
}

