package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TagMatchingDeployedGenerator extends AbstractChainGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(TagMatchingDeployedGenerator.class);

    private final TagMatcher tagMatcher;
    private final DeployedGenerator processor;

    public TagMatchingDeployedGenerator(DeployedGenerator processor) {
        super(processor);
        this.tagMatcher = new TagMatcher();
        this.processor = processor;
    }

    @Override
    public GeneratedDeployeds generateDeployed(DeploymentContext deploymentContext, Deployable deployable, Container container) {
        if(tagMatcher.areMatching(deployable, container)) {
            return processor.generateDeployed(deploymentContext, deployable, container);
        } else {
            LOG.debug("Tags do NOT match for {} and {}", deployable.getId(), container.getId());
            return new GeneratedDeployeds();
        }
    }
}
