/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.controltask;

import ai.digital.deploy.task.status.queue.TaskPathStatusListener;
import ai.digital.deploy.tasker.common.TaskType;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.deployment.planner.ExecutablePlan;
import com.xebialabs.deployit.deployment.planner.PhasedPlan;
import com.xebialabs.deployit.deployment.planner.PlanPhase;
import com.xebialabs.deployit.deployment.planner.Plans$;
import com.xebialabs.deployit.deployment.planner.Satellites$;
import com.xebialabs.deployit.deployment.planner.SerialPlan;
import com.xebialabs.deployit.deployment.planner.StepPlan;
import com.xebialabs.deployit.engine.api.dto.Control;
import com.xebialabs.deployit.engine.spi.event.TaskCreatedEvent;
import com.xebialabs.deployit.engine.spi.event.TaskStartedEvent;
import com.xebialabs.deployit.engine.tasker.PhaseContainer;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.OnTaskFailurePolicy;
import com.xebialabs.deployit.plugin.api.udm.OnTaskSuccessPolicy;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItemWithPolicies;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.deployit.service.controltask.ControlTaskService;
import com.xebialabs.deployit.service.controltask.InvalidControlException;
import com.xebialabs.deployit.service.externalproperties.ExternalPropertiesResolver;
import com.xebialabs.deployit.spring.BeanWrapper;
import com.xebialabs.deployit.task.WorkdirCleanerTrigger;
import com.xebialabs.xlplatform.satellite.Satellite;
import com.xebialabs.xlplatform.satellite.SatelliteAware;
import java.io.Serializable;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@Component
@ScalaSignature(bytes="\u0006\u0005\t\rb\u0001B\n\u0015\u0001}A\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!\f\u0005\ti\u0001\u0011\t\u0011)A\u0005]!AQ\u0007\u0001BC\u0002\u0013\u0005a\u0007\u0003\u0005>\u0001\t\u0005\t\u0015!\u00038\u0011!q\u0004A!b\u0001\n\u0003y\u0004\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u00119\u0003!Q1A\u0005\u0002=C\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\u0006)\u0002!\t!\u0016\u0005\u0006[\u0002!\tE\u001c\u0005\b\u0003#\u0001A\u0011IA\n\u0011\u001d\ty\b\u0001C!\u0003\u0003Cq!a#\u0001\t\u0003\ni\t\u0003\u0005\u0002\u001c\u0002!\t\u0001FAO\u0011!\t\u0019\u000e\u0001Q\u0005\n\u0005U\u0007\u0002CAy\u0001\u0001&I!a=\t\u0011\t\u0005\u0001\u0001)C\u0005\u0005\u0007A\u0001B!\u0001\u0001A\u0013%!1\u0002\u0002\u0017\u0007>tGO]8m)\u0006\u001c8nU3sm&\u001cW-S7qY*\u0011QCF\u0001\fG>tGO]8mi\u0006\u001c8N\u0003\u0002\u00181\u000591/\u001a:wS\u000e,'BA\r\u001b\u0003!!W\r\u001d7ps&$(BA\u000e\u001d\u0003%AXMY5bY\u0006\u00147OC\u0001\u001e\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0001\u0005\u000b\t\u0003C\u0019j\u0011A\t\u0006\u0003G\u0011\nA\u0001\\1oO*\tQ%\u0001\u0003kCZ\f\u0017BA\u0014#\u0005\u0019y%M[3diB\u0011\u0011FK\u0007\u0002)%\u00111\u0006\u0006\u0002\u0013\u0007>tGO]8m)\u0006\u001c8nU3sm&\u001cW-A\tsKB|7/\u001b;pef\u001cVM\u001d<jG\u0016,\u0012A\f\t\u0003_Ij\u0011\u0001\r\u0006\u0003ca\t!B]3q_NLGo\u001c:z\u0013\t\u0019\u0004GA\tSKB|7/\u001b;pef\u001cVM\u001d<jG\u0016\f!C]3q_NLGo\u001c:z'\u0016\u0014h/[2fA\u0005QR\r\u001f;fe:\fG\u000e\u0015:pa\u0016\u0014H/[3t%\u0016\u001cx\u000e\u001c<feV\tq\u0007\u0005\u00029w5\t\u0011H\u0003\u0002;-\u0005\u0011R\r\u001f;fe:\fG\u000e\u001d:pa\u0016\u0014H/[3t\u0013\ta\u0014H\u0001\u000eFqR,'O\\1m!J|\u0007/\u001a:uS\u0016\u001c(+Z:pYZ,'/A\u000efqR,'O\\1m!J|\u0007/\u001a:uS\u0016\u001c(+Z:pYZ,'\u000fI\u0001\u0007K:<\u0017N\\3\u0016\u0003\u0001\u00032!\u0011#G\u001b\u0005\u0011%BA\"\u0019\u0003\u0019\u0019\bO]5oO&\u0011QI\u0011\u0002\f\u0005\u0016\fgn\u0016:baB,'\u000f\u0005\u0002H\u00176\t\u0001J\u0003\u0002J\u0015\u00061A/Y:lKJT!A\u0010\r\n\u00051C%a\u0005+bg.,\u00050Z2vi&|g.\u00128hS:,\u0017aB3oO&tW\rI\u0001\u000fo>\u00148\u000eR5s\r\u0006\u001cGo\u001c:z+\u0005\u0001\u0006CA\u0018R\u0013\t\u0011\u0006G\u0001\bX_J\\G)\u001b:GC\u000e$xN]=\u0002\u001f]|'o\u001b#je\u001a\u000b7\r^8ss\u0002\na\u0001P5oSRtD#\u0002,XO&\\\u0007CA\u0015\u0001\u0011\u0015a\u0013\u00021\u0001/Q\t9\u0016\f\u0005\u0002[K6\t1L\u0003\u0002];\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005y{\u0016a\u00024bGR|'/\u001f\u0006\u0003A\u0006\fQAY3b]NT!AY2\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011\u0001Z\u0001\u0004_J<\u0017B\u00014\\\u0005%\tU\u000f^8xSJ,G\rC\u00036\u0013\u0001\u0007q\u0007\u000b\u0002h3\")a(\u0003a\u0001\u0001\"\u0012\u0011.\u0017\u0005\u0006\u001d&\u0001\r\u0001\u0015\u0015\u0003Wf\u000bq\u0001\u001d:fa\u0006\u0014X\r\u0006\u0003po\u00065\u0001C\u00019v\u001b\u0005\t(B\u0001:t\u0003\r!Go\u001c\u0006\u0003i*\u000b1!\u00199j\u0013\t1\u0018OA\u0004D_:$(o\u001c7\t\u000baT\u0001\u0019A=\u0002\u0017\r|g\u000e\u001e:pY:\u000bW.\u001a\t\u0004u\u0006\u001dabA>\u0002\u0004A\u0011Ap`\u0007\u0002{*\u0011aPH\u0001\u0007yI|w\u000e\u001e \u000b\u0005\u0005\u0005\u0011!B:dC2\f\u0017bAA\u0003\u007f\u00061\u0001K]3eK\u001aLA!!\u0003\u0002\f\t11\u000b\u001e:j]\u001eT1!!\u0002\u0000\u0011\u0019\tyA\u0003a\u0001s\u0006\u0011\u0011\u000eZ\u0001\u000fGJ,\u0017\r^3UCN\\7\u000b]3d)1\t)\"a\u0007\u0002&\u0005m\u0012\u0011MA6!\r9\u0015qC\u0005\u0004\u00033A%!\u0005+bg.\u001c\u0006/Z2jM&\u001c\u0017\r^5p]\"9\u0011QD\u0006A\u0002\u0005}\u0011aB<pe.$\u0015N\u001d\t\u0004_\u0005\u0005\u0012bAA\u0012a\t9qk\u001c:l\t&\u0014\bbBA\u0014\u0017\u0001\u0007\u0011\u0011F\u0001\u0003G&\u0004B!a\u000b\u000285\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$A\u0002vI6T1\u0001^A\u001a\u0015\r\t)\u0004G\u0001\u0007a2,x-\u001b8\n\t\u0005e\u0012Q\u0006\u0002\u0012\u0007>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016l\u0007bBA\u001f\u0017\u0001\u0007\u0011qH\u0001\u0010G>tGO]8m)\u0006\u001c8NT1nKB!\u0011\u0011IA.\u001d\u0011\t\u0019%a\u0016\u000f\t\u0005\u0015\u0013Q\u000b\b\u0005\u0003\u000f\n\u0019F\u0004\u0003\u0002J\u0005Ec\u0002BA&\u0003\u001fr1\u0001`A'\u0013\u0005i\u0012BA\u000e\u001d\u0013\tI\"$\u0003\u0002?1%\u0011\u0011JS\u0005\u0004\u00033B\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003;\nyF\u0001\u0004UCN\\\u0017\n\u001a\u0006\u0004\u00033B\u0005bBA2\u0017\u0001\u0007\u0011QM\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\t\u0005-\u0012qM\u0005\u0005\u0003S\niC\u0001\u0006QCJ\fW.\u001a;feNDq!!\u001c\f\u0001\u0004\ty'A\u0003po:,'\u000f\u0005\u0003\u0002r\u0005mTBAA:\u0015\u0011\t)(a\u001e\u0002\t\r|'/\u001a\u0006\u0004\u0003s\n\u0017\u0001C:fGV\u0014\u0018\u000e^=\n\t\u0005u\u00141\u000f\u0002\u000f\u0003V$\b.\u001a8uS\u000e\fG/[8o\u0003\u0019\u0019'/Z1uKR9\u00110a!\u0002\b\u0006%\u0005BBAC\u0019\u0001\u0007q.A\u0004d_:$(o\u001c7\t\u000f\u00055D\u00021\u0001\u0002p!9\u0011Q\u0004\u0007A\u0002\u0005}\u0011!B:uCJ$H\u0003BAH\u0003/\u0003B!!%\u0002\u00146\tq0C\u0002\u0002\u0016~\u0014A!\u00168ji\"1\u0011\u0011T\u0007A\u0002e\fa\u0001^1tW&#\u0017A\u00052vS2$W\t_3dkRLwN\u001c)mC:$\u0002\"a(\u00020\u0006E\u00161\u0017\t\u0005\u0003C\u000bY+\u0004\u0002\u0002$*!\u0011QUAT\u0003\u001d\u0001H.\u00198oKJT1!!+\u0019\u0003)!W\r\u001d7ps6,g\u000e^\u0005\u0005\u0003[\u000b\u0019K\u0001\bFq\u0016\u001cW\u000f^1cY\u0016\u0004F.\u00198\t\u000f\u0005\u001db\u00021\u0001\u0002*!1\u0011Q\b\bA\u0002eDq!!.\u000f\u0001\u0004\t9,A\u0003ti\u0016\u00048\u000f\u0005\u0004\u0002:\u0006\u0005\u0017q\u0019\b\u0005\u0003w\u000byLD\u0002}\u0003{K!!!\u0001\n\u0007\u0005es0\u0003\u0003\u0002D\u0006\u0015'\u0001\u0002'jgRT1!!\u0017\u0000!\u0011\tI-a4\u000e\u0005\u0005-'\u0002BAg\u0003c\tAA\u001a7po&!\u0011\u0011[Af\u0005\u0011\u0019F/\u001a9\u0002\u001fM\fG/\u001a7mSR,wJZ*uKB$B!a6\u0002nB1\u0011\u0011SAm\u0003;L1!a7\u0000\u0005\u0019y\u0005\u000f^5p]B!\u0011q\\Au\u001b\t\t\tO\u0003\u0003\u0002d\u0006\u0015\u0018!C:bi\u0016dG.\u001b;f\u0015\r\t9OG\u0001\u000bq2\u0004H.\u0019;g_Jl\u0017\u0002BAv\u0003C\u0014\u0011bU1uK2d\u0017\u000e^3\t\u000f\u0005=x\u00021\u0001\u0002H\u0006!1\u000f^3q\u00031\t7\u000f\u00155bg\u0016$\u0007\u000b\\1o)\u0019\t)0a?\u0002~B!\u0011\u0011UA|\u0013\u0011\tI0a)\u0003\u0015AC\u0017m]3e!2\fg\u000e\u0003\u0004\u0002>A\u0001\r!\u001f\u0005\b\u0003\u007f\u0004\u0002\u0019AAP\u0003\u0011\u0001H.\u00198\u0002\u001d\u0011,7o\u0019:jaRLwN\u001c$peR9\u0011P!\u0002\u0003\b\t%\u0001bBA\u0014#\u0001\u0007\u0011\u0011\u0006\u0005\u0007\u0003{\t\u0002\u0019A=\t\u000f\u0005\r\u0018\u00031\u0001\u0002XR1!Q\u0002B\t\u0005'\u00012!\tB\b\u0013\r\tIA\t\u0005\b\u0003O\u0011\u0002\u0019AA\u0015\u0011\u0019\tiD\u0005a\u0001s\"\u001a\u0001Aa\u0006\u0011\t\te!qD\u0007\u0003\u00057Q1A!\bb\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0005C\u0011YBA\u0005D_6\u0004xN\\3oi\u0002")
public class ControlTaskServiceImpl
implements ControlTaskService {
    private final RepositoryService repositoryService;
    private final ExternalPropertiesResolver externalPropertiesResolver;
    private final BeanWrapper<TaskExecutionEngine> engine;
    private final WorkDirFactory workDirFactory;

    @Override
    public void createAndStart(String controlName, String id, Authentication owner, WorkDir workDir) {
        ControlTaskService.super.createAndStart(controlName, id, owner, workDir);
    }

    public RepositoryService repositoryService() {
        return this.repositoryService;
    }

    public ExternalPropertiesResolver externalPropertiesResolver() {
        return this.externalPropertiesResolver;
    }

    public BeanWrapper<TaskExecutionEngine> engine() {
        return this.engine;
    }

    public WorkDirFactory workDirFactory() {
        return this.workDirFactory;
    }

    @Override
    public Control prepare(String controlName, String id) {
        ConfigurationItem configurationItem = this.repositoryService().read(id);
        this.externalPropertiesResolver().resolveExternalProperties(new ConfigurationItem[]{configurationItem});
        MethodDescriptor controlTask = (MethodDescriptor)Option$.MODULE$.apply((Object)configurationItem.getType().getDescriptor().getControlTask(controlName)).getOrElse((Function0 & Serializable)() -> {
            throw new InvalidControlException("Control [%s] could  not be found on type [%s]", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{controlName, configurationItem.getType()}));
        });
        None$ params = controlTask.getParameterObjectType() != null ? Option$.MODULE$.apply((Object)controlTask.getParameterObjectType().getDescriptor().newInstance("parameters")) : None$.MODULE$;
        return new Control(configurationItem, controlName, (Parameters)params.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @Override
    public TaskSpecification createTaskSpec(WorkDir workDir, ConfigurationItem ci, String controlTaskName, Parameters params, Authentication owner) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        MethodDescriptor method = DescriptorRegistry.getDescriptor((Type)ci.getType()).getControlTask(controlTaskName);
        Checks.checkArgument((method != null ? 1 : 0) != 0, (String)"ConfigurationItem %s of type %s does not have a control task named %s.", (Object[])new Object[]{ci.getId(), ci.getType(), controlTaskName});
        java.util.List steps = (java.util.List)method.invoke(ci, params);
        ConfigurationItem configurationItem = ci;
        if (configurationItem instanceof BaseConfigurationItemWithPolicies) {
            BaseConfigurationItemWithPolicies baseConfigurationItemWithPolicies = (BaseConfigurationItemWithPolicies)configurationItem;
            tuple22 = new Tuple2((Object)baseConfigurationItemWithPolicies.getOnSuccessPolicy(), (Object)baseConfigurationItemWithPolicies.getOnFailurePolicy());
        } else {
            tuple22 = tuple2 = new Tuple2((Object)OnTaskSuccessPolicy.NOOP, (Object)OnTaskFailurePolicy.NOOP);
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        OnTaskSuccessPolicy onSuccessPolicy = (OnTaskSuccessPolicy)tuple2._1();
        OnTaskFailurePolicy onFailurePolicy = (OnTaskFailurePolicy)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)onSuccessPolicy, (Object)onFailurePolicy);
        OnTaskSuccessPolicy onSuccessPolicy2 = (OnTaskSuccessPolicy)tuple23._1();
        OnTaskFailurePolicy onFailurePolicy2 = (OnTaskFailurePolicy)tuple23._2();
        String desc = this.descriptionFor(ci, controlTaskName);
        PhasedPlan plan = this.asPhasedPlan(controlTaskName, this.buildExecutionPlan(ci, controlTaskName, (List<Step>)CollectionConverters$.MODULE$.ListHasAsScala(steps).asScala().toList()));
        PhasedPlan planForSatellites = Satellites$.MODULE$.prepareForSatelliteExecution(plan);
        PhaseContainer phaseContainer = Plans$.MODULE$.toBlockBuilder(planForSatellites).build();
        TaskSpecification taskSpec = new TaskSpecification(desc, owner, workDir, phaseContainer, onSuccessPolicy2, onFailurePolicy2);
        taskSpec.getListeners().add(new WorkdirCleanerTrigger(workDir));
        taskSpec.getListeners().add(new TaskPathStatusListener());
        ConfigurationItem currentCi = this.repositoryService().read(ci.getId());
        taskSpec.getMetadata().putAll(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"taskType"), (Object)TaskType.CONTROL.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"taskName"), (Object)controlTaskName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"taskLabel"), (Object)method.getLabel()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"controlTaskTargetCI"), (Object)ci.getId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"controlTaskTargetInternalCI"), (Object)currentCi.get$internalId().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"controlTaskTargetSecureCI"), Option$.MODULE$.apply((Object)currentCi.get$securedCi()).map((Function1 & Serializable)x$2 -> x$2.toString()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"controlTaskTargetDirectoryRef"), (Object)currentCi.get$securedDirectoryReference())}))).asJava());
        return taskSpec;
    }

    @Override
    public String create(Control control, Authentication owner, WorkDir workDir) {
        ConfigurationItem ci = control.getConfigurationItem();
        String controlTaskName = control.getControlName();
        Parameters params = control.getParameters();
        TaskSpecification taskSpec = this.createTaskSpec(workDir, ci, controlTaskName, params, owner);
        String taskId = ((TaskExecutionEngine)this.engine().get()).register(taskSpec);
        EventBusHolder.publish((Object)new TaskCreatedEvent(taskId, controlTaskName, ci.getId()));
        return taskId;
    }

    @Override
    public void start(String taskId) {
        ((TaskExecutionEngine)this.engine().get()).execute(taskId);
        EventBusHolder.publish((Object)new TaskStartedEvent(taskId));
    }

    public ExecutablePlan buildExecutionPlan(ConfigurationItem ci, String controlTaskName, List<Step> steps) {
        List<Step> list = steps;
        if (Nil$.MODULE$.equals(list)) {
            throw new IllegalStateException("Control task " + controlTaskName + " on " + ci.getId() + " resulted in no steps.");
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            Step head = (Step)colon2.head();
            Tuple2 tuple2 = new Tuple2(this.satelliteOfStep(head), ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Step[]{head})));
            List aggregator = Nil$.MODULE$.$colon$colon((Object)tuple2);
            List folded = (List)steps.drop(1).foldLeft((Object)aggregator, (Function2 & Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    List acc = (List)tuple2._1();
                    Step step = (Step)tuple2._2();
                    Object object = ((Tuple2)acc.headOption().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()))._1();
                    Option<Satellite> option = this.satelliteOfStep(step);
                    if (!(object != null ? !object.equals(option) : option != null)) {
                        ((Buffer)((Tuple2)acc.headOption().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()))._2()).append((Object)step);
                        return acc;
                    }
                }
                if (tuple2 != null) {
                    List acc = (List)tuple2._1();
                    Step step = (Step)tuple2._2();
                    Tuple2 tuple22 = new Tuple2(this.satelliteOfStep(step), ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Step[]{step})));
                    return acc.$colon$colon((Object)tuple22);
                }
                throw new MatchError((Object)tuple2);
            });
            List builders = folded.map((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    Option sat = (Option)tuple2._1();
                    ArrayBuffer ss = (ArrayBuffer)tuple2._2();
                    return new StepPlan(this.descriptionFor(ci, controlTaskName, (Option<Satellite>)sat), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ss.toList()).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Nil$.MODULE$).asJava(), (Satellite)sat.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                }
                throw new MatchError((Object)tuple2);
            }).reverse();
            List list2 = builders;
            if (list2 instanceof .colon.colon) {
                .colon.colon colon3 = (.colon.colon)list2;
                StepPlan hd = (StepPlan)colon3.head();
                List list3 = colon3.next$access$1();
                if (Nil$.MODULE$.equals(list3)) {
                    return hd;
                }
            }
            return new SerialPlan(this.descriptionFor(ci, controlTaskName), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)list2).asJava(), null);
        }
        throw new MatchError(list);
    }

    private Option<Satellite> satelliteOfStep(Step step) {
        return Option$.MODULE$.apply((Object)step).collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Step, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                SatelliteAware satelliteAware;
                A1 A1 = x1;
                if (A1 instanceof SatelliteAware && (satelliteAware = (SatelliteAware)A1).getSatellite() != null) {
                    return (B1)satelliteAware.getSatellite();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Step x1) {
                SatelliteAware satelliteAware;
                Step step = x1;
                return step instanceof SatelliteAware && (satelliteAware = (SatelliteAware)step).getSatellite() != null;
            }
        });
    }

    private PhasedPlan asPhasedPlan(String controlTaskName, ExecutablePlan plan) {
        PlanPhase phase = new PlanPhase(plan, "Execute the " + controlTaskName + " control task", CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Nil$.MODULE$).asJava(), false);
        return new PhasedPlan(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)phase, (List)Nil$.MODULE$)).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Nil$.MODULE$).asJava());
    }

    private String descriptionFor(ConfigurationItem ci, String controlTaskName, Option<Satellite> satellite) {
        Option<Satellite> option = satellite;
        if (option instanceof Some) {
            Some some = (Some)option;
            Satellite x = (Satellite)some.value();
            return this.descriptionFor(ci, controlTaskName) + " (executed on " + x + ")";
        }
        if (None$.MODULE$.equals(option)) {
            return this.descriptionFor(ci, controlTaskName);
        }
        throw new MatchError(option);
    }

    private String descriptionFor(ConfigurationItem ci, String controlTaskName) {
        return "Control task [" + controlTaskName + "] for " + ci.getId();
    }

    public ControlTaskServiceImpl(@Autowired RepositoryService repositoryService, @Autowired ExternalPropertiesResolver externalPropertiesResolver, @Autowired BeanWrapper<TaskExecutionEngine> engine, @Autowired WorkDirFactory workDirFactory) {
        this.repositoryService = repositoryService;
        this.externalPropertiesResolver = externalPropertiesResolver;
        this.engine = engine;
        this.workDirFactory = workDirFactory;
    }
}

