/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import ai.digital.deploy.tasker.common.TaskType;
import com.xebialabs.deployit.deployment.planner.CheckPointManagerListener;
import com.xebialabs.deployit.deployment.planner.MultiDeltaSpecification;
import com.xebialabs.deployit.deployment.planner.RollbackCompletedListener;
import com.xebialabs.deployit.engine.api.distribution.TaskExecutionWorkerRepository;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.tasker.IEngine;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.engine.tasker.TaskExecutionContext;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.engine.tasker.repository.PendingTaskRepository;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.deployit.service.deployment.DeploymentService;
import com.xebialabs.deployit.spring.BeanWrapper;
import com.xebialabs.deployit.task.TaskMetadataModifier;
import com.xebialabs.deployit.task.WorkdirCleanerTrigger;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.UUID;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.SetOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005-e\u0001B\u0007\u000f\u0001eA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\tm\u0001\u0011\t\u0011)A\u0005o!A1\b\u0001B\u0001B\u0003%A\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003F\u0011\u0015Y\u0005\u0001\"\u0001M\u0011\u0015\t\u0007\u0001\"\u0001c\u0011\u0019\u0019\b\u0001\"\u0001\u000fi\")1\u000f\u0001C\u0005s\"9\u0011\u0011\u0006\u0001\u0005\n\u0005-\u0002bBA!\u0001\u0011%\u00111\t\u0005\t\u0003\u000f\u0002A\u0011\u0001\b\u0002J!9\u0011\u0011\u000f\u0001\u0005\n\u0005M$a\u0004*pY2\u0014\u0017mY6TKJ4\u0018nY3\u000b\u0005=\u0001\u0012A\u00033fa2|\u00170\\3oi*\u0011\u0011CE\u0001\bg\u0016\u0014h/[2f\u0015\t\u0019B#\u0001\u0005eKBdw._5u\u0015\t)b#A\u0005yK\nL\u0017\r\\1cg*\tq#A\u0002d_6\u001c\u0001aE\u0002\u00015\u0001\u0002\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011a!\u00118z%\u00164\u0007CA\u0011'\u001b\u0005\u0011#BA\u0012%\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005)\u0013\u0001C4sSjTH.\u001a3\n\u0005\u001d\u0012#a\u0002'pO\u001eLgnZ\u0001\u0007K:<\u0017N\\3\u0011\u0007)js&D\u0001,\u0015\ta##\u0001\u0004taJLgnZ\u0005\u0003]-\u00121BQ3b]^\u0013\u0018\r\u001d9feB\u0011\u0001\u0007N\u0007\u0002c)\u0011!gM\u0001\u0007i\u0006\u001c8.\u001a:\u000b\u0005!\u0012\u0012BA\u001b2\u0005M!\u0016m]6Fq\u0016\u001cW\u000f^5p]\u0016sw-\u001b8f\u0003E!W\r\u001d7ps6,g\u000e^*feZL7-\u001a\t\u0003qej\u0011AD\u0005\u0003u9\u0011\u0011\u0003R3qY>LX.\u001a8u'\u0016\u0014h/[2f\u0003A9xN]6feJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002>\u00056\taH\u0003\u0002@\u0001\u0006aA-[:ue&\u0014W\u000f^5p]*\u0011\u0011iM\u0001\u0004CBL\u0017BA\"?\u0005u!\u0016m]6Fq\u0016\u001cW\u000f^5p]^{'o[3s%\u0016\u0004xn]5u_JL\u0018!\u00069f]\u0012Lgn\u001a+bg.\u0014V\r]8tSR|'/\u001f\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011F\n!B]3q_NLGo\u001c:z\u0013\tQuIA\u000bQK:$\u0017N\\4UCN\\'+\u001a9pg&$xN]=\u0002\rqJg.\u001b;?)\u0015iej\u0014)R!\tA\u0004\u0001C\u0003)\u000b\u0001\u0007\u0011\u0006C\u00037\u000b\u0001\u0007q\u0007C\u0003<\u000b\u0001\u0007A\bC\u0003E\u000b\u0001\u0007Q\t\u000b\u0002\u0006'B\u0011AkX\u0007\u0002+*\u0011akV\u0001\u000bC:tw\u000e^1uS>t'B\u0001-Z\u0003\u001d1\u0017m\u0019;pefT!AW.\u0002\u000b\t,\u0017M\\:\u000b\u0005qk\u0016aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003y\u000b1a\u001c:h\u0013\t\u0001WKA\u0005BkR|w/\u001b:fI\u0006A!o\u001c7mE\u0006\u001c7\u000e\u0006\u0002d]B\u0011Am\u001b\b\u0003K&\u0004\"A\u001a\u000f\u000e\u0003\u001dT!\u0001\u001b\r\u0002\rq\u0012xn\u001c;?\u0013\tQG$\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y6\u0014aa\u0015;sS:<'B\u00016\u001d\u0011\u0015yg\u00011\u0001q\u0003\u0011!\u0018m]6\u0011\u0005A\n\u0018B\u0001:2\u0005\u0011!\u0016m]6\u00027\r\u0014X-\u0019;f%>dGNY1dWN\u0003XmY5gS\u000e\fG/[8o)\t)\b\u0010\u0005\u00021m&\u0011q/\r\u0002\u0012)\u0006\u001c8n\u00159fG&4\u0017nY1uS>t\u0007\"B8\b\u0001\u0004\u0001H#B;{w\u0006%\u0001\"B8\t\u0001\u0004\u0001\b\"\u0002?\t\u0001\u0004i\u0018\u0001\u00069beRL\u0017\r\\\"p[6LG\u000f\u0016:jO\u001e,'\u000fE\u0002\u007f\u0003\u000bi\u0011a \u0006\u0005\u0003\u0003\t\u0019!A\u0004qY\u0006tg.\u001a:\u000b\u0005=\u0011\u0012bAA\u0004\u007f\nI2\t[3dWB{\u0017N\u001c;NC:\fw-\u001a:MSN$XM\\3s\u0011\u001d\tY\u0001\u0003a\u0001\u0003\u001b\t\u0001b^8sW\u0012K'o\u001d\t\u0007\u0003\u001f\tI\"a\b\u000f\t\u0005E\u0011Q\u0003\b\u0004M\u0006M\u0011\"A\u000f\n\u0007\u0005]A$A\u0004qC\u000e\\\u0017mZ3\n\t\u0005m\u0011Q\u0004\u0002\u0005\u0019&\u001cHOC\u0002\u0002\u0018q\u0001B!!\t\u0002&5\u0011\u00111\u0005\u0006\u0003\u0011JIA!a\n\u0002$\t9qk\u001c:l\t&\u0014\u0018!E4fi^{'o\u001b3je\u000ecW-\u00198feR!\u0011QFA\u001c!\u0011\ty#a\r\u000e\u0005\u0005E\"BA8\u0013\u0013\u0011\t)$!\r\u0003+]{'o\u001b3je\u000ecW-\u00198feR\u0013\u0018nZ4fe\"9\u0011\u0011H\u0005A\u0002\u0005m\u0012aB2p]R,\u0007\u0010\u001e\t\u0004a\u0005u\u0012bAA c\t!B+Y:l\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fAdZ3u\u0007\",7m\u001b)pS:$X*\u00198bO\u0016\u0014H*[:uK:,'\u000fF\u0002~\u0003\u000bBq!!\u000f\u000b\u0001\u0004\tY$A\te_B\u0013X\r]1sKJ{G\u000e\u001c2bG.$b!a\u0013\u0002l\u00055\u0004\u0003BA'\u0003KrA!a\u0014\u0002d9!\u0011\u0011KA1\u001d\u0011\t\u0019&a\u0018\u000f\t\u0005U\u0013Q\f\b\u0005\u0003/\nYFD\u0002g\u00033J\u0011aF\u0005\u0003+YI!a\u0005\u000b\n\u0005!\u0012\u0012B\u0001\u001a4\u0013\r\t9\"M\u0005\u0005\u0003O\nIG\u0001\u0004UCN\\\u0017\n\u001a\u0006\u0004\u0003/\t\u0004\"B8\f\u0001\u0004\u0001\bBBA8\u0017\u0001\u0007Q/A\u000bs_2d'-Y2l'B,7-\u001b4jG\u0006$\u0018n\u001c8\u0002\u000f\u0005\u00148\r[5wKR!\u0011QOA>!\rY\u0012qO\u0005\u0004\u0003sb\"\u0001B+oSRDQa\u001c\u0007A\u0002AD3\u0001AA@!\u0011\t\t)a\"\u000e\u0005\u0005\r%bAAC7\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005%\u00151\u0011\u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class RollbackService
implements Logging {
    private final BeanWrapper<TaskExecutionEngine> engine;
    private final DeploymentService deploymentService;
    private final TaskExecutionWorkerRepository workerRepository;
    private final PendingTaskRepository pendingTaskRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RollbackService rollbackService = this;
        synchronized (rollbackService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public String rollback(Task task) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(23).append("Going to rollback task ").append(task.getId()).toString());
        TaskSpecification rollbackSpecification = this.createRollbackSpecification(task);
        this.workerRepository.getWorker(task.getWorkerId()).foreach((Function1 & Serializable)worker -> $this.pendingTaskRepository.store(rollbackSpecification, (Option)new Some((Object)worker.address())));
        return this.doPrepareRollback(task, rollbackSpecification);
    }

    public TaskSpecification createRollbackSpecification(Task task) {
        TaskExecutionContext context = task.getContext();
        WorkdirCleanerTrigger workdirCleanerTrigger = this.getWorkdirCleaner(context);
        CheckPointManagerListener checkPointManagerListener = this.getCheckPointManagerListener(context);
        TaskSpecification rollbackSpecification = this.createRollbackSpecification(task, checkPointManagerListener, (List<WorkDir>)CollectionConverters$.MODULE$.ListHasAsScala(workdirCleanerTrigger.getWorkDirs()).asScala().toList());
        rollbackSpecification.getListeners().add(new RollbackCompletedListener(task.getId()));
        TaskMetadataModifier.putMetadata((TaskSpecification)rollbackSpecification, (String)"rollbackType", (String)((String)task.getMetadata().get("taskType")));
        TaskMetadataModifier.putMetadata((TaskSpecification)rollbackSpecification, (String)"taskType", (String)TaskType.ROLLBACK.name());
        TaskMetadataModifier.putMetadata((TaskSpecification)rollbackSpecification, (String)"rollbackTask", (String)task.getId());
        this.logger().info((Function0 & Serializable)() -> new StringBuilder(31).append("Create rollback task ").append(rollbackSpecification.getId()).append(" for task ").append(task.getId()).toString());
        return rollbackSpecification;
    }

    private TaskSpecification createRollbackSpecification(Task task, CheckPointManagerListener partialCommitTrigger, List<WorkDir> workDirs) {
        TaskExecutionState taskExecutionState = task.getState();
        TaskExecutionState taskExecutionState2 = TaskExecutionState.EXECUTED;
        boolean includeAll = !(taskExecutionState != null ? !taskExecutionState.equals(taskExecutionState2) : taskExecutionState2 != null);
        MultiDeltaSpecification rollbackSpec = partialCommitTrigger.checkpointManager().prepareRollback(includeAll);
        WorkDirContext.setWorkDir((WorkDir)task.getWorkDir());
        String rollbackTaskId = UUID.randomUUID().toString();
        return this.deploymentService.getTaskFullSpecification(rollbackTaskId, rollbackSpec, task.getWorkDir(), (WorkDir[])workDirs.toArray(ClassTag$.MODULE$.apply(WorkDir.class)));
    }

    private WorkdirCleanerTrigger getWorkdirCleaner(TaskExecutionContext context) {
        String name = WorkdirCleanerTrigger.class.getName();
        return (WorkdirCleanerTrigger)context.getAttribute(name);
    }

    private CheckPointManagerListener getCheckPointManagerListener(TaskExecutionContext context) {
        String name = CheckPointManagerListener.class.getName();
        return (CheckPointManagerListener)context.getAttribute(name);
    }

    public String doPrepareRollback(Task task, TaskSpecification rollbackSpecification) {
        ((TaskExecutionEngine)this.engine.get()).prepareRollback(task.getId(), rollbackSpecification);
        this.archive(task);
        return rollbackSpecification.getId();
    }

    private void archive(Task task) {
        TaskExecutionState taskExecutionState = task.getState();
        TaskExecutionState taskExecutionState2 = TaskExecutionState.EXECUTED;
        if (!(taskExecutionState != null ? !taskExecutionState.equals(taskExecutionState2) : taskExecutionState2 != null)) {
            ((TaskExecutionEngine)this.engine.get()).archive(task.getId());
            return;
        }
        if (((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TaskExecutionState[]{TaskExecutionState.STOPPED, TaskExecutionState.ABORTED, TaskExecutionState.FAILED}))).contains((Object)task.getState())) {
            ((IEngine)this.engine.get()).cancel(task.getId());
            return;
        }
        throw new IllegalStateException(new StringBuilder(67).append("Can only rollback a STOPPED, FAILED, ABORTED or EXECUTED task [").append(task.getId()).append(" (").append(task.getState()).append(")]").toString());
    }

    @Autowired
    public RollbackService(BeanWrapper<TaskExecutionEngine> engine, DeploymentService deploymentService, TaskExecutionWorkerRepository workerRepository, PendingTaskRepository pendingTaskRepository) {
        this.engine = engine;
        this.deploymentService = deploymentService;
        this.workerRepository = workerRepository;
        this.pendingTaskRepository = pendingTaskRepository;
        Logging.$init$((Logging)this);
    }
}

