/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer;

import ai.digital.configuration.central.deploy.ClientProperties;
import ai.digital.deploy.core.common.security.permission.DeployitPermissions$;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.xebialabs.deployit.checksum.ChecksumAlgorithmProvider;
import com.xebialabs.deployit.core.sql.RepositoryHelper;
import com.xebialabs.deployit.engine.spi.artifact.resolution.ResolvedArtifactFile;
import com.xebialabs.deployit.engine.spi.command.CreateCisCommand;
import com.xebialabs.deployit.engine.spi.command.RepositoryBaseCommand;
import com.xebialabs.deployit.io.ArtifactFileUtils;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.CompositePackage;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.server.api.importer.ImportedPackage;
import com.xebialabs.deployit.server.api.importer.Importer;
import com.xebialabs.deployit.server.api.importer.ImportingContext;
import com.xebialabs.deployit.server.api.importer.ListableImporter;
import com.xebialabs.deployit.server.api.importer.PackageInfo;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.importer.DefaultImportingContext;
import com.xebialabs.deployit.service.importer.ImporterException;
import com.xebialabs.deployit.service.importer.ImporterService;
import com.xebialabs.deployit.service.importer.XmlManifestDarImporter;
import com.xebialabs.deployit.service.importer.package$;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xldeploy.packager.placeholders.PlaceholdersUtil$;
import com.xebialabs.xldeploy.packager.placeholders.SourceArtifactScanner;
import com.xebialabs.xlplatform.artifact.resolution.ArtifactResolverRegistry$;
import com.xebialabs.xlplatform.utils.ResourceManagement$;
import de.schlichtherle.truezip.file.TFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import nl.javadude.scannit.Scannit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\r\u001db\u0001\u0002\u001b6\u0001\u0001C\u0001\"\u0014\u0001\u0003\u0002\u0004%\tA\u0014\u0005\t+\u0002\u0011\t\u0019!C\u0001-\"Aq\f\u0001B\u0001B\u0003&q\n\u0003\u0005a\u0001\t\u0005\r\u0011\"\u0001b\u0011!A\u0007A!a\u0001\n\u0003I\u0007\u0002C6\u0001\u0005\u0003\u0005\u000b\u0015\u00022\t\u00111\u0004!\u00111A\u0005\u00025D\u0001\u0002\u001e\u0001\u0003\u0002\u0004%\t!\u001e\u0005\to\u0002\u0011\t\u0011)Q\u0005]\"A\u0001\u0010\u0001BA\u0002\u0013\u0005\u0011\u0010\u0003\u0006\u0002\n\u0001\u0011\t\u0019!C\u0001\u0003\u0017A\u0011\"a\u0004\u0001\u0005\u0003\u0005\u000b\u0015\u0002>\t\u0015\u0005E\u0001A!a\u0001\n\u0003\t\u0019\u0002\u0003\u0006\u00022\u0001\u0011\t\u0019!C\u0001\u0003gA!\"a\u000e\u0001\u0005\u0003\u0005\u000b\u0015BA\u000b\u0011)\tI\u0004\u0001BA\u0002\u0013\u0005\u00111\b\u0005\u000b\u0003\u001b\u0002!\u00111A\u0005\u0002\u0005=\u0003BCA*\u0001\t\u0005\t\u0015)\u0003\u0002>!Q\u0011Q\u000b\u0001\u0003\u0002\u0004%\t!a\u0016\t\u0015\u0005\u0015\u0004A!a\u0001\n\u0003\t9\u0007\u0003\u0006\u0002l\u0001\u0011\t\u0011)Q\u0005\u00033Bq!!\u001c\u0001\t\u0003\ty\u0007C\u0005\u0002 \u0002\u0011\r\u0011\"\u0003\u0002\"\"A\u0011\u0011\u0019\u0001!\u0002\u0013\t\u0019\u000bC\u0005\u0002D\u0002\u0011\r\u0011\"\u0003\u0002F\"A\u00111\u001b\u0001!\u0002\u0013\t9\rC\u0005\u0002V\u0002\u0011\r\u0011\"\u0003\u0002X\"A\u0011q\u001f\u0001!\u0002\u0013\tI\u000eC\u0005\u0002z\u0002\u0001\r\u0011\"\u0003\u0002|\"I!\u0011\u0002\u0001A\u0002\u0013%!1\u0002\u0005\t\u0005\u001f\u0001\u0001\u0015)\u0003\u0002~\"9!\u0011\u0003\u0001\u0005\u0002\tM\u0001b\u0002B\u0013\u0001\u0011\u0005#q\u0005\u0005\b\u0005S\u0001A\u0011\u0001B\u0016\u0011\u001d\u0011y\u0003\u0001C!\u0005cAqAa\u0013\u0001\t\u0003\u0012i\u0005C\u0004\u0003Z\u0001!\tBa\u0017\t\u000f\t=\u0004\u0001\"\u0003\u0003r!9!q\u000f\u0001\u0005\n\te\u0004b\u0002BH\u0001\u0011%!\u0011\u0013\u0005\b\u0005O\u0003A\u0011\u0002BU\u0011\u001d\u0011y\u000b\u0001C\u0005\u0005cCqA!0\u0001\t\u0013\u0011y\fC\u0004\u0003Z\u0002!IAa7\t\u000f\tE\b\u0001\"\u0003\u0003t\"9!1 \u0001\u0005\n\tu\bb\u0002Bc\u0001\u0011%11\u0001\u0005\b\u0007\u000f\u0001A\u0011BB\u0005\u0011\u001d\u0019i\u0001\u0001C\u0005\u0007\u001fAqa!\u0007\u0001\t\u0013\u0019Y\u0002C\u0004\u0003Z\u0001!Ia!\t\u0003'%k\u0007o\u001c:uKJ\u001cVM\u001d<jG\u0016LU\u000e\u001d7\u000b\u0005Y:\u0014\u0001C5na>\u0014H/\u001a:\u000b\u0005aJ\u0014aB:feZL7-\u001a\u0006\u0003um\n\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003yu\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003y\n1aY8n\u0007\u0001\u00192\u0001A!J!\t\u0011u)D\u0001D\u0015\t!U)\u0001\u0003mC:<'\"\u0001$\u0002\t)\fg/Y\u0005\u0003\u0011\u000e\u0013aa\u00142kK\u000e$\bC\u0001&L\u001b\u0005)\u0014B\u0001'6\u0005=IU\u000e]8si\u0016\u00148+\u001a:wS\u000e,\u0017!\u0005:fa>\u001c\u0018\u000e^8ssN+'O^5dKV\tq\n\u0005\u0002Q'6\t\u0011K\u0003\u0002Ss\u0005Q!/\u001a9pg&$xN]=\n\u0005Q\u000b&!\u0005*fa>\u001c\u0018\u000e^8ssN+'O^5dK\u0006)\"/\u001a9pg&$xN]=TKJ4\u0018nY3`I\u0015\fHCA,^!\tA6,D\u0001Z\u0015\u0005Q\u0016!B:dC2\f\u0017B\u0001/Z\u0005\u0011)f.\u001b;\t\u000fy\u0013\u0011\u0011!a\u0001\u001f\u0006\u0019\u0001\u0010J\u0019\u0002%I,\u0007o\\:ji>\u0014\u0018pU3sm&\u001cW\rI\u0001\fe>dWmU3sm&\u001cW-F\u0001c!\t\u0019g-D\u0001e\u0015\t)\u0017(\u0001\u0005tK\u000e,(/\u001b;z\u0013\t9GMA\u0006S_2,7+\u001a:wS\u000e,\u0017a\u0004:pY\u0016\u001cVM\u001d<jG\u0016|F%Z9\u0015\u0005]S\u0007b\u00020\u0006\u0003\u0003\u0005\rAY\u0001\re>dWmU3sm&\u001cW\rI\u0001\nm\u0006d\u0017\u000eZ1u_J,\u0012A\u001c\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003c^\n!B^1mS\u0012\fG/[8o\u0013\t\u0019\bOA\u0005WC2LG-\u0019;pe\u0006ia/\u00197jI\u0006$xN]0%KF$\"a\u0016<\t\u000fyC\u0011\u0011!a\u0001]\u0006Qa/\u00197jI\u0006$xN\u001d\u0011\u0002\u000fM\u001c\u0017M\u001c8feV\t!\u0010E\u0002|\u0003\u000bi\u0011\u0001 \u0006\u0003{z\fA\u0002\u001d7bG\u0016Dw\u000e\u001c3feNT1a`A\u0001\u0003!\u0001\u0018mY6bO\u0016\u0014(bAA\u0002w\u0005A\u0001\u0010\u001c3fa2|\u00170C\u0002\u0002\bq\u0014QcU8ve\u000e,\u0017I\u001d;jM\u0006\u001cGoU2b]:,'/A\u0006tG\u0006tg.\u001a:`I\u0015\fHcA,\u0002\u000e!9alCA\u0001\u0002\u0004Q\u0018\u0001C:dC:tWM\u001d\u0011\u0002'\rd\u0017.\u001a8u\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0016\u0005\u0005U\u0001\u0003BA\f\u0003[i!!!\u0007\u000b\t\u0005m\u0011QD\u0001\u0007I\u0016\u0004Hn\\=\u000b\t\u0005}\u0011\u0011E\u0001\bG\u0016tGO]1m\u0015\u0011\t\u0019#!\n\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0015\u0011\t9#!\u000b\u0002\u000f\u0011Lw-\u001b;bY*\u0011\u00111F\u0001\u0003C&LA!a\f\u0002\u001a\t\u00012\t\\5f]R\u0004&o\u001c9feRLWm]\u0001\u0018G2LWM\u001c;D_:4\u0017nZ;sCRLwN\\0%KF$2aVA\u001b\u0011!qf\"!AA\u0002\u0005U\u0011\u0001F2mS\u0016tGoQ8oM&<WO]1uS>t\u0007%\u0001\tsKB|7/\u001b;pefDU\r\u001c9feV\u0011\u0011Q\b\t\u0005\u0003\u007f\tI%\u0004\u0002\u0002B)!\u00111IA#\u0003\r\u0019\u0018\u000f\u001c\u0006\u0004\u0003\u000fJ\u0014\u0001B2pe\u0016LA!a\u0013\u0002B\t\u0001\"+\u001a9pg&$xN]=IK2\u0004XM]\u0001\u0015e\u0016\u0004xn]5u_JL\b*\u001a7qKJ|F%Z9\u0015\u0007]\u000b\t\u0006\u0003\u0005_#\u0005\u0005\t\u0019AA\u001f\u0003E\u0011X\r]8tSR|'/\u001f%fYB,'\u000fI\u0001\u001aG\",7m[:v[\u0006cwm\u001c:ji\"l\u0007K]8wS\u0012,'/\u0006\u0002\u0002ZA!\u00111LA1\u001b\t\tiFC\u0002\u0002`e\n\u0001b\u00195fG.\u001cX/\\\u0005\u0005\u0003G\niFA\rDQ\u0016\u001c7n];n\u00032<wN]5uQ6\u0004&o\u001c<jI\u0016\u0014\u0018!H2iK\u000e\\7/^7BY\u001e|'/\u001b;i[B\u0013xN^5eKJ|F%Z9\u0015\u0007]\u000bI\u0007\u0003\u0005_)\u0005\u0005\t\u0019AA-\u0003i\u0019\u0007.Z2lgVl\u0017\t\\4pe&$\b.\u001c)s_ZLG-\u001a:!\u0003\u0019a\u0014N\\5u}Q\u0001\u0012\u0011OA:\u0003k\n9(!\u001f\u0002|\u0005u\u0014q\u0010\t\u0003\u0015\u0002AQ!\u0014\fA\u0002=CQ\u0001\u0019\fA\u0002\tDQ\u0001\u001c\fA\u00029DQ\u0001\u001f\fA\u0002iDq!!\u0005\u0017\u0001\u0004\t)\u0002C\u0004\u0002:Y\u0001\r!!\u0010\t\u000f\u0005Uc\u00031\u0001\u0002Z!\u001aa#a!\u0011\t\u0005\u0015\u00151T\u0007\u0003\u0003\u000fSA!!#\u0002\f\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\u00055\u0015qR\u0001\bM\u0006\u001cGo\u001c:z\u0015\u0011\t\t*a%\u0002\u000b\t,\u0017M\\:\u000b\t\u0005U\u0015qS\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\u0011\u0011\u0011T\u0001\u0004_J<\u0017\u0002BAO\u0003\u000f\u0013\u0011\"Q;u_^L'/\u001a3\u0002\u0013%l\u0007o\u001c:uKJ\u001cXCAAR!\u0019\t)+a+\u000206\u0011\u0011q\u0015\u0006\u0004\u0003S+\u0015\u0001B;uS2LA!!,\u0002(\n!A*[:u!\u0011\t\t,!0\u000e\u0005\u0005M&b\u0001\u001c\u00026*!\u0011qWA]\u0003\r\t\u0007/\u001b\u0006\u0004\u0003wK\u0014AB:feZ,'/\u0003\u0003\u0002@\u0006M&\u0001C%na>\u0014H/\u001a:\u0002\u0015%l\u0007o\u001c:uKJ\u001c\b%\u0001\u0004m_\u001e<WM]\u000b\u0003\u0003\u000f\u0004B!!3\u0002P6\u0011\u00111\u001a\u0006\u0005\u0003\u001b\f9*A\u0003tY\u001a$$.\u0003\u0003\u0002R\u0006-'A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002!%\u001c8i\u001c7mK\u000e$\u0018n\u001c8LS:$WCAAm!\u001dA\u00161\\Ap\u0003cL1!!8Z\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0002b\u00065XBAAr\u0015\u0011\t)/a:\u0002\u000fI,g\r\\3di*!\u0011qWAu\u0015\r\tY/O\u0001\u0007a2,x-\u001b8\n\t\u0005=\u00181\u001d\u0002\r!J|\u0007/\u001a:us.Kg\u000e\u001a\t\u00041\u0006M\u0018bAA{3\n9!i\\8mK\u0006t\u0017!E5t\u0007>dG.Z2uS>t7*\u001b8eA\u0005Q\u0012.\u001c9peR\f'\r\\3QC\u000e\\\u0017mZ3ESJ,7\r^8ssV\u0011\u0011Q \t\u0005\u0003\u007f\u0014)!\u0004\u0002\u0003\u0002)\u0019!1A#\u0002\u0005%|\u0017\u0002\u0002B\u0004\u0005\u0003\u0011AAR5mK\u0006q\u0012.\u001c9peR\f'\r\\3QC\u000e\\\u0017mZ3ESJ,7\r^8ss~#S-\u001d\u000b\u0004/\n5\u0001\u0002\u00030\u001f\u0003\u0003\u0005\r!!@\u00027%l\u0007o\u001c:uC\ndW\rU1dW\u0006<W\rR5sK\u000e$xN]=!\u00035Ig.\u001b;J[B|'\u000f^3sgR\tq\u000bK\u0002!\u0005/\u0001BA!\u0007\u0003\"5\u0011!1\u0004\u0006\u0005\u0003\u0013\u0013iB\u0003\u0002\u0003 \u0005)!.\u0019<bq&!!1\u0005B\u000e\u00055\u0001vn\u001d;D_:\u001cHO];di\u0006ir-\u001a;J[B|'\u000f^1cY\u0016\u0004\u0016mY6bO\u0016$\u0015N]3di>\u0014\u0018\u0010\u0006\u0002\u0002~\u0006i2/\u001a;J[B|'\u000f^1cY\u0016\u0004\u0016mY6bO\u0016$\u0015N]3di>\u0014\u0018\u0010F\u0002X\u0005[Aq!!?#\u0001\u0004\ti0\u0001\u0007mSN$\b+Y2lC\u001e,7\u000f\u0006\u0002\u00034A1\u0011QUAV\u0005k\u0001BAa\u000e\u0003F9!!\u0011\bB!!\r\u0011Y$W\u0007\u0003\u0005{Q1Aa\u0010@\u0003\u0019a$o\\8u}%\u0019!1I-\u0002\rA\u0013X\rZ3g\u0013\u0011\u00119E!\u0013\u0003\rM#(/\u001b8h\u0015\r\u0011\u0019%W\u0001\u000eS6\u0004xN\u001d;QC\u000e\\\u0017mZ3\u0015\t\tU\"q\n\u0005\b\u0005#\"\u0003\u0019\u0001B*\u0003\u0019\u0019x.\u001e:dKB!\u0011\u0011\u0017B+\u0013\u0011\u00119&a-\u0003\u0019%k\u0007o\u001c:u'>,(oY3\u0002\u001f\rDWmY6QKJl\u0017n]:j_:$Ra\u0016B/\u0005WBqAa\u0018&\u0001\u0004\u0011\t'\u0001\u0006qKJl\u0017n]:j_:\u0004BAa\u0019\u0003h5\u0011!Q\r\u0006\u0004\u0005?\"\u0017\u0002\u0002B5\u0005K\u0012!\u0002U3s[&\u001c8/[8o\u0011\u001d\u0011i'\na\u0001\u0005k\tAc\u001c8D_:4\u0017nZ;sCRLwN\\%uK6\u001c\u0018\u0001\u00033p\u00136\u0004xN\u001d;\u0015\r\tU\"1\u000fB;\u0011\u001d\u0011\tF\na\u0001\u0005'BaA\u000e\u0014A\u0002\u0005=\u0016\u0001E:dC:\u0004F.Y2fQ>dG-\u001a:t)\u00159&1\u0010BC\u0011\u001d\u0011ih\na\u0001\u0005\u007f\nq\"[7q_J$X\r\u001a)bG.\fw-\u001a\t\u0005\u0003c\u0013\t)\u0003\u0003\u0003\u0004\u0006M&aD%na>\u0014H/\u001a3QC\u000e\\\u0017mZ3\t\u000f\t\u001du\u00051\u0001\u0003\n\u0006\u00191\r\u001e=\u0011\t\u0005E&1R\u0005\u0005\u0005\u001b\u000b\u0019L\u0001\tJ[B|'\u000f^5oO\u000e{g\u000e^3yi\u0006A\"/Z:pYZ,\u0017I\u001c3F]JL7\r[!si&4\u0017m\u0019;\u0015\u0007]\u0013\u0019\nC\u0004\u0003\u0016\"\u0002\rAa&\u0002\u001dM|WO]2f\u0003J$\u0018NZ1diB!!\u0011\u0014BR\u001b\t\u0011YJ\u0003\u0003\u0003\u001e\n}\u0015\u0001C1si&4\u0017m\u0019;\u000b\t\t\u0005\u0016q]\u0001\u0004k\u0012l\u0017\u0002\u0002BS\u00057\u0013abU8ve\u000e,\u0017I\u001d;jM\u0006\u001cG/A\u000bjg\u0006\u0013H/\u001b4bGR\u0004&/Z#oe&\u001c\u0007.\u001a3\u0015\t\u0005E(1\u0016\u0005\b\u0005[K\u0003\u0019\u0001BL\u0003)!W\r\u001d7ps\u0006\u0014G.Z\u0001\u000eG\",7m[%na>\u0014H/\u001a3\u0015\u0007]\u0013\u0019\fC\u0004\u00036*\u0002\rAa.\u0002\u0017A\f7m[1hK&sgm\u001c\t\u0005\u0003c\u0013I,\u0003\u0003\u0003<\u0006M&a\u0003)bG.\fw-Z%oM>\fab\u0019:fCR,WI\u001c;ji&,7\u000fF\u0004X\u0005\u0003\u0014\u0019Ma2\t\u000f\tu4\u00061\u0001\u0003\u0000!9!QY\u0016A\u0002\u0005E\u0018!C5t+B<'/\u00193f\u0011\u001d\u0011Im\u000ba\u0001\u0005\u0017\f\u0011\u0003^8De\u0016\fG/Z\"pY2,7\r^8s!\u0019\t)K!4\u0003R&!!qZAT\u0005\r\u0019V\r\u001e\t\u0005\u0005'\u0014).\u0004\u0002\u0003 &!!q\u001bBP\u0005E\u0019uN\u001c4jOV\u0014\u0018\r^5p]&#X-\\\u0001\u0017M&dG/\u001a:Fq&\u001cH/\u001b8h!\u0006\u001c7.Y4fgR!!Q\u001cBt!\u0019\u00119Da8\u0003b&!!q\u001aB%!\u0011\t\tOa9\n\t\t\u0015\u00181\u001d\u0002\u0013!J|\u0007/\u001a:us\u0012+7o\u0019:jaR|'\u000fC\u0004\u0003j2\u0002\rAa;\u0002\u000fY,'o]5p]B!!1\u001bBw\u0013\u0011\u0011yOa(\u0003\u000fY+'o]5p]\u0006q2M]3bi\u0016tUm\u001d;fI\u000e{gNZ5hkJ\fG/[8o\u0013R,Wn\u001d\u000b\u0006/\nU(\u0011 \u0005\b\u0005ol\u0003\u0019\u0001Bi\u0003\t\u0019\u0017\u000eC\u0004\u0003J6\u0002\rAa3\u0002\u0011Y\fG.\u001b3bi\u0016$2a\u0016B\u0000\u0011\u001d\u0019\tA\fa\u0001\u0005\u0017\f\u0001\u0002^8De\u0016\fG/\u001a\u000b\u0005\u0003c\u001c)\u0001C\u0004\u00036>\u0002\rAa.\u0002\u000f\u0005\u0004\bOT1nKR!!QGB\u0006\u0011\u001d\u0011)\f\ra\u0001\u0005o\u000b!c];c'R\u0014\u0018N\\4BMR,'\u000fT1tiR1!QGB\t\u0007+Aqaa\u00052\u0001\u0004\u0011)$A\u0001t\u0011\u001d\u00199\"\ra\u0001\u0005k\t1a]3q\u0003M\u0019XOY*ue&twMQ3g_J,G*Y:u)\u0019\u0011)d!\b\u0004 !911\u0003\u001aA\u0002\tU\u0002bBB\fe\u0001\u0007!Q\u0007\u000b\u0006/\u000e\r2Q\u0005\u0005\b\u0005\u000b\u001c\u0004\u0019AAy\u0011\u001d\u0011)l\ra\u0001\u0005o\u0003")
public class ImporterServiceImpl
implements ImporterService {
    private RepositoryService repositoryService;
    private RoleService roleService;
    private Validator validator;
    private SourceArtifactScanner scanner;
    private ClientProperties clientConfiguration;
    private RepositoryHelper repositoryHelper;
    private ChecksumAlgorithmProvider checksumAlgorithmProvider;
    private final java.util.List<Importer> importers;
    private final Logger logger;
    private final Function1<PropertyKind, Object> isCollectionKind;
    private File importablePackageDirectory;

    public RepositoryService repositoryService() {
        return this.repositoryService;
    }

    public void repositoryService_$eq(RepositoryService x$1) {
        this.repositoryService = x$1;
    }

    public RoleService roleService() {
        return this.roleService;
    }

    public void roleService_$eq(RoleService x$1) {
        this.roleService = x$1;
    }

    public Validator validator() {
        return this.validator;
    }

    public void validator_$eq(Validator x$1) {
        this.validator = x$1;
    }

    public SourceArtifactScanner scanner() {
        return this.scanner;
    }

    public void scanner_$eq(SourceArtifactScanner x$1) {
        this.scanner = x$1;
    }

    public ClientProperties clientConfiguration() {
        return this.clientConfiguration;
    }

    public void clientConfiguration_$eq(ClientProperties x$1) {
        this.clientConfiguration = x$1;
    }

    public RepositoryHelper repositoryHelper() {
        return this.repositoryHelper;
    }

    public void repositoryHelper_$eq(RepositoryHelper x$1) {
        this.repositoryHelper = x$1;
    }

    public ChecksumAlgorithmProvider checksumAlgorithmProvider() {
        return this.checksumAlgorithmProvider;
    }

    public void checksumAlgorithmProvider_$eq(ChecksumAlgorithmProvider x$1) {
        this.checksumAlgorithmProvider = x$1;
    }

    private java.util.List<Importer> importers() {
        return this.importers;
    }

    private Logger logger() {
        return this.logger;
    }

    private Function1<PropertyKind, Object> isCollectionKind() {
        return this.isCollectionKind;
    }

    private File importablePackageDirectory() {
        return this.importablePackageDirectory;
    }

    private void importablePackageDirectory_$eq(File x$1) {
        this.importablePackageDirectory = x$1;
    }

    @PostConstruct
    public void initImporters() {
        Set importerClasses = Scannit.getInstance().getSubTypesOf(Importer.class);
        this.logger().debug("Found importers: {}", (Object)importerClasses);
        ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(importerClasses).asScala().filter((Function1 & Serializable)cls -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$initImporters$1(cls)))).foreach((Function1 & Serializable)importerClass -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$initImporters$2(this, importerClass)));
        this.importers().sort((o1, o2) -> o1.getClass().getSimpleName().compareTo(o2.getClass().getSimpleName()));
        this.importers().add((Importer)new XmlManifestDarImporter(this.repositoryService()));
        this.logger().debug("Importer {} registered.", XmlManifestDarImporter.class);
        this.logger().info("Importers configured in XL Deploy: {}", this.importers());
    }

    @Override
    public File getImportablePackageDirectory() {
        return this.importablePackageDirectory();
    }

    public void setImportablePackageDirectory(File importablePackageDirectory) {
        this.importablePackageDirectory_$eq(importablePackageDirectory);
    }

    @Override
    public java.util.List<String> listPackages() {
        return Lists.newArrayList((Iterable)CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(this.importers()).asScala().withFilter((Function1 & Serializable)importer -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$listPackages$1(importer))).flatMap((Function1 & Serializable)importer -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(((ListableImporter)importer).list(this.importablePackageDirectory())).asScala().map((Function1 & Serializable)pkgFound -> pkgFound))).sorted((Ordering)Ordering.String$.MODULE$)).asJava());
    }

    @Override
    public String importPackage(ImportSource source) {
        String string;
        block5: {
            try {
                Option option = CollectionConverters$.MODULE$.ListHasAsScala(this.importers()).asScala().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.canHandle(source)));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Importer importer = (Importer)some.value();
                    string = this.doImport(source, importer);
                    break block5;
                }
                if (None$.MODULE$.equals(option)) {
                    throw new ImporterException("The selected file does not have the expected format for an importable package", new Object[0]);
                }
                throw new MatchError((Object)option);
            }
            finally {
                source.cleanUp();
            }
        }
        return string;
    }

    public void checkPermission(Permission permission, String onConfigurationItems) {
        if (!permission.getPermissionHandler().hasPermission(onConfigurationItems)) {
            throw PermissionDeniedException.forPermission((Permission)permission, (String)onConfigurationItems);
        }
    }

    private String doImport(ImportSource source, Importer importer) {
        String string;
        DefaultImportingContext ctx = new DefaultImportingContext();
        PackageInfo packageInfo = importer.preparePackage(source, (ImportingContext)ctx);
        try {
            boolean upgrade = this.isUpgrade(packageInfo);
            this.checkPermission(upgrade, packageInfo);
            this.checkImported(packageInfo);
            ImportedPackage importedPackage = importer.importEntities(packageInfo, (ImportingContext)ctx);
            this.scanPlaceholders(importedPackage, ctx);
            HashSet toCreate = Sets.newHashSet();
            this.createEntities(importedPackage, upgrade, toCreate);
            this.validate(toCreate);
            if (upgrade) {
                importedPackage.getVersion().setApplication((Application)this.repositoryService().read(packageInfo.getApplicationId()));
            }
            CreateCisCommand event = new CreateCisCommand((java.util.List)Lists.newArrayList((Iterable)toCreate));
            this.repositoryHelper().publishCommand((RepositoryBaseCommand)event);
            string = importedPackage.getVersion().getId();
        }
        finally {
            importer.cleanUp(packageInfo, (ImportingContext)ctx);
        }
        return string;
    }

    private void scanPlaceholders(ImportedPackage importedPackage, ImportingContext ctx) {
        if (importedPackage.getVersion() instanceof DeploymentPackage) {
            ((java.util.List)ctx.getAttribute("temporaryFiles")).add(new TFile(Files.createTempDir()));
            CollectionConverters$.MODULE$.SetHasAsScala(package$.MODULE$.getAllArtifacts(importedPackage.getDeployables())).asScala().foreach((Function1 & Serializable)sourceArtifact -> {
                ImporterServiceImpl.$anonfun$scanPlaceholders$1(this, sourceArtifact);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void resolveAndEnrichArtifact(SourceArtifact sourceArtifact) {
        try {
            ResourceManagement$.MODULE$.using((Closeable)ArtifactResolverRegistry$.MODULE$.resolve(sourceArtifact), (Function1 & Serializable)resolve -> {
                ResourceManagement$.MODULE$.using((Closeable)resolve.openStream(), (Function1 & Serializable)is -> {
                    ImporterServiceImpl.$anonfun$resolveAndEnrichArtifact$2($this, sourceArtifact$1, resolve, is);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
        }
        catch (IOException iOException) {
            throw new ImporterException(new StringBuilder(53).append("Could not open stream of uri ").append(sourceArtifact.getFileUri()).append(" of unresolved artifact ").append(sourceArtifact).toString(), new Object[0]);
        }
    }

    private boolean isArtifactPreEnriched(SourceArtifact deployable) {
        boolean isPreEnrichedArtifact = PlaceholdersUtil$.MODULE$.SourceArtifactUtil(deployable).hasCheckSum() && deployable.hasProperty("preScannedPlaceholders") && BoxesRunTime.unboxToBoolean((Object)deployable.getProperty("preScannedPlaceholders"));
        this.logger().info(new StringBuilder(26).append("Artifact ").append(deployable).append(" is ").append((Object)(isPreEnrichedArtifact ? "" : "not")).append(" pre-enriched").toString());
        return isPreEnrichedArtifact;
    }

    private void checkImported(PackageInfo packageInfo) {
        String id = IdGenerator.generateId((String)packageInfo.getApplicationId(), (String)packageInfo.getApplicationVersion());
        if (this.repositoryService().exists(id)) {
            throw new ImporterException("Already imported version %s of application %s", packageInfo.getApplicationVersion(), packageInfo.getApplicationName());
        }
        String dirs = this.subStringBeforeLast(packageInfo.getApplicationId(), "/");
        if (!this.repositoryService().exists(dirs)) {
            throw new ImporterException("The directory structure [%s] specified for the import of application [%s] does not exist.", dirs, this.appName(packageInfo));
        }
    }

    private void createEntities(ImportedPackage importedPackage, boolean isUpgrade, Set<ConfigurationItem> toCreateCollector) {
        Object object = !isUpgrade ? BoxesRunTime.boxToBoolean((boolean)toCreateCollector.add((ConfigurationItem)importedPackage.getApplication())) : BoxedUnit.UNIT;
        Version version = importedPackage.getVersion();
        toCreateCollector.add((ConfigurationItem)version);
        this.filterExistingPackages(version).withFilter((Function1 & Serializable)pd -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$createEntities$1(this, pd))).foreach((Function1 & Serializable)pd -> {
            ImporterServiceImpl.$anonfun$createEntities$2(this, version, toCreateCollector, pd);
            return BoxedUnit.UNIT;
        });
    }

    private scala.collection.immutable.Set<PropertyDescriptor> filterExistingPackages(Version version) {
        scala.collection.immutable.Set propertyDescriptors = CollectionConverters$.MODULE$.CollectionHasAsScala(version.getType().getDescriptor().getPropertyDescriptors()).asScala().toSet();
        if (!(version instanceof CompositePackage)) {
            return propertyDescriptors;
        }
        return (scala.collection.immutable.Set)propertyDescriptors.filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$filterExistingPackages$1(x$2)));
    }

    private void createNestedConfigurationItems(ConfigurationItem ci, Set<ConfigurationItem> toCreateCollector) {
        Collection propertyDescriptors = ci.getType().getDescriptor().getPropertyDescriptors();
        CollectionConverters$.MODULE$.CollectionHasAsScala(propertyDescriptors).asScala().withFilter((Function1 & Serializable)propertyDescriptor -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$createNestedConfigurationItems$1(this, propertyDescriptor))).foreach((Function1 & Serializable)propertyDescriptor -> {
            ImporterServiceImpl.$anonfun$createNestedConfigurationItems$2(this, ci, toCreateCollector, propertyDescriptor);
            return BoxedUnit.UNIT;
        });
    }

    private void validate(Set<ConfigurationItem> toCreate) {
        Seq msgs = (Seq)CollectionConverters$.MODULE$.SetHasAsScala(toCreate).asScala().foldLeft((Object)scala.package$.MODULE$.Seq().empty(), (Function2 & Serializable)(acc, tc) -> {
            Seq validated = CollectionConverters$.MODULE$.ListHasAsScala(this.validator().validate(tc, (java.util.List)Lists.newArrayList((Iterable)toCreate))).asScala().toSeq();
            if (validated.nonEmpty()) {
                return (Seq)acc.$plus$plus((IterableOnce)validated);
            }
            return acc;
        });
        if (msgs.nonEmpty()) {
            throw new ImporterException("Import failed with the following validation errors %s", msgs.mkString(", "));
        }
    }

    private boolean isUpgrade(PackageInfo packageInfo) {
        boolean locationSpecified = packageInfo.getApplicationName().contains("/");
        List applications = CollectionConverters$.MODULE$.ListHasAsScala(this.repositoryService().list(new SearchParameters().setType(Type.valueOf(Application.class)).setName(this.appName(packageInfo)).setAncestor(packageInfo.getApplicationRoot()))).asScala().toList();
        boolean bl = false;
        .colon.colon colon2 = null;
        List list = applications;
        if (Nil$.MODULE$.equals(list)) {
            return false;
        }
        if (list instanceof .colon.colon) {
            bl = true;
            colon2 = (.colon.colon)list;
            ConfigurationItemData app = (ConfigurationItemData)colon2.head();
            List list2 = colon2.next$access$1();
            if (Nil$.MODULE$.equals(list2) && locationSpecified) {
                String string = app.getId();
                String string2 = packageInfo.getApplicationId();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    throw new ImporterException("The manifest contains the path [%s] to import the application into, but the application exists at the path [%s]", packageInfo.getApplicationId(), app.getId());
                }
            }
        }
        if (bl) {
            ConfigurationItemData app = (ConfigurationItemData)colon2.head();
            List list3 = colon2.next$access$1();
            if (Nil$.MODULE$.equals(list3)) {
                String appId = app.getId();
                packageInfo.setDirectories(appId.substring(packageInfo.getApplicationRoot().length(), appId.length() - packageInfo.getApplicationName().length()));
                return true;
            }
        }
        if (bl) {
            ConfigurationItemData app = (ConfigurationItemData)colon2.head();
            throw new IllegalStateException(new StringBuilder(43).append("Found more than 1 [").append(app.getType()).append("] with the same name: [").append(applications.mkString(", ")).append("]").toString());
        }
        throw new MatchError((Object)list);
    }

    private String appName(PackageInfo packageInfo) {
        return this.subStringAfterLast(packageInfo.getApplicationId(), "/");
    }

    private String subStringAfterLast(String s, String sep) {
        if (!s.contains(sep)) {
            return s;
        }
        return s.substring(s.lastIndexOf(sep) + sep.length());
    }

    private String subStringBeforeLast(String s, String sep) {
        if (!s.contains(sep)) {
            return s;
        }
        return s.substring(0, s.lastIndexOf(sep));
    }

    private void checkPermission(boolean isUpgrade, PackageInfo packageInfo) {
        Permission requiredPermission = isUpgrade ? DeployitPermissions$.MODULE$.IMPORT_UPGRADE() : DeployitPermissions$.MODULE$.IMPORT_INITIAL();
        this.checkPermission(requiredPermission, packageInfo.getApplicationId());
    }

    public static final /* synthetic */ boolean $anonfun$isCollectionKind$1(PropertyKind kind) {
        return kind == PropertyKind.SET_OF_CI || kind == PropertyKind.LIST_OF_CI;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$initImporters$1(Class cls) {
        if (cls.isInterface()) return false;
        if (Modifier.isAbstract(cls.getModifiers())) return false;
        Class clazz = cls;
        Class<XmlManifestDarImporter> clazz2 = XmlManifestDarImporter.class;
        if (clazz == null) {
            if (clazz2 == null) return false;
            return true;
        } else if (clazz.equals(clazz2)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$initImporters$2(ImporterServiceImpl $this, Class importerClass) {
        boolean bl;
        try {
            $this.logger().debug("Importer {} registered.", (Object)importerClass);
            bl = $this.importers().add((Importer)importerClass.newInstance());
        }
        catch (Exception e) {
            throw new IllegalStateException(new StringBuilder(32).append("Could not instantiate importer: ").append(importerClass).toString(), e);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$listPackages$1(Importer importer) {
        return importer instanceof ListableImporter;
    }

    public static final /* synthetic */ void $anonfun$scanPlaceholders$1(ImporterServiceImpl $this, SourceArtifact sourceArtifact) {
        if (ArtifactFileUtils.hasRealOrResolvedFile((Artifact)sourceArtifact)) {
            $this.logger().info("Artifact {} is a resolved artifact", (Object)sourceArtifact);
            if (!$this.isArtifactPreEnriched(sourceArtifact)) {
                PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sourceArtifact).addChecksumAndScan($this.scanner(), (Function0 & Serializable)() -> $this.checksumAlgorithmProvider().getMessageDigest());
                return;
            }
            return;
        }
        $this.logger().info(new StringBuilder(29).append("Resolving artifact ").append(sourceArtifact).append(" from url ").append(sourceArtifact.getFileUri()).toString());
        $this.resolveAndEnrichArtifact(sourceArtifact);
    }

    public static final /* synthetic */ void $anonfun$resolveAndEnrichArtifact$2(ImporterServiceImpl $this, SourceArtifact sourceArtifact$1, ResolvedArtifactFile resolve$1, InputStream is) {
        if (!$this.isArtifactPreEnriched(sourceArtifact$1)) {
            PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sourceArtifact$1).addChecksumAndScan($this.scanner(), resolve$1.getFileName(), is, (Function0 & Serializable)() -> $this.checksumAlgorithmProvider().getMessageDigest());
        }
        sourceArtifact$1.setFile(LocalFile.valueOf((File)new File(resolve$1.getFileName())));
    }

    public static final /* synthetic */ boolean $anonfun$createEntities$1(ImporterServiceImpl $this, PropertyDescriptor pd) {
        return BoxesRunTime.unboxToBoolean((Object)$this.isCollectionKind().apply((Object)pd.getKind()));
    }

    public static final /* synthetic */ void $anonfun$createEntities$2(ImporterServiceImpl $this, Version version$1, Set toCreateCollector$1, PropertyDescriptor pd) {
        Collection cis = (Collection)pd.get((ConfigurationItem)version$1);
        toCreateCollector$1.addAll(Sets.newHashSet((Iterable)cis));
        cis.forEach(ci -> $this.createNestedConfigurationItems((ConfigurationItem)ci, toCreateCollector$1));
    }

    public static final /* synthetic */ boolean $anonfun$filterExistingPackages$1(PropertyDescriptor x$2) {
        String string = x$2.getName();
        String string2 = "packages";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createNestedConfigurationItems$1(ImporterServiceImpl $this, PropertyDescriptor propertyDescriptor) {
        return BoxesRunTime.unboxToBoolean((Object)$this.isCollectionKind().apply((Object)propertyDescriptor.getKind())) && !propertyDescriptor.getName().toLowerCase().contains("dependencies");
    }

    public static final /* synthetic */ boolean $anonfun$createNestedConfigurationItems$3(Set toCreateCollector$2, ConfigurationItem embedded) {
        return !toCreateCollector$2.contains(embedded);
    }

    public static final /* synthetic */ void $anonfun$createNestedConfigurationItems$4(ImporterServiceImpl $this, Set toCreateCollector$2, ConfigurationItem embedded) {
        toCreateCollector$2.add(embedded);
        $this.createNestedConfigurationItems(embedded, toCreateCollector$2);
    }

    public static final /* synthetic */ void $anonfun$createNestedConfigurationItems$2(ImporterServiceImpl $this, ConfigurationItem ci$1, Set toCreateCollector$2, PropertyDescriptor propertyDescriptor) {
        CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)propertyDescriptor.get(ci$1)).asScala().withFilter((Function1 & Serializable)embedded -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$createNestedConfigurationItems$3(toCreateCollector$2, embedded))).foreach((Function1 & Serializable)embedded -> {
            ImporterServiceImpl.$anonfun$createNestedConfigurationItems$4($this, toCreateCollector$2, embedded);
            return BoxedUnit.UNIT;
        });
    }

    @Autowired
    public ImporterServiceImpl(RepositoryService repositoryService, RoleService roleService, Validator validator, SourceArtifactScanner scanner, ClientProperties clientConfiguration, RepositoryHelper repositoryHelper, ChecksumAlgorithmProvider checksumAlgorithmProvider) {
        this.repositoryService = repositoryService;
        this.roleService = roleService;
        this.validator = validator;
        this.scanner = scanner;
        this.clientConfiguration = clientConfiguration;
        this.repositoryHelper = repositoryHelper;
        this.checksumAlgorithmProvider = checksumAlgorithmProvider;
        this.importers = Lists.newArrayList();
        this.logger = LoggerFactory.getLogger(ImporterServiceImpl.class);
        this.isCollectionKind = (Function1 & Serializable)kind -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$isCollectionKind$1(kind));
        this.importablePackageDirectory = new File(this.clientConfiguration().getImportablePackageDirectory());
    }
}

