/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.service.deployment.AbstractChainGenerator;
import com.xebialabs.deployit.service.deployment.DeployedGenerator;
import com.xebialabs.deployit.service.deployment.DeploymentContext;
import com.xebialabs.deployit.service.deployment.GeneratedDeployeds;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerDeployableTypeGenerator
extends AbstractChainGenerator {
    private static final Logger log = LoggerFactory.getLogger(PerDeployableTypeGenerator.class);
    private final Map<Type, Class<? extends DeployedGenerator>> generatorsPerDeployableType;

    public PerDeployableTypeGenerator(Map<Type, Class<? extends DeployedGenerator>> generatorsPerDeployableType, DeployedGenerator processor) {
        super(processor);
        this.generatorsPerDeployableType = generatorsPerDeployableType;
    }

    @Override
    public GeneratedDeployeds generateDeployed(DeploymentContext deploymentContext, Deployable deployable, Container container) {
        DeployedGenerator deployedGenerator = this.findMatchingProcessor(deployable).map(this::initializeProcessor).orElseGet(() -> this.nextGenerator);
        return deployedGenerator.generateDeployed(deploymentContext, deployable, container);
    }

    private Optional<Class<? extends DeployedGenerator>> findMatchingProcessor(Deployable deployable) {
        Stream superTypes = deployable.getType().getDescriptor().getSuperClasses().stream();
        Stream<Type> thisType = Stream.of(deployable.getType());
        return Stream.concat(thisType, superTypes).filter(this.generatorsPerDeployableType::containsKey).findFirst().map(this.generatorsPerDeployableType::get);
    }

    private DeployedGenerator initializeProcessor(Class<? extends DeployedGenerator> clazz) {
        try {
            log.debug("Creating per-deployable-type deployed generator {}", clazz);
            Constructor<? extends DeployedGenerator> constructor = clazz.getConstructor(DeployedGenerator.class);
            return constructor.newInstance(this.nextGenerator);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

