package com.xebialabs.deployit.listener.deployment

import ai.digital.deploy.tasker.common.{TaskMetadata, TaskType}
import com.xebialabs.deployit.engine.api.execution.{SerializableTask, TaskExecutionState}
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication
import com.xebialabs.deployit.repository.RepositoryServiceHolder.getRepositoryService
import com.xebialabs.deployit.repository.SearchParameters

import scala.jdk.CollectionConverters._

object DeploymentStatusUtils {
  val explorerPath = "/#/explorer"

  def extractMetadata(field: String)(task: SerializableTask): String = Option(task.getMetadata.get(field)).getOrElse("")
  def getApplicationPathFromTaskId(taskId: String): String = s"$explorerPath?taskId=$taskId"
  def getApplicationPathFromVersionId(versionId: String): String = s"$explorerPath?ciId=${this.getApplicationIdFromVersionId(versionId)}"
  def getApplicationIdFromVersionId(versionId: String): String = versionId.substring(0, versionId.lastIndexOf("/"))
  def isDeleteEvent(task: SerializableTask): Boolean = {
    val isUndeployed = extractMetadata(TaskMetadata.TASK_TYPE)(task).equals(TaskType.UNDEPLOY.toString) && task.getState.equals(TaskExecutionState.DONE)
    val isInitialCancelledOrFailed = extractMetadata(TaskMetadata.TASK_TYPE)(task).equals(TaskType.INITIAL.toString) && (task.getState.equals(TaskExecutionState.CANCELLED) || task.getState.equals(TaskExecutionState.FAILED))
    val isInitialRollbacked = extractMetadata(TaskMetadata.ROLLBACK_TYPE)(task).equals(TaskType.INITIAL.toString) && task.getState.equals(TaskExecutionState.DONE)
    isUndeployed || isInitialCancelledOrFailed || isInitialRollbacked
  }
  def isUpgradeCancelled(task: SerializableTask): Boolean = {
    extractMetadata(TaskMetadata.TASK_TYPE)(task).equals(TaskType.UPGRADE.toString) && (task.getState.equals(TaskExecutionState.CANCELLED) || task.getState.equals(TaskExecutionState.FAILED))
  }
  def resolveTaskApplicationPath(task: SerializableTask): String = {
    if (task.getState.equals(TaskExecutionState.DONE))
      getApplicationPathFromVersionId(extractMetadata(TaskMetadata.VERSION_ID)(task))
    else getApplicationPathFromTaskId(task.getId)
  }
  def resolveApplicationVersion(task: SerializableTask): String = {
    if (isUpgradeCancelled(task)) {
      val deployedApplication = getRepositoryService
        .listEntities[DeployedApplication](new SearchParameters().setType(Type.valueOf(classOf[DeployedApplication])).setName(extractMetadata(TaskMetadata.APPLICATION)(task)))
        .asScala
        .find(app => app.getEnvironment.getName.equals(extractMetadata(TaskMetadata.ENVIRONMENT)(task)))
      deployedApplication.map(_.getVersion.getVersion).getOrElse("")
    }
    else extractMetadata(TaskMetadata.VERSION)(task)
  }

  def resolveApplicationStatus(task: SerializableTask): TaskExecutionState = {
    if (isUpgradeCancelled(task)) TaskExecutionState.DONE else task.getState
  }
}
