/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.deployment.planner.DeltaSpecificationBuilder;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentOperationCalculator {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentOperationCalculator.class);

    private DeploymentOperationCalculator() {
    }

    public static DeltaSpecificationBuilder calculate(DeltaSpecificationBuilder builder, Set<? extends Deployed> oldDeployeds, Set<? extends Deployed> newDeployeds) {
        Checks.checkNotNull(oldDeployeds, (String)"Cannot calculate on null old Deployeds");
        Checks.checkNotNull(newDeployeds, (String)"Cannot calculate on null new Deployeds");
        if (oldDeployeds.isEmpty()) {
            for (Deployed deployed : newDeployeds) {
                builder.create(deployed);
            }
        } else if (newDeployeds.isEmpty()) {
            for (Deployed deployed : oldDeployeds) {
                builder.destroy(deployed);
            }
        } else {
            DeploymentOperationCalculator.calculateUpgrade(builder, oldDeployeds, newDeployeds);
        }
        return builder;
    }

    public static DeltaSpecificationBuilder deltaToRedeploy(DeltaSpecificationBuilder builder, Set<? extends Deployed> oldDeployeds, Set<? extends Deployed> newDeployeds) {
        Checks.checkNotNull(oldDeployeds, (String)"Cannot calculate on null old Deployeds");
        Checks.checkNotNull(newDeployeds, (String)"Cannot calculate on null new Deployeds");
        oldDeployeds.stream().forEach(oldDeployed -> builder.destroy(oldDeployed));
        newDeployeds.stream().forEach(newDeployed -> builder.create(newDeployed));
        return builder;
    }

    static void calculateUpgrade(DeltaSpecificationBuilder builder, Set<? extends Deployed> oldDeployeds, Set<? extends Deployed> newDeployeds) {
        HashSet olds = Sets.newHashSet(oldDeployeds);
        HashSet news = Sets.newHashSet(newDeployeds);
        for (Deployed old : olds) {
            Deployed aNew = DeploymentOperationCalculator.findSimilar(old, news);
            if (aNew != null) {
                news.remove(aNew);
                if (DeploymentOperationCalculator.isDifferent(old, aNew)) {
                    builder.modify(old, aNew);
                    continue;
                }
                builder.noOp(aNew);
                continue;
            }
            builder.destroy(old);
        }
        for (Deployed aNew : news) {
            builder.create(aNew);
        }
    }

    static Deployed findSimilar(Deployed old, Set<? extends Deployed> news) {
        for (Deployed deployed : news) {
            if (!DeploymentOperationCalculator.isSimilar(old, deployed)) continue;
            return deployed;
        }
        return null;
    }

    static boolean isDifferent(Deployed old, Deployed aNew) {
        logger.debug("Comparing {} to {}", (Object)old, (Object)aNew);
        if (!old.getType().equals((Object)aNew.getType())) {
            logger.debug("Difference detected: Types do not match: {} <-> {}", (Object)old.getType(), (Object)aNew.getType());
            return true;
        }
        Descriptor d = DescriptorRegistry.getDescriptor((Type)old.getType());
        for (PropertyDescriptor pd : d.getPropertyDescriptors()) {
            if (pd.getName().equals("deployable") || pd.getName().equals("container") || pd.isHidden() || pd.isTransient()) {
                logger.debug("Skipping property {} in comparison of {}", (Object)pd.getFqn(), (Object)aNew.getId());
                continue;
            }
            if (pd.areEqual((ConfigurationItem)old, (ConfigurationItem)aNew)) continue;
            logger.debug("Difference detected: Property {} does not match", (Object)pd.getFqn());
            logger.trace("- old Property value {}", pd.get((ConfigurationItem)old));
            logger.trace("- new Property value {}", pd.get((ConfigurationItem)aNew));
            return true;
        }
        return DeploymentOperationCalculator.isDifferent(old.getDeployable(), aNew.getDeployable());
    }

    private static boolean isSourceArtifact(Descriptor d) {
        return d.getType().isSubTypeOf(Type.valueOf(SourceArtifact.class));
    }

    static boolean isDifferent(Deployable oldDeployable, Deployable newDeployable) {
        if (!oldDeployable.getType().equals((Object)newDeployable.getType())) {
            return true;
        }
        Descriptor d = DescriptorRegistry.getDescriptor((Type)oldDeployable.getType());
        for (PropertyDescriptor pd : d.getPropertyDescriptors()) {
            if (pd.getName().equals("tags") || DeploymentOperationCalculator.isSourceArtifact(d) && pd.getName().equals("fileUri") || pd.isHidden() || pd.areEqual((ConfigurationItem)oldDeployable, (ConfigurationItem)newDeployable, ConfigurationItem::getName) && (!DeploymentOperationCalculator.isSourceArtifact(d) || !pd.getName().equals("isRescanned") || !pd.get((ConfigurationItem)newDeployable).equals(true))) continue;
            return true;
        }
        return false;
    }

    static boolean isSimilar(Deployed old, Deployed aNew) {
        return aNew.getId().equals(old.getId()) && old.getType().equals((Object)aNew.getType());
    }
}

