package com.xebialabs.deployit.service.importer.reader;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.server.api.importer.ImportingContext;
import com.xebialabs.deployit.server.api.importer.PackageInfo;

import java.util.List;
import java.util.Map;

public interface ManifestReader {
    void readPackageData(PackageInfo packageInfo, ImportingContext context);

    ManifestCiReader versionReader();

    interface ManifestCiReader {
        Type type();

        String name();

        String file();

        default Type distributionType() {
            return Type.valueOf(Application.class);
        }

        boolean hasProperty(String name);

        List<String> allProperties();

        String propertyAsString(String name);

        String propertyAsCiRef(String name);

        List<String> propertyAsStringCollection(String name);

        List<String> propertyAsCiRefCollection(String name);

        Map<String,String> propertyAsMapStringString(String name);

        List<ManifestCiReader> propertyAsNestedCis(String name);
    }
}
