package com.xebialabs.deployit.plumbing

import com.xebialabs.deployit.engine.spi.exception.DeployitException

import java.io.IOException
import java.util.Properties
import org.springframework.core.io.ClassPathResource

object CurrentVersion {

  val RELEASE_PROPERTIES = "plugin-version.properties"

  private val VERSION_PROPERTY = "version"
  private val VERSION_0 = "0.0.0"
  private val VERSION_NOT_DEFINED = "version-not-defined"
  private val VERSION_PLACEHOLDER = "@project.version@"

  private lazy val version: Option[String] = {
    val resource = new ClassPathResource(RELEASE_PROPERTIES)
    val properties = new Properties
    try {
      properties.load(resource.getInputStream)
    } catch {
      case ioe: IOException =>
        throw PluginVersionNotFoundException(ioe)
    }
    val property = properties.getProperty(VERSION_PROPERTY)

    if (VERSION_PLACEHOLDER.equalsIgnoreCase(property)) Some(VERSION_0) else Option(property)
  }

  def get: String = version.getOrElse(VERSION_NOT_DEFINED)

}

final case class PluginVersionNotFoundException (throwable: Throwable) extends DeployitException {
  override def getMessage = s"File ${CurrentVersion.RELEASE_PROPERTIES} not found!"
}
