package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

import static java.util.stream.Stream.concat;

public class PerDeployableTypeGenerator extends AbstractChainGenerator {

    private static final Logger log = LoggerFactory.getLogger(PerDeployableTypeGenerator.class);

    private final Map<Type, Class<? extends DeployedGenerator>> generatorsPerDeployableType;

    public PerDeployableTypeGenerator(Map<Type, Class<? extends DeployedGenerator>> generatorsPerDeployableType, DeployedGenerator processor) {
        super(processor);
        this.generatorsPerDeployableType = generatorsPerDeployableType;
    }

    @Override
    public GeneratedDeployeds generateDeployed(DeploymentContext deploymentContext, Deployable deployable, Container container) {
        DeployedGenerator deployedGenerator = findMatchingProcessor(deployable).map(this::initializeProcessor).orElseGet(() -> nextGenerator);
        return deployedGenerator.generateDeployed(deploymentContext, deployable, container);
    }

    private Optional<Class<? extends DeployedGenerator>> findMatchingProcessor(Deployable deployable) {
        Stream<Type> superTypes = deployable.getType().getDescriptor().getSuperClasses().stream();
        Stream<Type> thisType = Stream.of(deployable.getType());
        return concat(thisType, superTypes).filter(generatorsPerDeployableType::containsKey).findFirst().map(generatorsPerDeployableType::get);
    }

    private DeployedGenerator initializeProcessor(Class<? extends DeployedGenerator> clazz) {
        try {
            log.debug("Creating per-deployable-type deployed generator {}", clazz);
            Constructor<? extends DeployedGenerator> constructor = clazz.getConstructor(DeployedGenerator.class);
            return constructor.newInstance(nextGenerator);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
