/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.spring;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import com.esotericsoftware.kryo.Serializer;
import com.xebialabs.deployit.core.rest.websockets.RemoteChangeSetEventListener$;
import com.xebialabs.deployit.engine.api.distribution.TaskExecutionWorkerRepository;
import com.xebialabs.deployit.engine.spi.services.RepositoryFactory;
import com.xebialabs.deployit.engine.tasker.Archive;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.engine.tasker.TaskExecutionWorker$;
import com.xebialabs.deployit.engine.tasker.TaskFinalizer;
import com.xebialabs.deployit.engine.tasker.TaskFinalizerImpl;
import com.xebialabs.deployit.engine.tasker.TaskQueueService;
import com.xebialabs.deployit.engine.tasker.TaskerException;
import com.xebialabs.deployit.engine.tasker.distribution.versioning.ConfigurationHashProvider;
import com.xebialabs.deployit.engine.tasker.log.StepLogFactory;
import com.xebialabs.deployit.engine.tasker.log.StepLogRetriever;
import com.xebialabs.deployit.engine.tasker.query.QueryActor$;
import com.xebialabs.deployit.engine.tasker.repository.ActiveTaskRepository;
import com.xebialabs.deployit.engine.tasker.repository.CrudTaskRepository;
import com.xebialabs.deployit.engine.tasker.repository.PendingTaskRepository;
import com.xebialabs.deployit.engine.tasker.satellite.WorkDirSerializer;
import com.xebialabs.deployit.engine.tasker.satellite.WorkDirSerializer$;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.service.discovery.DiscoveryService;
import com.xebialabs.deployit.service.discovery.DiscoveryWorker$;
import com.xebialabs.deployit.spring.EngineBeanBuilder$;
import com.xebialabs.deployit.tasksystem.TaskActorSystem$;
import com.xebialabs.xlplatform.akka25.Akka25$;
import com.xebialabs.xlplatform.settings.shared.TaskerSettings;
import io.altoo.akka.serialization.kryo.KryoAkkaSerializer;
import io.altoo.akka.serialization.kryo.KryoCustomizer;
import java.io.File;
import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import scala.Function0;
import scala.MatchError;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Configuration
@Lazy
@DependsOn(value={"repositoryServiceHolder", "placeholderRepositoryHolder", "artifactResolver", "commandWhitelistValidator"})
@ScalaSignature(bytes="\u0006\u0005\tue\u0001\u0002\u000e\u001c\u0001\u0011B\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001\f\u0005\tk\u0001\u0011\t\u0011)A\u0005[!Aa\u0007\u0001BC\u0002\u0013\u0005q\u0007\u0003\u0005A\u0001\t\u0005\t\u0015!\u00039\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u001d9\u0006A1A\u0005\naCaa\u0018\u0001!\u0002\u0013I\u0006b\u00021\u0001\u0005\u0004%y!\u0019\u0005\u0007U\u0002\u0001\u000bQ\u00022\t\u0013-\u0004\u0001\u0019!a\u0001\n\u0003a\u0007\"C;\u0001\u0001\u0004\u0005\r\u0011\"\u0001w\u0011%a\b\u00011A\u0001B\u0003&Q\u000eC\u0006\u0002\n\u0001\u0001\r\u00111A\u0005\u0002\u0005-\u0001bCA\n\u0001\u0001\u0007\t\u0019!C\u0001\u0003+A1\"!\u0007\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u000e!9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0002bBA\u001b\u0001\u0011\u0005\u0011q\u0007\u0005\u0007e\u0001!\t!a\u001e\t\u000f\tu\u0001\u0001\"\u0001\u0003 !9!\u0011\b\u0001\u0005\u0002\u0005\r\u0002b\u0002B\"\u0001\u0011%!QI\u0004\b\u0005_Z\u0002\u0012\u0001B9\r\u0019Q2\u0004#\u0001\u0003t!1\u0011i\u0006C\u0001\u0005kBqAa\u001e\u0018\t\u0003\u0011IHA\tF]\u001eLg.\u001a\"fC:\u0014U/\u001b7eKJT!\u0001H\u000f\u0002\rM\u0004(/\u001b8h\u0015\tqr$\u0001\u0005eKBdw._5u\u0015\t\u0001\u0013%A\u0005yK\nL\u0017\r\\1cg*\t!%A\u0002d_6\u001c\u0001a\u0005\u0002\u0001KA\u0011a%K\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\t1\u0011I\\=SK\u001a\fq!\u0019:dQ&4X-F\u0001.!\tq3'D\u00010\u0015\t\u0001\u0014'\u0001\u0004uCN\\WM\u001d\u0006\u0003eu\ta!\u001a8hS:,\u0017B\u0001\u001b0\u0005\u001d\t%o\u00195jm\u0016\f\u0001\"\u0019:dQ&4X\rI\u0001\u0012e\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014X#\u0001\u001d\u0011\u0005erT\"\u0001\u001e\u000b\u0005mb\u0014\u0001C:feZL7-Z:\u000b\u0005u\n\u0014aA:qS&\u0011qH\u000f\u0002\u0012%\u0016\u0004xn]5u_JLh)Y2u_JL\u0018A\u0005:fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;fe\u0002\na\u0001P5oSRtDcA\"F+B\u0011A\tA\u0007\u00027!)1&\u0002a\u0001[!\u0012Qi\u0012\t\u0003\u0011Nk\u0011!\u0013\u0006\u0003\u0015.\u000b!\"\u00198o_R\fG/[8o\u0015\taU*A\u0004gC\u000e$xN]=\u000b\u00059{\u0015!\u00022fC:\u001c(B\u0001)R\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001*\u0002\u0007=\u0014x-\u0003\u0002U\u0013\nI\u0011)\u001e;po&\u0014X\r\u001a\u0005\u0006m\u0015\u0001\r\u0001\u000f\u0015\u0003+\u001e\u000ba\u0001\\8hO\u0016\u0014X#A-\u0011\u0005ikV\"A.\u000b\u0005q\u000b\u0016!B:mMRR\u0017B\u00010\\\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013AB:zgR,W.F\u0001c!\t\u0019\u0007.D\u0001e\u0015\t)g-A\u0003bGR|'OC\u0001h\u0003\u0011\t7n[1\n\u0005%$'aC!di>\u00148+_:uK6\fqa]=ti\u0016l\u0007%A\u0006cCN,wk\u001c:l\t&\u0014X#A7\u0011\u00059\u001cX\"A8\u000b\u0005A\f\u0018AA5p\u0015\u0005\u0011\u0018\u0001\u00026bm\u0006L!\u0001^8\u0003\t\u0019KG.Z\u0001\u0010E\u0006\u001cXmV8sW\u0012K'o\u0018\u0013fcR\u0011qO\u001f\t\u0003MaL!!_\u0014\u0003\tUs\u0017\u000e\u001e\u0005\bw.\t\t\u00111\u0001n\u0003\rAH%M\u0001\rE\u0006\u001cXmV8sW\u0012K'\u000f\t\u0015\u0007\u0019y\f\u0019!!\u0002\u0011\u0005!{\u0018bAA\u0001\u0013\n)a+\u00197vK\u0006)a/\u00197vK\u0006\u0012\u0011qA\u0001\u000fGm\u0014\u0017m]3X_J\\G)\u001b:~\u0003MIg\u000e\u0015:pG\u0016\u001c8\u000fV1tW\u0016sw-\u001b8f+\t\ti\u0001E\u0002'\u0003\u001fI1!!\u0005(\u0005\u001d\u0011un\u001c7fC:\fq#\u001b8Qe>\u001cWm]:UCN\\WI\\4j]\u0016|F%Z9\u0015\u0007]\f9\u0002\u0003\u0005|\u001d\u0005\u0005\t\u0019AA\u0007\u0003QIg\u000e\u0015:pG\u0016\u001c8\u000fV1tW\u0016sw-\u001b8fA!2qB`A\u0002\u0003;\t#!a\b\u0002K\u0011ZH-\u001a9m_ftC/Y:l]%tW\u0006\u001d:pG\u0016\u001c8/L<pe.,'O\u000f;sk\u0016l\u0018AC5oSRL\u0017\r\\5{KR\tq\u000fK\u0002\u0011\u0003O\u0001B!!\u000b\u000225\u0011\u00111\u0006\u0006\u0004\u0015\u00065\"BAA\u0018\u0003\u0015Q\u0017M^1y\u0013\u0011\t\u0019$a\u000b\u0003\u001bA{7\u000f^\"p]N$(/^2u\u000359xN]6fe6\u000bg.Y4feR1\u0011\u0011HA \u0003'\u00022aYA\u001e\u0013\r\ti\u0004\u001a\u0002\t\u0003\u000e$xN\u001d*fM\"9\u0011\u0011I\tA\u0002\u0005\r\u0013!\b;bg.,\u00050Z2vi&|gnV8sW\u0016\u0014(+\u001a9pg&$xN]=\u0011\t\u0005\u0015\u0013qJ\u0007\u0003\u0003\u000fRA!!\u0013\u0002L\u0005aA-[:ue&\u0014W\u000f^5p]*\u0019\u0011QJ\u0019\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002R\u0005\u001d#!\b+bg.,\u00050Z2vi&|gnV8sW\u0016\u0014(+\u001a9pg&$xN]=\t\u000f\u0005U\u0013\u00031\u0001\u0002X\u0005I2m\u001c8gS\u001e,(/\u0019;j_:D\u0015m\u001d5Qe>4\u0018\u000eZ3s!\u0011\tI&!\u0019\u000e\u0005\u0005m#\u0002BA/\u0003?\n!B^3sg&|g.\u001b8h\u0015\r\tIeL\u0005\u0005\u0003G\nYFA\rD_:4\u0017nZ;sCRLwN\u001c%bg\"\u0004&o\u001c<jI\u0016\u0014\bFA\tHQ\r\t\u0012\u0011\u000e\t\u0005\u0003W\n\u0019(\u0004\u0002\u0002n)\u0019!*a\u001c\u000b\u0007\u0005Et*A\u0004d_:$X\r\u001f;\n\t\u0005U\u0014Q\u000e\u0002\u0005\u0005\u0016\fg\u000e\u0006\f\u0002z\u0005}\u0014qRAM\u0003\u000b\f9-!4\u0002^\u0006\u001d\u0018\u0011\u001eB\u0001!\rq\u00131P\u0005\u0004\u0003{z#a\u0005+bg.,\u00050Z2vi&|g.\u00128hS:,\u0007bBAA%\u0001\u0007\u00111Q\u0001\u0015C\u000e$\u0018N^3UCN\\'+\u001a9pg&$xN]=\u0011\t\u0005\u0015\u00151R\u0007\u0003\u0003\u000fS1!!#0\u0003)\u0011X\r]8tSR|'/_\u0005\u0005\u0003\u001b\u000b9I\u0001\u000bBGRLg/\u001a+bg.\u0014V\r]8tSR|'/\u001f\u0005\b\u0003#\u0013\u0002\u0019AAJ\u0003U\u0001XM\u001c3j]\u001e$\u0016m]6SKB|7/\u001b;pef\u0004B!!\"\u0002\u0016&!\u0011qSAD\u0005U\u0001VM\u001c3j]\u001e$\u0016m]6SKB|7/\u001b;pefDq!a'\u0013\u0001\u0004\ti*\u0001\td_:$\u0018-\u001b8fe\u001a\u000b7\r^8ssB1\u0011qTAU\u0003[k!!!)\u000b\t\u0005\r\u0016QU\u0001\u0007G>tg-[4\u000b\u0007\u0005\u001dv*A\u0002k[NLA!a+\u0002\"\nY\"*\\:MSN$XM\\3s\u0007>tG/Y5oKJ4\u0015m\u0019;pef\u0004B!a,\u000266\u0011\u0011\u0011\u0017\u0006\u0005\u0003g\u000b)+\u0001\u0005mSN$XM\\3s\u0013\u0011\t9,!-\u0003?\u0011+g-Y;mi6+7o]1hK2K7\u000f^3oKJ\u001cuN\u001c;bS:,'\u000f\u000b\u0005\u0002\u001a\u0006m\u00161AAa!\rA\u0015QX\u0005\u0004\u0003\u007fK%!C)vC2Lg-[3sC\t\t\u0019-A\u000fyY*k7\u000fT5ti\u0016tWM]\"p]R\f\u0017N\\3s\r\u0006\u001cGo\u001c:z\u0011\u001d\t\tE\u0005a\u0001\u0003\u0007Bq!!\u000e\u0013\u0001\u0004\tI\u0004\u000b\u0005\u0002H\u0006m\u00161AAfC\t\t)\u0004C\u0004\u0002PJ\u0001\r!!5\u0002\u001dM$X\r\u001d'pO\u001a\u000b7\r^8ssB!\u00111[Am\u001b\t\t)NC\u0002\u0002X>\n1\u0001\\8h\u0013\u0011\tY.!6\u0003\u001dM#X\r\u001d'pO\u001a\u000b7\r^8ss\"9\u0011q\u001c\nA\u0002\u0005\u0005\u0018\u0001E:uKBdun\u001a*fiJLWM^3s!\u0011\t\u0019.a9\n\t\u0005\u0015\u0018Q\u001b\u0002\u0011'R,\u0007\u000fT8h%\u0016$(/[3wKJDq!!\u0016\u0013\u0001\u0004\t9\u0006C\u0004\u0002lJ\u0001\r!!<\u0002\u001dQ\f7o[3s'\u0016$H/\u001b8hgB!\u0011q^A\u007f\u001b\t\t\tP\u0003\u0003\u0002t\u0006U\u0018AB:iCJ,GM\u0003\u0003\u0002x\u0006e\u0018\u0001C:fiRLgnZ:\u000b\u0007\u0005mx$\u0001\u0006yYBd\u0017\r\u001e4pe6LA!a@\u0002r\nqA+Y:lKJ\u001cV\r\u001e;j]\u001e\u001c\bb\u0002B\u0002%\u0001\u0007!QA\u0001\u0011i\u0006\u001c8.U;fk\u0016\u001cVM\u001d<jG\u0016\u00042A\fB\u0004\u0013\r\u0011Ia\f\u0002\u0011)\u0006\u001c8.U;fk\u0016\u001cVM\u001d<jG\u0016D#AE$)\u000fI\u0011y!a\u0001\u0003\u0016A!\u00111\u000eB\t\u0013\u0011\u0011\u0019\"!\u001c\u0003\u0013\u0011+\u0007/\u001a8eg>sGF\u0001B\fC\t\u0011I\"\u0001\u0005va\u001e\u0014\u0018\rZ3sQ\r\u0011\u0012\u0011N\u0001\u0011I&\u001c8m\u001c<fef\u001cVM\u001d<jG\u0016$BA!\t\u00032A!!1\u0005B\u0017\u001b\t\u0011)C\u0003\u0003\u0003(\t%\u0012!\u00033jg\u000e|g/\u001a:z\u0015\r\u0011Y#H\u0001\bg\u0016\u0014h/[2f\u0013\u0011\u0011yC!\n\u0003!\u0011K7oY8wKJL8+\u001a:wS\u000e,\u0007bBA\u001b'\u0001\u0007\u0011\u0011\b\u0015\t\u0005c\tY,a\u0001\u0002L\"\u00121c\u0012\u0015\u0004'\u0005%\u0014a\u00023fgR\u0014x.\u001f\u0015\u0004)\tu\u0002\u0003BA\u0015\u0005\u007fIAA!\u0011\u0002,\tQ\u0001K]3EKN$(o\\=\u0002\u001fI,7o\u00195fIVdW\rV1tWN$Ra\u001eB$\u0005\u0013Bq!!%\u0016\u0001\u0004\t\u0019\n\u0003\u00043+\u0001\u0007\u0011\u0011\u0010\u0015\b\u0001\t=\u00111\u0001B'Y!\u0011yEa\u0015\u0003X\tm\u0013E\u0001B)\u0003]\u0011X\r]8tSR|'/_*feZL7-\u001a%pY\u0012,'/\t\u0002\u0003V\u0005Y\u0002\u000f\\1dK\"|G\u000eZ3s%\u0016\u0004xn]5u_JL\bj\u001c7eKJ\f#A!\u0017\u0002!\u0005\u0014H/\u001b4bGR\u0014Vm]8mm\u0016\u0014\u0018E\u0001B/\u0003e\u0019w.\\7b]\u0012<\u0006.\u001b;fY&\u001cHOV1mS\u0012\fGo\u001c:)\u0007\u0001\u0011\t\u0007\u0005\u0003\u0002l\t\r\u0014\u0002\u0002B3\u0003[\u0012A\u0001T1{s\"\u001a\u0001A!\u001b\u0011\t\u0005-$1N\u0005\u0005\u0005[\niGA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u0012\u000b:<\u0017N\\3CK\u0006t')^5mI\u0016\u0014\bC\u0001#\u0018'\t9R\u0005\u0006\u0002\u0003r\u0005\u00192M]3bi\u0016<vN]6fe6\u000bg.Y4feRQ\u0011\u0011\bB>\u0005{\u0012yH!'\t\u000b\u0001L\u0002\u0019\u00012\t\u000f\u0005\u0005\u0013\u00041\u0001\u0002D!9!\u0011Q\rA\u0002\t\r\u0015!E2p]\u001aLw-\u001e:bi&|g\u000eS1tQB!!Q\u0011BJ\u001d\u0011\u00119Ia$\u0011\u0007\t%u%\u0004\u0002\u0003\f*\u0019!QR\u0012\u0002\rq\u0012xn\u001c;?\u0013\r\u0011\tjJ\u0001\u0007!J,G-\u001a4\n\t\tU%q\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\tEu\u0005C\u0004\u0003\u001cf\u0001\r!!\u0004\u0002\u001dMDw.\u001e7e\u001d>$8\t[;oW\u0002")
public class EngineBeanBuilder {
    private final Archive archive;
    private final RepositoryFactory repositoryAdapter;
    private final Logger logger;
    private final ActorSystem system;
    @Value(value="#{baseWorkDir}")
    private File baseWorkDir;
    @Value(value="${deploy.task.in-process-worker:true}")
    private boolean inProcessTaskEngine;

    public static ActorRef createWorkerManager(ActorSystem actorSystem, TaskExecutionWorkerRepository taskExecutionWorkerRepository, String string, boolean bl) {
        return EngineBeanBuilder$.MODULE$.createWorkerManager(actorSystem, taskExecutionWorkerRepository, string, bl);
    }

    public Archive archive() {
        return this.archive;
    }

    public RepositoryFactory repositoryAdapter() {
        return this.repositoryAdapter;
    }

    private Logger logger() {
        return this.logger;
    }

    private final ActorSystem system() {
        return this.system;
    }

    public File baseWorkDir() {
        return this.baseWorkDir;
    }

    public void baseWorkDir_$eq(File x$1) {
        this.baseWorkDir = x$1;
    }

    public boolean inProcessTaskEngine() {
        return this.inProcessTaskEngine;
    }

    public void inProcessTaskEngine_$eq(boolean x$1) {
        this.inProcessTaskEngine = x$1;
    }

    @PostConstruct
    public void initialize() {
        block0: {
            if (this.inProcessTaskEngine()) break block0;
            ((KryoAkkaSerializer)((Serialization)SerializationExtension$.MODULE$.apply(this.system())).serializerFor(WorkDir.class)).setKryoCustomizers((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KryoCustomizer[]{kryo -> kryo.addDefaultSerializer(WorkDir.class, (Serializer)new WorkDirSerializer(kryo, this.baseWorkDir(), WorkDirSerializer$.MODULE$.$lessinit$greater$default$3()))}));
        }
    }

    @Bean
    @Autowired
    public ActorRef workerManager(TaskExecutionWorkerRepository taskExecutionWorkerRepository, ConfigurationHashProvider configurationHashProvider) {
        return EngineBeanBuilder$.MODULE$.createWorkerManager(this.system(), taskExecutionWorkerRepository, configurationHashProvider.configurationHash(), this.inProcessTaskEngine());
    }

    @Bean
    @DependsOn(value={"upgrader"})
    @Autowired
    public TaskExecutionEngine engine(ActiveTaskRepository activeTaskRepository, PendingTaskRepository pendingTaskRepository, @Qualifier(value="xlJmsListenerContainerFactory") JmsListenerContainerFactory<DefaultMessageListenerContainer> containerFactory, TaskExecutionWorkerRepository taskExecutionWorkerRepository, @Qualifier(value="workerManager") ActorRef workerManager, StepLogFactory stepLogFactory, StepLogRetriever stepLogRetriever, ConfigurationHashProvider configurationHashProvider, TaskerSettings taskerSettings, TaskQueueService taskQueueService) {
        ActorRef actorRef;
        TaskFinalizerImpl taskFinalizer = new TaskFinalizerImpl(this.system(), (CrudTaskRepository)activeTaskRepository, pendingTaskRepository, taskerSettings.askTimeout());
        TaskExecutionEngine engine = new TaskExecutionEngine(activeTaskRepository, pendingTaskRepository, taskExecutionWorkerRepository, taskQueueService, this.system(), workerManager, (TaskFinalizer)taskFinalizer);
        if (this.inProcessTaskEngine()) {
            this.logger().info("An in-process task execution worker will be registered.");
            TaskExecutionWorker$.MODULE$.local(this.repositoryAdapter(), this.archive(), configurationHashProvider, activeTaskRepository, pendingTaskRepository, taskExecutionWorkerRepository, containerFactory, taskerSettings, stepLogFactory, stepLogRetriever, this.system()).recoverTasks();
            DiscoveryWorker$.MODULE$.initialize(this.system());
            actorRef = BoxedUnit.UNIT;
        } else {
            this.logger().debug("Registering for remote change set events.");
            actorRef = this.system().actorOf(RemoteChangeSetEventListener$.MODULE$.props(), RemoteChangeSetEventListener$.MODULE$.name());
        }
        this.system().actorOf(QueryActor$.MODULE$.props(), QueryActor$.MODULE$.name());
        this.rescheduleTasks(pendingTaskRepository, engine);
        return engine;
    }

    @Bean
    @Autowired
    public DiscoveryService discoveryService(@Qualifier(value="workerManager") ActorRef workerManager) {
        return new DiscoveryService(this.system(), workerManager, this.inProcessTaskEngine());
    }

    @PreDestroy
    public void destroy() {
        Akka25$.MODULE$.terminate(this.system(), (Duration)Duration$.MODULE$.Inf());
    }

    private void rescheduleTasks(PendingTaskRepository pendingTaskRepository, TaskExecutionEngine engine) {
        pendingTaskRepository.scheduledTasks().forEach(task -> {
            Throwable ex;
            DateTime scheduledDate = task.getScheduledDate();
            String date = scheduledDate.toDateTimeISO().toString("yyyy-MM-dd'T'HH:mm:ss");
            if (scheduledDate.isBeforeNow()) {
                this.logger().info(new StringBuilder(67).append("Scheduled task [").append(task.getId()).append("] with date [").append(date).append("] has already passed so executing now.").toString());
                engine.execute(task.getId());
                return;
            }
            boolean bl = false;
            Failure failure = null;
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> engine.schedule(task.getId(), scheduledDate));
            if (try_ instanceof Failure) {
                bl = true;
                failure = (Failure)try_;
                Throwable ex2 = failure.exception();
                if (ex2 instanceof TaskerException) {
                    TaskerException taskerException = (TaskerException)ex2;
                    this.logger().warn(new StringBuilder(73).append("Scheduled task [").append(task.getId()).append("] with start date [").append(date).append("] cannot be rescheduled automatically.").toString());
                    this.logger().warn(taskerException.getMessage());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
            if (bl && (ex = failure.exception()) instanceof Exception) {
                Exception exception = (Exception)ex;
                this.logger().warn(new StringBuilder(100).append("Scheduled task [").append(task.getId()).append("] with start date [").append(date).append("] cannot be rescheduled automatically. Unexpected error occurred.").toString());
                throw exception;
            }
            if (!(try_ instanceof Success)) throw new MatchError((Object)try_);
            this.logger().info(new StringBuilder(52).append("Scheduled task [").append(task.getId()).append("] with start date [").append(date).append("] was rescheduled").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
    }

    public EngineBeanBuilder(@Autowired Archive archive, @Autowired RepositoryFactory repositoryAdapter) {
        this.archive = archive;
        this.repositoryAdapter = repositoryAdapter;
        this.logger = LoggerFactory.getLogger(EngineBeanBuilder.class);
        this.system = TaskActorSystem$.MODULE$.actorSystem();
    }
}

