/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.spring;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import com.esotericsoftware.kryo.Serializer;
import com.xebialabs.deployit.core.rest.websockets.RemoteChangeSetEventListener$;
import com.xebialabs.deployit.engine.api.distribution.TaskExecutionWorkerRepository;
import com.xebialabs.deployit.engine.spi.services.RepositoryFactory;
import com.xebialabs.deployit.engine.tasker.Archive;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.engine.tasker.TaskExecutionWorker$;
import com.xebialabs.deployit.engine.tasker.TaskFinalizer;
import com.xebialabs.deployit.engine.tasker.TaskFinalizerImpl;
import com.xebialabs.deployit.engine.tasker.TaskQueueService;
import com.xebialabs.deployit.engine.tasker.TaskerException;
import com.xebialabs.deployit.engine.tasker.distribution.versioning.ConfigurationHashProvider;
import com.xebialabs.deployit.engine.tasker.log.StepLogFactory;
import com.xebialabs.deployit.engine.tasker.log.StepLogRetriever;
import com.xebialabs.deployit.engine.tasker.repository.ActiveTaskRepository;
import com.xebialabs.deployit.engine.tasker.repository.CrudTaskRepository;
import com.xebialabs.deployit.engine.tasker.repository.PendingTaskRepository;
import com.xebialabs.deployit.engine.tasker.satellite.WorkDirSerializer;
import com.xebialabs.deployit.engine.tasker.satellite.WorkDirSerializer$;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.service.discovery.DiscoveryService;
import com.xebialabs.deployit.service.discovery.DiscoveryWorker$;
import com.xebialabs.deployit.spring.EngineBeanBuilder$;
import com.xebialabs.deployit.tasksystem.TaskActorSystem$;
import com.xebialabs.xlplatform.akka25.Akka25$;
import com.xebialabs.xlplatform.settings.shared.TaskerSettings;
import io.altoo.akka.serialization.kryo.KryoAkkaSerializer;
import io.altoo.akka.serialization.kryo.KryoCustomizer;
import java.io.File;
import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import scala.Function0;
import scala.MatchError;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Configuration
@Lazy
@DependsOn(value={"repositoryServiceHolder", "placeholderRepositoryHolder", "artifactResolver"})
@ScalaSignature(bytes="\u0006\u0005\tee\u0001\u0002\u000e\u001c\u0001\u0011B\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001\f\u0005\tk\u0001\u0011\t\u0011)A\u0005[!Aa\u0007\u0001BC\u0002\u0013\u0005q\u0007\u0003\u0005A\u0001\t\u0005\t\u0015!\u00039\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u001d9\u0006A1A\u0005\naCaa\u0018\u0001!\u0002\u0013I\u0006b\u00021\u0001\u0005\u0004%y!\u0019\u0005\u0007U\u0002\u0001\u000bQ\u00022\t\u0013-\u0004\u0001\u0019!a\u0001\n\u0003a\u0007\"C;\u0001\u0001\u0004\u0005\r\u0011\"\u0001w\u0011%a\b\u00011A\u0001B\u0003&Q\u000eC\u0006\u0002\n\u0001\u0001\r\u00111A\u0005\u0002\u0005-\u0001bCA\n\u0001\u0001\u0007\t\u0019!C\u0001\u0003+A1\"!\u0007\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u000e!9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0002bBA\u001b\u0001\u0011\u0005\u0011q\u0007\u0005\u0007e\u0001!\t!a\u001e\t\u000f\tu\u0001\u0001\"\u0001\u0003 !9!\u0011\b\u0001\u0005\u0002\u0005\r\u0002b\u0002B\"\u0001\u0011%!QI\u0004\b\u0005WZ\u0002\u0012\u0001B7\r\u0019Q2\u0004#\u0001\u0003p!1\u0011i\u0006C\u0001\u0005cBqAa\u001d\u0018\t\u0003\u0011)HA\tF]\u001eLg.\u001a\"fC:\u0014U/\u001b7eKJT!\u0001H\u000f\u0002\rM\u0004(/\u001b8h\u0015\tqr$\u0001\u0005eKBdw._5u\u0015\t\u0001\u0013%A\u0005yK\nL\u0017\r\\1cg*\t!%A\u0002d_6\u001c\u0001a\u0005\u0002\u0001KA\u0011a%K\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\t1\u0011I\\=SK\u001a\fq!\u0019:dQ&4X-F\u0001.!\tq3'D\u00010\u0015\t\u0001\u0014'\u0001\u0004uCN\\WM\u001d\u0006\u0003eu\ta!\u001a8hS:,\u0017B\u0001\u001b0\u0005\u001d\t%o\u00195jm\u0016\f\u0001\"\u0019:dQ&4X\rI\u0001\u0012e\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014X#\u0001\u001d\u0011\u0005erT\"\u0001\u001e\u000b\u0005mb\u0014\u0001C:feZL7-Z:\u000b\u0005u\n\u0014aA:qS&\u0011qH\u000f\u0002\u0012%\u0016\u0004xn]5u_JLh)Y2u_JL\u0018A\u0005:fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;fe\u0002\na\u0001P5oSRtDcA\"F+B\u0011A\tA\u0007\u00027!)1&\u0002a\u0001[!\u0012Qi\u0012\t\u0003\u0011Nk\u0011!\u0013\u0006\u0003\u0015.\u000b!\"\u00198o_R\fG/[8o\u0015\taU*A\u0004gC\u000e$xN]=\u000b\u00059{\u0015!\u00022fC:\u001c(B\u0001)R\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001*\u0002\u0007=\u0014x-\u0003\u0002U\u0013\nI\u0011)\u001e;po&\u0014X\r\u001a\u0005\u0006m\u0015\u0001\r\u0001\u000f\u0015\u0003+\u001e\u000ba\u0001\\8hO\u0016\u0014X#A-\u0011\u0005ikV\"A.\u000b\u0005q\u000b\u0016!B:mMRR\u0017B\u00010\\\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013AB:zgR,W.F\u0001c!\t\u0019\u0007.D\u0001e\u0015\t)g-A\u0003bGR|'OC\u0001h\u0003\u0011\t7n[1\n\u0005%$'aC!di>\u00148+_:uK6\fqa]=ti\u0016l\u0007%A\u0006cCN,wk\u001c:l\t&\u0014X#A7\u0011\u00059\u001cX\"A8\u000b\u0005A\f\u0018AA5p\u0015\u0005\u0011\u0018\u0001\u00026bm\u0006L!\u0001^8\u0003\t\u0019KG.Z\u0001\u0010E\u0006\u001cXmV8sW\u0012K'o\u0018\u0013fcR\u0011qO\u001f\t\u0003MaL!!_\u0014\u0003\tUs\u0017\u000e\u001e\u0005\bw.\t\t\u00111\u0001n\u0003\rAH%M\u0001\rE\u0006\u001cXmV8sW\u0012K'\u000f\t\u0015\u0007\u0019y\f\u0019!!\u0002\u0011\u0005!{\u0018bAA\u0001\u0013\n)a+\u00197vK\u0006)a/\u00197vK\u0006\u0012\u0011qA\u0001\u000fGm\u0014\u0017m]3X_J\\G)\u001b:~\u0003MIg\u000e\u0015:pG\u0016\u001c8\u000fV1tW\u0016sw-\u001b8f+\t\ti\u0001E\u0002'\u0003\u001fI1!!\u0005(\u0005\u001d\u0011un\u001c7fC:\fq#\u001b8Qe>\u001cWm]:UCN\\WI\\4j]\u0016|F%Z9\u0015\u0007]\f9\u0002\u0003\u0005|\u001d\u0005\u0005\t\u0019AA\u0007\u0003QIg\u000e\u0015:pG\u0016\u001c8\u000fV1tW\u0016sw-\u001b8fA!2qB`A\u0002\u0003;\t#!a\b\u0002C\u0011Z\b\u0010\u001c\u0018uCN\\g&\u001b8.aJ|7-Z:t[]|'o[3suQ\u0014X/Z?\u0002\u0015%t\u0017\u000e^5bY&TX\rF\u0001xQ\r\u0001\u0012q\u0005\t\u0005\u0003S\t\t$\u0004\u0002\u0002,)\u0019!*!\f\u000b\u0005\u0005=\u0012!\u00026bm\u0006D\u0018\u0002BA\u001a\u0003W\u0011Q\u0002U8ti\u000e{gn\u001d;sk\u000e$\u0018!D<pe.,'/T1oC\u001e,'\u000f\u0006\u0004\u0002:\u0005}\u00121\u000b\t\u0004G\u0006m\u0012bAA\u001fI\nA\u0011i\u0019;peJ+g\rC\u0004\u0002BE\u0001\r!a\u0011\u0002;Q\f7o[#yK\u000e,H/[8o/>\u00148.\u001a:SKB|7/\u001b;pef\u0004B!!\u0012\u0002P5\u0011\u0011q\t\u0006\u0005\u0003\u0013\nY%\u0001\u0007eSN$(/\u001b2vi&|gNC\u0002\u0002NE\n1!\u00199j\u0013\u0011\t\t&a\u0012\u0003;Q\u000b7o[#yK\u000e,H/[8o/>\u00148.\u001a:SKB|7/\u001b;pefDq!!\u0016\u0012\u0001\u0004\t9&A\rd_:4\u0017nZ;sCRLwN\u001c%bg\"\u0004&o\u001c<jI\u0016\u0014\b\u0003BA-\u0003Cj!!a\u0017\u000b\t\u0005u\u0013qL\u0001\u000bm\u0016\u00148/[8oS:<'bAA%_%!\u00111MA.\u0005e\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"\u000b7\u000f\u001b)s_ZLG-\u001a:)\u0005E9\u0005fA\t\u0002jA!\u00111NA:\u001b\t\tiGC\u0002K\u0003_R1!!\u001dP\u0003\u001d\u0019wN\u001c;fqRLA!!\u001e\u0002n\t!!)Z1o)Y\tI(a \u0002\u0010\u0006e\u0015QYAd\u0003\u001b\fi.a:\u0002j\n\u0005\u0001c\u0001\u0018\u0002|%\u0019\u0011QP\u0018\u0003'Q\u000b7o[#yK\u000e,H/[8o\u000b:<\u0017N\\3\t\u000f\u0005\u0005%\u00031\u0001\u0002\u0004\u0006!\u0012m\u0019;jm\u0016$\u0016m]6SKB|7/\u001b;pef\u0004B!!\"\u0002\f6\u0011\u0011q\u0011\u0006\u0004\u0003\u0013{\u0013A\u0003:fa>\u001c\u0018\u000e^8ss&!\u0011QRAD\u0005Q\t5\r^5wKR\u000b7o\u001b*fa>\u001c\u0018\u000e^8ss\"9\u0011\u0011\u0013\nA\u0002\u0005M\u0015!\u00069f]\u0012Lgn\u001a+bg.\u0014V\r]8tSR|'/\u001f\t\u0005\u0003\u000b\u000b)*\u0003\u0003\u0002\u0018\u0006\u001d%!\u0006)f]\u0012Lgn\u001a+bg.\u0014V\r]8tSR|'/\u001f\u0005\b\u00037\u0013\u0002\u0019AAO\u0003A\u0019wN\u001c;bS:,'OR1di>\u0014\u0018\u0010\u0005\u0004\u0002 \u0006%\u0016QV\u0007\u0003\u0003CSA!a)\u0002&\u000611m\u001c8gS\u001eT1!a*P\u0003\rQWn]\u0005\u0005\u0003W\u000b\tKA\u000eK[Nd\u0015n\u001d;f]\u0016\u00148i\u001c8uC&tWM\u001d$bGR|'/\u001f\t\u0005\u0003_\u000b),\u0004\u0002\u00022*!\u00111WAS\u0003!a\u0017n\u001d;f]\u0016\u0014\u0018\u0002BA\\\u0003c\u0013q\u0004R3gCVdG/T3tg\u0006<W\rT5ti\u0016tWM]\"p]R\f\u0017N\\3sQ!\tI*a/\u0002\u0004\u0005\u0005\u0007c\u0001%\u0002>&\u0019\u0011qX%\u0003\u0013E+\u0018\r\\5gS\u0016\u0014\u0018EAAb\u0003uAHNS7t\u0019&\u001cH/\u001a8fe\u000e{g\u000e^1j]\u0016\u0014h)Y2u_JL\bbBA!%\u0001\u0007\u00111\t\u0005\b\u0003k\u0011\u0002\u0019AA\u001dQ!\t9-a/\u0002\u0004\u0005-\u0017EAA\u001b\u0011\u001d\tyM\u0005a\u0001\u0003#\fab\u001d;fa2{wMR1di>\u0014\u0018\u0010\u0005\u0003\u0002T\u0006eWBAAk\u0015\r\t9nL\u0001\u0004Y><\u0017\u0002BAn\u0003+\u0014ab\u0015;fa2{wMR1di>\u0014\u0018\u0010C\u0004\u0002`J\u0001\r!!9\u0002!M$X\r\u001d'pOJ+GO]5fm\u0016\u0014\b\u0003BAj\u0003GLA!!:\u0002V\n\u00012\u000b^3q\u0019><'+\u001a;sS\u00164XM\u001d\u0005\b\u0003+\u0012\u0002\u0019AA,\u0011\u001d\tYO\u0005a\u0001\u0003[\fa\u0002^1tW\u0016\u00148+\u001a;uS:<7\u000f\u0005\u0003\u0002p\u0006uXBAAy\u0015\u0011\t\u00190!>\u0002\rMD\u0017M]3e\u0015\u0011\t90!?\u0002\u0011M,G\u000f^5oONT1!a? \u0003)AH\u000e\u001d7bi\u001a|'/\\\u0005\u0005\u0003\u007f\f\tP\u0001\bUCN\\WM]*fiRLgnZ:\t\u000f\t\r!\u00031\u0001\u0003\u0006\u0005\u0001B/Y:l#V,W/Z*feZL7-\u001a\t\u0004]\t\u001d\u0011b\u0001B\u0005_\t\u0001B+Y:l#V,W/Z*feZL7-\u001a\u0015\u0003%\u001dCsA\u0005B\b\u0003\u0007\u0011)\u0002\u0005\u0003\u0002l\tE\u0011\u0002\u0002B\n\u0003[\u0012\u0011\u0002R3qK:$7o\u00148-\u0005\t]\u0011E\u0001B\r\u0003!)\bo\u001a:bI\u0016\u0014\bf\u0001\n\u0002j\u0005\u0001B-[:d_Z,'/_*feZL7-\u001a\u000b\u0005\u0005C\u0011\t\u0004\u0005\u0003\u0003$\t5RB\u0001B\u0013\u0015\u0011\u00119C!\u000b\u0002\u0013\u0011L7oY8wKJL(b\u0001B\u0016;\u000591/\u001a:wS\u000e,\u0017\u0002\u0002B\u0018\u0005K\u0011\u0001\u0003R5tG>4XM]=TKJ4\u0018nY3\t\u000f\u0005U2\u00031\u0001\u0002:!B!\u0011GA^\u0003\u0007\tY\r\u000b\u0002\u0014\u000f\"\u001a1#!\u001b\u0002\u000f\u0011,7\u000f\u001e:ps\"\u001aAC!\u0010\u0011\t\u0005%\"qH\u0005\u0005\u0005\u0003\nYC\u0001\u0006Qe\u0016$Um\u001d;s_f\fqB]3tG\",G-\u001e7f)\u0006\u001c8n\u001d\u000b\u0006o\n\u001d#\u0011\n\u0005\b\u0003#+\u0002\u0019AAJ\u0011\u0019\u0011T\u00031\u0001\u0002z!:\u0001Aa\u0004\u0002\u0004\t5CF\u0002B(\u0005'\u00129&\t\u0002\u0003R\u00059\"/\u001a9pg&$xN]=TKJ4\u0018nY3I_2$WM]\u0011\u0003\u0005+\n1\u0004\u001d7bG\u0016Dw\u000e\u001c3feJ+\u0007o\\:ji>\u0014\u0018\u0010S8mI\u0016\u0014\u0018E\u0001B-\u0003A\t'\u000f^5gC\u000e$(+Z:pYZ,'\u000fK\u0002\u0001\u0005;\u0002B!a\u001b\u0003`%!!\u0011MA7\u0005\u0011a\u0015M_=)\u0007\u0001\u0011)\u0007\u0005\u0003\u0002l\t\u001d\u0014\u0002\u0002B5\u0003[\u0012QbQ8oM&<WO]1uS>t\u0017!E#oO&tWMQ3b]\n+\u0018\u000e\u001c3feB\u0011AiF\n\u0003/\u0015\"\"A!\u001c\u0002'\r\u0014X-\u0019;f/>\u00148.\u001a:NC:\fw-\u001a:\u0015\u0015\u0005e\"q\u000fB=\u0005w\u0012)\nC\u0003a3\u0001\u0007!\rC\u0004\u0002Be\u0001\r!a\u0011\t\u000f\tu\u0014\u00041\u0001\u0003\u0000\u0005\t2m\u001c8gS\u001e,(/\u0019;j_:D\u0015m\u001d5\u0011\t\t\u0005%q\u0012\b\u0005\u0005\u0007\u0013Y\tE\u0002\u0003\u0006\u001ej!Aa\"\u000b\u0007\t%5%\u0001\u0004=e>|GOP\u0005\u0004\u0005\u001b;\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0003\u0012\nM%AB*ue&twMC\u0002\u0003\u000e\u001eBqAa&\u001a\u0001\u0004\ti!\u0001\btQ>,H\u000e\u001a(pi\u000eCWO\\6")
public class EngineBeanBuilder {
    private final Archive archive;
    private final RepositoryFactory repositoryAdapter;
    private final Logger logger;
    private final ActorSystem system;
    @Value(value="#{baseWorkDir}")
    private File baseWorkDir;
    @Value(value="${xl.task.in-process-worker:true}")
    private boolean inProcessTaskEngine;

    public static ActorRef createWorkerManager(ActorSystem actorSystem, TaskExecutionWorkerRepository taskExecutionWorkerRepository, String string, boolean bl) {
        return EngineBeanBuilder$.MODULE$.createWorkerManager(actorSystem, taskExecutionWorkerRepository, string, bl);
    }

    public Archive archive() {
        return this.archive;
    }

    public RepositoryFactory repositoryAdapter() {
        return this.repositoryAdapter;
    }

    private Logger logger() {
        return this.logger;
    }

    private final ActorSystem system() {
        return this.system;
    }

    public File baseWorkDir() {
        return this.baseWorkDir;
    }

    public void baseWorkDir_$eq(File x$1) {
        this.baseWorkDir = x$1;
    }

    public boolean inProcessTaskEngine() {
        return this.inProcessTaskEngine;
    }

    public void inProcessTaskEngine_$eq(boolean x$1) {
        this.inProcessTaskEngine = x$1;
    }

    @PostConstruct
    public void initialize() {
        block0: {
            if (this.inProcessTaskEngine()) break block0;
            ((KryoAkkaSerializer)((Serialization)SerializationExtension$.MODULE$.apply(this.system())).serializerFor(WorkDir.class)).setKryoCustomizers((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KryoCustomizer[]{kryo -> kryo.addDefaultSerializer(WorkDir.class, (Serializer)new WorkDirSerializer(kryo, this.baseWorkDir(), WorkDirSerializer$.MODULE$.$lessinit$greater$default$3()))}));
        }
    }

    @Bean
    @Autowired
    public ActorRef workerManager(TaskExecutionWorkerRepository taskExecutionWorkerRepository, ConfigurationHashProvider configurationHashProvider) {
        return EngineBeanBuilder$.MODULE$.createWorkerManager(this.system(), taskExecutionWorkerRepository, configurationHashProvider.configurationHash(), this.inProcessTaskEngine());
    }

    @Bean
    @DependsOn(value={"upgrader"})
    @Autowired
    public TaskExecutionEngine engine(ActiveTaskRepository activeTaskRepository, PendingTaskRepository pendingTaskRepository, @Qualifier(value="xlJmsListenerContainerFactory") JmsListenerContainerFactory<DefaultMessageListenerContainer> containerFactory, TaskExecutionWorkerRepository taskExecutionWorkerRepository, @Qualifier(value="workerManager") ActorRef workerManager, StepLogFactory stepLogFactory, StepLogRetriever stepLogRetriever, ConfigurationHashProvider configurationHashProvider, TaskerSettings taskerSettings, TaskQueueService taskQueueService) {
        ActorRef actorRef;
        TaskFinalizerImpl taskFinalizer = new TaskFinalizerImpl(this.system(), (CrudTaskRepository)activeTaskRepository, pendingTaskRepository, taskerSettings.askTimeout());
        TaskExecutionEngine engine = new TaskExecutionEngine(activeTaskRepository, pendingTaskRepository, taskExecutionWorkerRepository, taskQueueService, this.system(), workerManager, (TaskFinalizer)taskFinalizer);
        if (this.inProcessTaskEngine()) {
            this.logger().info("An in-process task execution worker will be registered.");
            TaskExecutionWorker$.MODULE$.local(this.repositoryAdapter(), this.archive(), configurationHashProvider, activeTaskRepository, pendingTaskRepository, taskExecutionWorkerRepository, containerFactory, taskerSettings, stepLogFactory, stepLogRetriever, this.system()).recoverTasks();
            DiscoveryWorker$.MODULE$.initialize(this.system());
            actorRef = BoxedUnit.UNIT;
        } else {
            this.logger().debug("Registering for remote change set events.");
            actorRef = this.system().actorOf(RemoteChangeSetEventListener$.MODULE$.props(), RemoteChangeSetEventListener$.MODULE$.name());
        }
        this.rescheduleTasks(pendingTaskRepository, engine);
        return engine;
    }

    @Bean
    @Autowired
    public DiscoveryService discoveryService(@Qualifier(value="workerManager") ActorRef workerManager) {
        return new DiscoveryService(this.system(), workerManager, this.inProcessTaskEngine());
    }

    @PreDestroy
    public void destroy() {
        Akka25$.MODULE$.terminate(this.system(), (Duration)Duration$.MODULE$.Inf());
    }

    private void rescheduleTasks(PendingTaskRepository pendingTaskRepository, TaskExecutionEngine engine) {
        pendingTaskRepository.scheduledTasks().forEach(task -> {
            Throwable ex;
            DateTime scheduledDate = task.getScheduledDate();
            String date = scheduledDate.toDateTimeISO().toString("yyyy-MM-dd'T'HH:mm:ss");
            if (scheduledDate.isBeforeNow()) {
                this.logger().info(new StringBuilder(67).append("Scheduled task [").append(task.getId()).append("] with date [").append(date).append("] has already passed so executing now.").toString());
                engine.execute(task.getId());
                return;
            }
            boolean bl = false;
            Failure failure = null;
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> engine.schedule(task.getId(), scheduledDate));
            if (try_ instanceof Failure) {
                bl = true;
                failure = (Failure)try_;
                Throwable ex2 = failure.exception();
                if (ex2 instanceof TaskerException) {
                    TaskerException taskerException = (TaskerException)ex2;
                    this.logger().warn(new StringBuilder(73).append("Scheduled task [").append(task.getId()).append("] with start date [").append(date).append("] cannot be rescheduled automatically.").toString());
                    this.logger().warn(taskerException.getMessage());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
            if (bl && (ex = failure.exception()) instanceof Exception) {
                Exception exception = (Exception)ex;
                this.logger().warn(new StringBuilder(100).append("Scheduled task [").append(task.getId()).append("] with start date [").append(date).append("] cannot be rescheduled automatically. Unexpected error occurred.").toString());
                throw exception;
            }
            if (!(try_ instanceof Success)) throw new MatchError((Object)try_);
            this.logger().info(new StringBuilder(52).append("Scheduled task [").append(task.getId()).append("] with start date [").append(date).append("] was rescheduled").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
    }

    public EngineBeanBuilder(@Autowired Archive archive, @Autowired RepositoryFactory repositoryAdapter) {
        this.archive = archive;
        this.repositoryAdapter = repositoryAdapter;
        this.logger = LoggerFactory.getLogger(EngineBeanBuilder.class);
        this.system = TaskActorSystem$.MODULE$.actorSystem();
    }
}

