/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.discovery;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.service.discovery.DiscoveryResult;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DiscoveryResults {
    private static final HashMap<String, DiscoveryResult> results = Maps.newHashMap();
    private static final Logger logger = LoggerFactory.getLogger(DiscoveryResults.class);

    private DiscoveryResults() {
    }

    static void register(TaskState task, List<ConfigurationItem> result) {
        results.put(task.getId(), new DiscoveryResult(task.getId(), task.getOwner(), result));
    }

    static DiscoveryResult retrieve(String taskId) {
        logger.info("Cleaning discovery results for [{}]", (Object)taskId);
        return results.remove(taskId);
    }
}

