/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.spring;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import com.esotericsoftware.kryo.Serializer;
import com.xebialabs.deployit.core.config.XldConfig;
import com.xebialabs.deployit.core.rest.websockets.RemoteChangeSetEventListener$;
import com.xebialabs.deployit.engine.api.distribution.TaskExecutionWorkerRepository;
import com.xebialabs.deployit.engine.spi.services.RepositoryFactory;
import com.xebialabs.deployit.engine.tasker.Archive;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.engine.tasker.TaskExecutionWorker$;
import com.xebialabs.deployit.engine.tasker.TaskFinalizer;
import com.xebialabs.deployit.engine.tasker.TaskFinalizerImpl;
import com.xebialabs.deployit.engine.tasker.TaskQueueService;
import com.xebialabs.deployit.engine.tasker.TaskerException;
import com.xebialabs.deployit.engine.tasker.distribution.versioning.ConfigurationHashProvider;
import com.xebialabs.deployit.engine.tasker.log.StepLogFactory;
import com.xebialabs.deployit.engine.tasker.log.StepLogRetriever;
import com.xebialabs.deployit.engine.tasker.repository.ActiveTaskRepository;
import com.xebialabs.deployit.engine.tasker.repository.CrudTaskRepository;
import com.xebialabs.deployit.engine.tasker.repository.PendingTaskRepository;
import com.xebialabs.deployit.engine.tasker.satellite.KryoAkkaSerializer;
import com.xebialabs.deployit.engine.tasker.satellite.KryoCustomizer;
import com.xebialabs.deployit.engine.tasker.satellite.WorkDirSerializer;
import com.xebialabs.deployit.engine.tasker.satellite.WorkDirSerializer$;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.service.discovery.DiscoveryService;
import com.xebialabs.deployit.service.discovery.DiscoveryWorker$;
import com.xebialabs.deployit.spring.EngineBeanBuilder$;
import com.xebialabs.deployit.tasksystem.TaskActorSystem$;
import com.xebialabs.xlplatform.akka25.Akka25$;
import com.xebialabs.xlplatform.settings.CommonSettings;
import com.xebialabs.xlplatform.settings.TaskerSettings;
import java.io.File;
import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Configuration
@Lazy
@DependsOn(value={"repositoryServiceHolder", "placeholderRepositoryHolder", "artifactResolver"})
@ScalaSignature(bytes="\u0006\u0001\t\u001de\u0001B\r\u001b\u0001\rB\u0001B\u000b\u0001\u0003\u0006\u0004%\ta\u000b\u0005\ti\u0001\u0011\t\u0011)A\u0005Y!AQ\u0007\u0001BC\u0002\u0013\u0005a\u0007\u0003\u0005@\u0001\t\u0005\t\u0015!\u00038\u0011!\u0001\u0005A!b\u0001\n\u0003\t\u0005\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u000b-\u0003A\u0011\u0001'\t\u000f\r\u0004!\u0019!C\u0005I\"11\u000e\u0001Q\u0001\n\u0015Dq\u0001\u001c\u0001C\u0002\u0013=Q\u000e\u0003\u0004w\u0001\u0001\u0006iA\u001c\u0005\no\u0002\u0001\r\u00111A\u0005\u0002aD1\"a\u0001\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0006!Q\u0011\u0011\u0003\u0001A\u0002\u0003\u0005\u000b\u0015B=\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$!9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0002B\u0002\u001f\u0001\t\u0003\t9\bC\u0004\u0003\u0006\u0001!\tAa\u0002\t\u000f\t\u0005\u0002\u0001\"\u0001\u0002$!9!1\u0006\u0001\u0005\n\t5ra\u0002B*5!\u0005!Q\u000b\u0004\u00073iA\tAa\u0016\t\r-3B\u0011\u0001B-\u0011\u001d\u0011YF\u0006C\u0001\u0005;\u0012\u0011#\u00128hS:,')Z1o\u0005VLG\u000eZ3s\u0015\tYB$\u0001\u0004taJLgn\u001a\u0006\u0003;y\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003?\u0001\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\u0005\n1aY8n\u0007\u0001\u0019\"\u0001\u0001\u0013\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\r\u0005s\u0017PU3g\u0003%AH\u000eZ\"p]\u001aLw-F\u0001-!\ti#'D\u0001/\u0015\ty\u0003'\u0001\u0004d_:4\u0017n\u001a\u0006\u0003cq\tAaY8sK&\u00111G\f\u0002\n12$7i\u001c8gS\u001e\f!\u0002\u001f7e\u0007>tg-[4!\u0003\u001d\t'o\u00195jm\u0016,\u0012a\u000e\t\u0003quj\u0011!\u000f\u0006\u0003um\na\u0001^1tW\u0016\u0014(B\u0001\u001f\u001d\u0003\u0019)gnZ5oK&\u0011a(\u000f\u0002\b\u0003J\u001c\u0007.\u001b<f\u0003!\t'o\u00195jm\u0016\u0004\u0013!\u0005:fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;feV\t!\t\u0005\u0002D\u00116\tAI\u0003\u0002F\r\u0006A1/\u001a:wS\u000e,7O\u0003\u0002Hw\u0005\u00191\u000f]5\n\u0005%#%!\u0005*fa>\u001c\u0018\u000e^8ss\u001a\u000b7\r^8ss\u0006\u0011\"/\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:!\u0003\u0019a\u0014N\\5u}Q!QjT0b!\tq\u0005!D\u0001\u001b\u0011\u0015Qs\u00011\u0001-Q\ty\u0015\u000b\u0005\u0002S;6\t1K\u0003\u0002U+\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005Y;\u0016a\u00024bGR|'/\u001f\u0006\u00031f\u000bQAY3b]NT!AW.\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011\u0001X\u0001\u0004_J<\u0017B\u00010T\u0005%\tU\u000f^8xSJ,G\rC\u00036\u000f\u0001\u0007q\u0007\u000b\u0002`#\")\u0001i\u0002a\u0001\u0005\"\u0012\u0011-U\u0001\u0007Y><w-\u001a:\u0016\u0003\u0015\u0004\"AZ5\u000e\u0003\u001dT!\u0001[.\u0002\u000bMdg\r\u000e6\n\u0005)<'A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\rML8\u000f^3n+\u0005q\u0007CA8u\u001b\u0005\u0001(BA9s\u0003\u0015\t7\r^8s\u0015\u0005\u0019\u0018\u0001B1lW\u0006L!!\u001e9\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\\\u0001\bgf\u001cH/Z7!\u0003-\u0011\u0017m]3X_J\\G)\u001b:\u0016\u0003e\u0004\"A_@\u000e\u0003mT!\u0001`?\u0002\u0005%|'\"\u0001@\u0002\t)\fg/Y\u0005\u0004\u0003\u0003Y(\u0001\u0002$jY\u0016\fqBY1tK^{'o\u001b#je~#S-\u001d\u000b\u0005\u0003\u000f\ti\u0001E\u0002&\u0003\u0013I1!a\u0003'\u0005\u0011)f.\u001b;\t\u0011\u0005=Q\"!AA\u0002e\f1\u0001\u001f\u00132\u00031\u0011\u0017m]3X_J\\G)\u001b:!Q\u001dq\u0011QCA\u000e\u0003;\u00012AUA\f\u0013\r\tIb\u0015\u0002\u0006-\u0006dW/Z\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003?\tabI>cCN,wk\u001c:l\t&\u0014X0\u0001\u0006j]&$\u0018.\u00197ju\u0016$\"!a\u0002)\u0007=\t9\u0003\u0005\u0003\u0002*\u0005ERBAA\u0016\u0015\r!\u0016Q\u0006\u0006\u0003\u0003_\tQA[1wCbLA!a\r\u0002,\ti\u0001k\\:u\u0007>t7\u000f\u001e:vGR\fQb^8sW\u0016\u0014X*\u00198bO\u0016\u0014HCBA\u001d\u0003\u007f\t\u0019\u0006E\u0002p\u0003wI1!!\u0010q\u0005!\t5\r^8s%\u00164\u0007bBA!!\u0001\u0007\u00111I\u0001\u001ei\u0006\u001c8.\u0012=fGV$\u0018n\u001c8X_J\\WM\u001d*fa>\u001c\u0018\u000e^8ssB!\u0011QIA(\u001b\t\t9E\u0003\u0003\u0002J\u0005-\u0013\u0001\u00043jgR\u0014\u0018NY;uS>t'bAA'w\u0005\u0019\u0011\r]5\n\t\u0005E\u0013q\t\u0002\u001e)\u0006\u001c8.\u0012=fGV$\u0018n\u001c8X_J\\WM\u001d*fa>\u001c\u0018\u000e^8ss\"9\u0011Q\u000b\tA\u0002\u0005]\u0013!G2p]\u001aLw-\u001e:bi&|g\u000eS1tQB\u0013xN^5eKJ\u0004B!!\u0017\u0002b5\u0011\u00111\f\u0006\u0005\u0003;\ny&\u0001\u0006wKJ\u001c\u0018n\u001c8j]\u001eT1!!\u0013:\u0013\u0011\t\u0019'a\u0017\u00033\r{gNZ5hkJ\fG/[8o\u0011\u0006\u001c\b\u000e\u0015:pm&$WM\u001d\u0015\u0003!EC3\u0001EA5!\u0011\tY'a\u001d\u000e\u0005\u00055$b\u0001+\u0002p)\u0019\u0011\u0011O-\u0002\u000f\r|g\u000e^3yi&!\u0011QOA7\u0005\u0011\u0011U-\u00198\u0015-\u0005e\u0014qPAH\u00033\u000b\u0019-!2\u0002L\u0006m\u0017Q]At\u0003S\u00042\u0001OA>\u0013\r\ti(\u000f\u0002\u0014)\u0006\u001c8.\u0012=fGV$\u0018n\u001c8F]\u001eLg.\u001a\u0005\b\u0003\u0003\u000b\u0002\u0019AAB\u0003Q\t7\r^5wKR\u000b7o\u001b*fa>\u001c\u0018\u000e^8ssB!\u0011QQAF\u001b\t\t9IC\u0002\u0002\nf\n!B]3q_NLGo\u001c:z\u0013\u0011\ti)a\"\u0003)\u0005\u001bG/\u001b<f)\u0006\u001c8NU3q_NLGo\u001c:z\u0011\u001d\t\t*\u0005a\u0001\u0003'\u000bQ\u0003]3oI&tw\rV1tWJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0003\u0002\u0006\u0006U\u0015\u0002BAL\u0003\u000f\u0013Q\u0003U3oI&tw\rV1tWJ+\u0007o\\:ji>\u0014\u0018\u0010C\u0004\u0002\u001cF\u0001\r!!(\u0002!\r|g\u000e^1j]\u0016\u0014h)Y2u_JL\bCBAP\u0003O\u000bY+\u0004\u0002\u0002\"*\u0019q&a)\u000b\u0007\u0005\u0015\u0016,A\u0002k[NLA!!+\u0002\"\nY\"*\\:MSN$XM\\3s\u0007>tG/Y5oKJ4\u0015m\u0019;pef\u0004B!!,\u000246\u0011\u0011q\u0016\u0006\u0005\u0003c\u000b\u0019+\u0001\u0005mSN$XM\\3s\u0013\u0011\t),a,\u0003?\u0011+g-Y;mi6+7o]1hK2K7\u000f^3oKJ\u001cuN\u001c;bS:,'\u000f\u000b\u0005\u0002\u001a\u0006e\u00161DA`!\r\u0011\u00161X\u0005\u0004\u0003{\u001b&!C)vC2Lg-[3sC\t\t\t-A\u000fyY*k7\u000fT5ti\u0016tWM]\"p]R\f\u0017N\\3s\r\u0006\u001cGo\u001c:z\u0011\u001d\t\t%\u0005a\u0001\u0003\u0007Bq!!\u000e\u0012\u0001\u0004\tI\u0004\u000b\u0005\u0002F\u0006e\u00161DAeC\t\t)\u0004C\u0004\u0002NF\u0001\r!a4\u0002\u001dM$X\r\u001d'pO\u001a\u000b7\r^8ssB!\u0011\u0011[Al\u001b\t\t\u0019NC\u0002\u0002Vf\n1\u0001\\8h\u0013\u0011\tI.a5\u0003\u001dM#X\r\u001d'pO\u001a\u000b7\r^8ss\"9\u0011Q\\\tA\u0002\u0005}\u0017\u0001E:uKBdun\u001a*fiJLWM^3s!\u0011\t\t.!9\n\t\u0005\r\u00181\u001b\u0002\u0011'R,\u0007\u000fT8h%\u0016$(/[3wKJDq!!\u0016\u0012\u0001\u0004\t9\u0006C\u0003+#\u0001\u0007A\u0006C\u0004\u0002lF\u0001\r!!<\u0002!Q\f7o[)vKV,7+\u001a:wS\u000e,\u0007c\u0001\u001d\u0002p&\u0019\u0011\u0011_\u001d\u0003!Q\u000b7o[)vKV,7+\u001a:wS\u000e,\u0007FA\tRQ\u001d\t\u0012q_A\u000e\u0003{\u0004B!a\u001b\u0002z&!\u00111`A7\u0005%!U\r]3oIN|e\u000e\f\u0002\u0002\u0000\u0006\u0012!\u0011A\u0001\tkB<'/\u00193fe\"\u001a\u0011#!\u001b\u0002!\u0011L7oY8wKJL8+\u001a:wS\u000e,G\u0003\u0002B\u0005\u00053\u0001BAa\u0003\u0003\u00165\u0011!Q\u0002\u0006\u0005\u0005\u001f\u0011\t\"A\u0005eSN\u001cwN^3ss*\u0019!1\u0003\u000f\u0002\u000fM,'O^5dK&!!q\u0003B\u0007\u0005A!\u0015n]2pm\u0016\u0014\u0018pU3sm&\u001cW\rC\u0004\u00026I\u0001\r!!\u000f)\u0011\te\u0011\u0011XA\u000e\u0003\u0013D#AE))\u0007I\tI'A\u0004eKN$(o\\=)\u0007M\u0011)\u0003\u0005\u0003\u0002*\t\u001d\u0012\u0002\u0002B\u0015\u0003W\u0011!\u0002\u0015:f\t\u0016\u001cHO]8z\u0003=\u0011Xm]2iK\u0012,H.\u001a+bg.\u001cHCBA\u0004\u0005_\u0011\t\u0004C\u0004\u0002\u0012R\u0001\r!a%\t\rq\"\u0002\u0019AA=Q\u001d\u0001\u0011q_A\u000e\u0005kacAa\u000e\u0003<\t}\u0012E\u0001B\u001d\u0003]\u0011X\r]8tSR|'/_*feZL7-\u001a%pY\u0012,'/\t\u0002\u0003>\u0005Y\u0002\u000f\\1dK\"|G\u000eZ3s%\u0016\u0004xn]5u_JL\bj\u001c7eKJ\f#A!\u0011\u0002!\u0005\u0014H/\u001b4bGR\u0014Vm]8mm\u0016\u0014\bf\u0001\u0001\u0003FA!\u00111\u000eB$\u0013\u0011\u0011I%!\u001c\u0003\t1\u000b'0\u001f\u0015\u0004\u0001\t5\u0003\u0003BA6\u0005\u001fJAA!\u0015\u0002n\ti1i\u001c8gS\u001e,(/\u0019;j_:\f\u0011#\u00128hS:,')Z1o\u0005VLG\u000eZ3s!\tqec\u0005\u0002\u0017IQ\u0011!QK\u0001\u0014GJ,\u0017\r^3X_J\\WM]'b]\u0006<WM\u001d\u000b\u000b\u0003s\u0011yF!\u0019\u0003d\tu\u0004\"\u00027\u0019\u0001\u0004q\u0007bBA!1\u0001\u0007\u00111\t\u0005\b\u0005KB\u0002\u0019\u0001B4\u0003E\u0019wN\u001c4jOV\u0014\u0018\r^5p]\"\u000b7\u000f\u001b\t\u0005\u0005S\u00129H\u0004\u0003\u0003l\tM\u0004c\u0001B7M5\u0011!q\u000e\u0006\u0004\u0005c\u0012\u0013A\u0002\u001fs_>$h(C\u0002\u0003v\u0019\na\u0001\u0015:fI\u00164\u0017\u0002\u0002B=\u0005w\u0012aa\u0015;sS:<'b\u0001B;M!9!q\u0010\rA\u0002\t\u0005\u0015AD:i_VdGMT8u\u0007\",hn\u001b\t\u0004K\t\r\u0015b\u0001BCM\t9!i\\8mK\u0006t\u0007")
public class EngineBeanBuilder {
    private final XldConfig xldConfig;
    private final Archive archive;
    private final RepositoryFactory repositoryAdapter;
    private final Logger logger;
    private final ActorSystem system;
    @Value(value="#{baseWorkDir}")
    private File baseWorkDir;

    public static ActorRef createWorkerManager(ActorSystem actorSystem, TaskExecutionWorkerRepository taskExecutionWorkerRepository, String string, boolean bl) {
        return EngineBeanBuilder$.MODULE$.createWorkerManager(actorSystem, taskExecutionWorkerRepository, string, bl);
    }

    public XldConfig xldConfig() {
        return this.xldConfig;
    }

    public Archive archive() {
        return this.archive;
    }

    public RepositoryFactory repositoryAdapter() {
        return this.repositoryAdapter;
    }

    private Logger logger() {
        return this.logger;
    }

    private final ActorSystem system() {
        return this.system;
    }

    public File baseWorkDir() {
        return this.baseWorkDir;
    }

    public void baseWorkDir_$eq(File x$1) {
        this.baseWorkDir = x$1;
    }

    @PostConstruct
    public void initialize() {
        block0: {
            if (this.xldConfig().inProcessTaskEngine()) break block0;
            ((KryoAkkaSerializer)((Serialization)SerializationExtension$.MODULE$.apply(this.system())).serializerFor(WorkDir.class)).setKryoCustomizers((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KryoCustomizer[]{kryo -> kryo.addDefaultSerializer(WorkDir.class, (Serializer)new WorkDirSerializer(kryo, this.baseWorkDir(), WorkDirSerializer$.MODULE$.$lessinit$greater$default$3()))}));
        }
    }

    @Bean
    @Autowired
    public ActorRef workerManager(TaskExecutionWorkerRepository taskExecutionWorkerRepository, ConfigurationHashProvider configurationHashProvider) {
        return EngineBeanBuilder$.MODULE$.createWorkerManager(this.system(), taskExecutionWorkerRepository, configurationHashProvider.configurationHash(), this.xldConfig().inProcessTaskEngine());
    }

    @Bean
    @DependsOn(value={"upgrader"})
    @Autowired
    public TaskExecutionEngine engine(ActiveTaskRepository activeTaskRepository, PendingTaskRepository pendingTaskRepository, @Qualifier(value="xlJmsListenerContainerFactory") JmsListenerContainerFactory<DefaultMessageListenerContainer> containerFactory, TaskExecutionWorkerRepository taskExecutionWorkerRepository, @Qualifier(value="workerManager") ActorRef workerManager, StepLogFactory stepLogFactory, StepLogRetriever stepLogRetriever, ConfigurationHashProvider configurationHashProvider, XldConfig xldConfig, TaskQueueService taskQueueService) {
        ActorRef actorRef;
        TaskerSettings taskerSettings = new CommonSettings(xldConfig.rootConfig()).tasker();
        TaskFinalizerImpl taskFinalizer = new TaskFinalizerImpl(this.system(), (CrudTaskRepository)activeTaskRepository, pendingTaskRepository, taskerSettings.askTimeout());
        TaskExecutionEngine engine = new TaskExecutionEngine(activeTaskRepository, pendingTaskRepository, taskExecutionWorkerRepository, taskQueueService, this.system(), workerManager, (TaskFinalizer)taskFinalizer);
        if (xldConfig.inProcessTaskEngine()) {
            this.logger().info("An in-process task execution worker will be registered.");
            TaskExecutionWorker$.MODULE$.local(this.repositoryAdapter(), this.archive(), configurationHashProvider, activeTaskRepository, pendingTaskRepository, taskExecutionWorkerRepository, containerFactory, taskerSettings, stepLogFactory, stepLogRetriever, this.system()).recoverTasks();
            DiscoveryWorker$.MODULE$.initialize(this.system());
            actorRef = BoxedUnit.UNIT;
        } else {
            this.logger().debug("Registering for remote change set events.");
            actorRef = this.system().actorOf(RemoteChangeSetEventListener$.MODULE$.props(), RemoteChangeSetEventListener$.MODULE$.name());
        }
        this.rescheduleTasks(pendingTaskRepository, engine);
        return engine;
    }

    @Bean
    @Autowired
    public DiscoveryService discoveryService(@Qualifier(value="workerManager") ActorRef workerManager) {
        return new DiscoveryService(this.system(), workerManager);
    }

    @PreDestroy
    public void destroy() {
        Akka25$.MODULE$.terminate(this.system(), (Duration)Duration$.MODULE$.Inf());
    }

    private void rescheduleTasks(PendingTaskRepository pendingTaskRepository, TaskExecutionEngine engine) {
        pendingTaskRepository.scheduledTasks().forEach(task -> {
            Throwable ex;
            DateTime scheduledDate = task.getScheduledDate();
            String date = scheduledDate.toDateTimeISO().toString("yyyy-MM-dd'T'HH:mm:ss");
            if (scheduledDate.isBeforeNow()) {
                this.logger().info(new StringBuilder(67).append("Scheduled task [").append(task.getId()).append("] with date [").append(date).append("] has already passed so executing now.").toString());
                engine.execute(task.getId());
                return;
            }
            boolean bl = false;
            Failure failure = null;
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> engine.schedule(task.getId(), scheduledDate));
            if (try_ instanceof Failure) {
                bl = true;
                failure = (Failure)try_;
                Throwable ex2 = failure.exception();
                if (ex2 instanceof TaskerException) {
                    TaskerException taskerException = (TaskerException)ex2;
                    this.logger().warn(new StringBuilder(73).append("Scheduled task [").append(task.getId()).append("] with start date [").append(date).append("] cannot be rescheduled automatically.").toString());
                    this.logger().warn(taskerException.getMessage());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
            if (bl && (ex = failure.exception()) instanceof Exception) {
                Exception exception = (Exception)ex;
                this.logger().warn(new StringBuilder(100).append("Scheduled task [").append(task.getId()).append("] with start date [").append(date).append("] cannot be rescheduled automatically. Unexpected error occurred.").toString());
                throw exception;
            }
            if (!(try_ instanceof Success)) throw new MatchError((Object)try_);
            this.logger().info(new StringBuilder(52).append("Scheduled task [").append(task.getId()).append("] with start date [").append(date).append("] was rescheduled").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
    }

    public EngineBeanBuilder(@Autowired XldConfig xldConfig, @Autowired Archive archive, @Autowired RepositoryFactory repositoryAdapter) {
        this.xldConfig = xldConfig;
        this.archive = archive;
        this.repositoryAdapter = repositoryAdapter;
        this.logger = LoggerFactory.getLogger(EngineBeanBuilder.class);
        this.system = TaskActorSystem$.MODULE$.actorSystem();
    }
}

