/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.deployment.planner.CheckPointManagerListener;
import com.xebialabs.deployit.deployment.planner.MultiDeltaSpecification;
import com.xebialabs.deployit.engine.api.distribution.TaskExecutionWorkerRepository;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.tasker.IEngine;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.engine.tasker.TaskExecutionContext;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.engine.tasker.repository.PendingTaskRepository;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.deployit.service.deployment.DeploymentService;
import com.xebialabs.deployit.service.deployment.RollbackCompletedListener;
import com.xebialabs.deployit.task.TaskMetadata;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.WorkdirCleanerTrigger;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.UUID;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001B\u0007\u000f\u0001eA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005c!AQ\u0007\u0001B\u0001B\u0003%a\u0007\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u0019i\u0007\u0001\"\u0001\u000f]\")Q\u000e\u0001C\u0005g\"9\u0011Q\u0004\u0001\u0005\n\u0005}\u0001bBA\u001b\u0001\u0011%\u0011q\u0007\u0005\t\u0003w\u0001A\u0011\u0001\b\u0002>!9\u0011Q\r\u0001\u0005\n\u0005\u001d$a\u0004*pY2\u0014\u0017mY6TKJ4\u0018nY3\u000b\u0005=\u0001\u0012A\u00033fa2|\u00170\\3oi*\u0011\u0011CE\u0001\bg\u0016\u0014h/[2f\u0015\t\u0019B#\u0001\u0005eKBdw._5u\u0015\t)b#A\u0005yK\nL\u0017\r\\1cg*\tq#A\u0002d_6\u001c\u0001aE\u0002\u00015\u0001\u0002\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011a!\u00118z%\u00164\u0007CA\u0011'\u001b\u0005\u0011#BA\u0012%\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005)\u0013\u0001C4sSjTH.\u001a3\n\u0005\u001d\u0012#a\u0002'pO\u001eLgnZ\u0001\u0007K:<\u0017N\\3\u0011\u0005)rS\"A\u0016\u000b\u00051j\u0013A\u0002;bg.,'O\u0003\u0002)%%\u0011qf\u000b\u0002\b\u0013\u0016sw-\u001b8f\u0003E!W\r\u001d7ps6,g\u000e^*feZL7-\u001a\t\u0003eMj\u0011AD\u0005\u0003i9\u0011\u0011\u0003R3qY>LX.\u001a8u'\u0016\u0014h/[2f\u0003A9xN]6feJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00028y5\t\u0001H\u0003\u0002:u\u0005aA-[:ue&\u0014W\u000f^5p]*\u00111(L\u0001\u0004CBL\u0017BA\u001f9\u0005u!\u0016m]6Fq\u0016\u001cW\u000f^5p]^{'o[3s%\u0016\u0004xn]5u_JL\u0018!\u00069f]\u0012Lgn\u001a+bg.\u0014V\r]8tSR|'/\u001f\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005.\n!B]3q_NLGo\u001c:z\u0013\t!\u0015IA\u000bQK:$\u0017N\\4UCN\\'+\u001a9pg&$xN]=\u0002\rqJg.\u001b;?)\u00159\u0005*\u0013&L!\t\u0011\u0004\u0001C\u0003)\u000b\u0001\u0007\u0011\u0006C\u00031\u000b\u0001\u0007\u0011\u0007C\u00036\u000b\u0001\u0007a\u0007C\u0003?\u000b\u0001\u0007q\b\u000b\u0002\u0006\u001bB\u0011a*W\u0007\u0002\u001f*\u0011\u0001+U\u0001\u000bC:tw\u000e^1uS>t'B\u0001*T\u0003\u001d1\u0017m\u0019;pefT!\u0001V+\u0002\u000b\t,\u0017M\\:\u000b\u0005Y;\u0016aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003a\u000b1a\u001c:h\u0013\tQvJA\u0005BkR|w/\u001b:fI\u0006A!o\u001c7mE\u0006\u001c7\u000e\u0006\u0002^QB\u0011a,\u001a\b\u0003?\u000e\u0004\"\u0001\u0019\u000f\u000e\u0003\u0005T!A\u0019\r\u0002\rq\u0012xn\u001c;?\u0013\t!G$\u0001\u0004Qe\u0016$WMZ\u0005\u0003M\u001e\u0014aa\u0015;sS:<'B\u00013\u001d\u0011\u0015Ig\u00011\u0001k\u0003\u0011!\u0018m]6\u0011\u0005)Z\u0017B\u00017,\u0005\u0011!\u0016m]6\u00027\r\u0014X-\u0019;f%>dGNY1dWN\u0003XmY5gS\u000e\fG/[8o)\ty'\u000f\u0005\u0002+a&\u0011\u0011o\u000b\u0002\u0012)\u0006\u001c8n\u00159fG&4\u0017nY1uS>t\u0007\"B5\b\u0001\u0004QG\u0003B8ukzDQ!\u001b\u0005A\u0002)DQA\u001e\u0005A\u0002]\fA\u0003]1si&\fGnQ8n[&$HK]5hO\u0016\u0014\bC\u0001=}\u001b\u0005I(B\u0001>|\u0003\u001d\u0001H.\u00198oKJT!a\u0004\n\n\u0005uL(!G\"iK\u000e\\\u0007k\\5oi6\u000bg.Y4fe2K7\u000f^3oKJDaa \u0005A\u0002\u0005\u0005\u0011\u0001C<pe.$\u0015N]:\u0011\r\u0005\r\u0011QBA\n\u001d\u0011\t)!!\u0003\u000f\u0007\u0001\f9!C\u0001\u001e\u0013\r\tY\u0001H\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty!!\u0005\u0003\t1K7\u000f\u001e\u0006\u0004\u0003\u0017a\u0002\u0003BA\u000b\u00033i!!a\u0006\u000b\u0005\t\u0013\u0012\u0002BA\u000e\u0003/\u0011qaV8sW\u0012K'/A\thKR<vN]6eSJ\u001cE.Z1oKJ$B!!\t\u0002,A!\u00111EA\u0014\u001b\t\t)C\u0003\u0002j%%!\u0011\u0011FA\u0013\u0005U9vN]6eSJ\u001cE.Z1oKJ$&/[4hKJDq!!\f\n\u0001\u0004\ty#A\u0004d_:$X\r\u001f;\u0011\u0007)\n\t$C\u0002\u00024-\u0012A\u0003V1tW\u0016CXmY;uS>t7i\u001c8uKb$\u0018\u0001H4fi\u000eCWmY6Q_&tG/T1oC\u001e,'\u000fT5ti\u0016tWM\u001d\u000b\u0004o\u0006e\u0002bBA\u0017\u0015\u0001\u0007\u0011qF\u0001\u0012I>\u0004&/\u001a9be\u0016\u0014v\u000e\u001c7cC\u000e\\GCBA \u0003?\n\t\u0007\u0005\u0003\u0002B\u0005ec\u0002BA\"\u0003/rA!!\u0012\u0002V9!\u0011qIA*\u001d\u0011\tI%!\u0015\u000f\t\u0005-\u0013q\n\b\u0004A\u00065\u0013\"A\f\n\u0005U1\u0012BA\n\u0015\u0013\tA##\u0003\u0002-[%\u0019\u00111B\u0016\n\t\u0005m\u0013Q\f\u0002\u0007)\u0006\u001c8.\u00133\u000b\u0007\u0005-1\u0006C\u0003j\u0017\u0001\u0007!\u000e\u0003\u0004\u0002d-\u0001\ra\\\u0001\u0016e>dGNY1dWN\u0003XmY5gS\u000e\fG/[8o\u0003\u001d\t'o\u00195jm\u0016$B!!\u001b\u0002pA\u00191$a\u001b\n\u0007\u00055DD\u0001\u0003V]&$\b\"B5\r\u0001\u0004Q\u0007f\u0001\u0001\u0002tA!\u0011QOA>\u001b\t\t9HC\u0002\u0002zU\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\ti(a\u001e\u0003\u0013\r{W\u000e]8oK:$\b")
public class RollbackService
implements Logging {
    private final IEngine engine;
    private final DeploymentService deploymentService;
    private final TaskExecutionWorkerRepository workerRepository;
    private final PendingTaskRepository pendingTaskRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RollbackService rollbackService = this;
        synchronized (rollbackService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public String rollback(Task task) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Going to rollback task ").append(task.getId()).toString());
        TaskSpecification rollbackSpecification = this.createRollbackSpecification(task);
        this.workerRepository.getWorker(task.getWorkerId()).foreach((Function1 & Serializable & scala.Serializable)worker -> $this.pendingTaskRepository.store(rollbackSpecification, (Option)new Some((Object)worker.address())));
        return this.doPrepareRollback(task, rollbackSpecification);
    }

    public TaskSpecification createRollbackSpecification(Task task) {
        TaskExecutionContext context = task.getContext();
        WorkdirCleanerTrigger workdirCleanerTrigger = this.getWorkdirCleaner(context);
        CheckPointManagerListener checkPointManagerListener = this.getCheckPointManagerListener(context);
        TaskSpecification rollbackSpecification = this.createRollbackSpecification(task, checkPointManagerListener, (List<WorkDir>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(workdirCleanerTrigger.getWorkDirs()).asScala()).toList());
        rollbackSpecification.getListeners().add(new RollbackCompletedListener(task.getId()));
        TaskMetadata.putMetadata((TaskSpecification)rollbackSpecification, (String)"taskType", (String)TaskType.ROLLBACK.name());
        TaskMetadata.putMetadata((TaskSpecification)rollbackSpecification, (String)"rollbackTask", (String)task.getId());
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Create rollback task ").append(rollbackSpecification.getId()).append(" for task ").append(task.getId()).toString());
        return rollbackSpecification;
    }

    private TaskSpecification createRollbackSpecification(Task task, CheckPointManagerListener partialCommitTrigger, List<WorkDir> workDirs) {
        TaskExecutionState taskExecutionState = task.getState();
        TaskExecutionState taskExecutionState2 = TaskExecutionState.EXECUTED;
        boolean includeAll = !(taskExecutionState != null ? !taskExecutionState.equals(taskExecutionState2) : taskExecutionState2 != null);
        MultiDeltaSpecification rollbackSpec = partialCommitTrigger.checkpointManager().prepareRollback(includeAll);
        WorkDirContext.setWorkDir((WorkDir)task.getWorkDir());
        String rollbackTaskId = UUID.randomUUID().toString();
        return this.deploymentService.getTaskFullSpecification(rollbackTaskId, rollbackSpec, task.getWorkDir(), (WorkDir[])workDirs.toArray(ClassTag$.MODULE$.apply(WorkDir.class)));
    }

    private WorkdirCleanerTrigger getWorkdirCleaner(TaskExecutionContext context) {
        String name = WorkdirCleanerTrigger.class.getName();
        return (WorkdirCleanerTrigger)context.getAttribute(name);
    }

    private CheckPointManagerListener getCheckPointManagerListener(TaskExecutionContext context) {
        String name = CheckPointManagerListener.class.getName();
        return (CheckPointManagerListener)context.getAttribute(name);
    }

    public String doPrepareRollback(Task task, TaskSpecification rollbackSpecification) {
        this.engine.prepareRollback(task.getId(), rollbackSpecification);
        this.archive(task);
        return rollbackSpecification.getId();
    }

    private void archive(Task task) {
        TaskExecutionState taskExecutionState = task.getState();
        TaskExecutionState taskExecutionState2 = TaskExecutionState.EXECUTED;
        if (!(taskExecutionState != null ? !taskExecutionState.equals(taskExecutionState2) : taskExecutionState2 != null)) {
            this.engine.archive(task.getId());
        } else if (((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TaskExecutionState[]{TaskExecutionState.STOPPED, TaskExecutionState.ABORTED, TaskExecutionState.FAILED}))).contains((Object)task.getState())) {
            this.engine.cancel(task.getId());
        } else {
            throw new IllegalStateException(new StringBuilder(67).append("Can only rollback a STOPPED, FAILED, ABORTED or EXECUTED task [").append(task.getId()).append(" (").append(task.getState()).append(")]").toString());
        }
    }

    @Autowired
    public RollbackService(IEngine engine, DeploymentService deploymentService, TaskExecutionWorkerRepository workerRepository, PendingTaskRepository pendingTaskRepository) {
        this.engine = engine;
        this.deploymentService = deploymentService;
        this.workerRepository = workerRepository;
        this.pendingTaskRepository = pendingTaskRepository;
        Logging.$init$((Logging)this);
    }
}

