/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.DeployableContainer;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployable;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployed;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployedContainer;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.deployment.DeployedApplicationFactory;
import com.xebialabs.deployit.service.deployment.TypeCalculator;
import com.xebialabs.deployit.service.deployment.setter.AbstractPropertySetter;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import com.xebialabs.deployit.service.replacement.DictionaryValueException;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderScanner;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployedPropertySetter {
    private final TypeCalculator calculator;
    private final AbstractPropertySetter propertySetter;
    private static final Logger logger = LoggerFactory.getLogger(DeployedPropertySetter.class);

    public DeployedPropertySetter(TypeCalculator calculator, AbstractPropertySetter propertySetter) {
        this.calculator = calculator;
        this.propertySetter = propertySetter;
    }

    void setProperties(EmbeddedDeployedContainer<?, ?> deployed, EmbeddedDeployedContainer<?, ?> previousDeployed, ConsolidatedDictionary dictionary) {
        Checks.checkArgument((previousDeployed == null || deployed.getType().equals((Object)previousDeployed.getType()) ? 1 : 0) != 0, (String)"New and existing target types should be equal when upgrading (%s)", (Object[])new Object[]{deployed.getType()});
        for (PropertyDescriptor deployedPropDesc : deployed.getType().getDescriptor().getPropertyDescriptors()) {
            if (deployedPropDesc.isDeployedSpecific()) continue;
            if (this.isEmbeddedProperty(deployedPropDesc)) {
                this.generateEmbeddeds(deployed, deployedPropDesc, dictionary);
                continue;
            }
            ConfigurationItem currentDeployable = deployed.getDeployable();
            ConfigurationItem previousDeployable = previousDeployed == null ? null : previousDeployed.getDeployable();
            this.setProperty((ConfigurationItem)deployed, (ConfigurationItem)previousDeployed, currentDeployable, previousDeployable, dictionary, deployedPropDesc);
        }
    }

    void setProperties(DeployedApplication currentDeployedApp, DeployedApplication existingDeployedApp, ConsolidatedDictionary dictionary) {
        Version currentPackage = currentDeployedApp.getVersion();
        Stream<PropertyDescriptor> deployedAppPd = currentDeployedApp.getType().getDescriptor().getPropertyDescriptors().stream().filter(pd -> !pd.isDeployedSpecific());
        Stream<PropertyDescriptor> packagePd = currentPackage.getType().getDescriptor().getPropertyDescriptors().stream().filter(pd -> currentDeployedApp.hasProperty(pd.getName())).map(pd -> currentDeployedApp.getType().getDescriptor().getPropertyDescriptor(pd.getName()));
        Version previousPackage = existingDeployedApp == null ? null : existingDeployedApp.getVersion();
        Stream.concat(deployedAppPd, packagePd).collect(Collectors.toSet()).forEach(arg_0 -> this.lambda$setProperties$3(currentDeployedApp, existingDeployedApp, (ConfigurationItem)currentPackage, (ConfigurationItem)previousPackage, dictionary, arg_0));
    }

    private void setProperty(ConfigurationItem currentTarget, ConfigurationItem previousTarget, ConfigurationItem currentSource, ConfigurationItem previousSource, ConsolidatedDictionary dictionary, PropertyDescriptor targetPropertyDescriptor) {
        logger.trace("Going to set property {} of currentTarget {}", (Object)targetPropertyDescriptor.getFqn(), (Object)currentTarget);
        PropertyDescriptor sourcePropertyDescriptor = null;
        if (currentTarget instanceof Container && targetPropertyDescriptor.getName().equals("tags") && currentSource instanceof DeployableContainer) {
            sourcePropertyDescriptor = currentSource.getType().getDescriptor().getPropertyDescriptor("containerTags");
        } else if (currentSource.hasProperty(targetPropertyDescriptor.getName())) {
            sourcePropertyDescriptor = currentSource.getType().getDescriptor().getPropertyDescriptor(targetPropertyDescriptor.getName());
        }
        this.propertySetter.setProperty(currentTarget, previousTarget, currentSource, previousSource, dictionary, targetPropertyDescriptor, sourcePropertyDescriptor);
    }

    private void generateEmbeddeds(EmbeddedDeployedContainer<?, ?> deployed, PropertyDescriptor deployedPropDesc, ConsolidatedDictionary dictionary) {
        ConfigurationItem deployable = deployed.getDeployable();
        String name = deployedPropDesc.getName();
        AbstractCollection embeddedDeployeds = deployedPropDesc.getKind() == PropertyKind.LIST_OF_CI ? Lists.newArrayList() : Sets.newHashSet();
        PropertyDescriptor deployableProperty = deployable.getType().getDescriptor().getPropertyDescriptor(name);
        if (deployableProperty == null) {
            logger.info("Deployed [{}] has embedded deployeds in property [{}] but source [{}] has no such property.", new Object[]{deployed.getId(), deployedPropDesc.getFqn(), deployable.getId()});
            return;
        }
        Collection embeddedDeployables = (Collection)deployableProperty.get(deployable);
        for (EmbeddedDeployable embeddedDeployable : embeddedDeployables) {
            List<Type> embeddedDeployedTypes = this.calculator.findAllMostSpecificDeployedTypesForDeployableAndContainerTypes(embeddedDeployable.getType(), deployed.getType());
            Collection filtered = Collections2.filter(embeddedDeployedTypes, input -> input.instanceOf(deployedPropDesc.getReferencedType()));
            if (filtered.isEmpty()) {
                logger.info("Not found a matching EmbeddedDeployed type for [{}] and [{}]", (Object)embeddedDeployable.getType(), (Object)deployed.getType());
                continue;
            }
            if (filtered.size() > 1) {
                logger.error("Found more than 1 ({}) compatible EmbeddedDeployed type for [{}] and [{}]", new Object[]{filtered, embeddedDeployable.getType(), deployed.getType()});
                throw new Checks.IncorrectArgumentException("Found more than 1 (%s) compatible EmbeddedDeployed type for [%s] and [%s]", new Object[]{filtered, embeddedDeployable.getType(), deployed.getType()});
            }
            Type embeddedDeployedType = (Type)filtered.iterator().next();
            EmbeddedDeployed embeddedDeployed = (EmbeddedDeployed)embeddedDeployedType.getDescriptor().newInstance(IdGenerator.generateId(deployed, (String)embeddedDeployable.getId()));
            embeddedDeployed.setDeployable((ConfigurationItem)embeddedDeployable);
            embeddedDeployed.setContainer(deployed);
            if (MustachePlaceholderScanner.hasPlaceholders((String)embeddedDeployed.getName())) {
                try {
                    dictionary.resolveDeployedName((EmbeddedDeployedContainer)embeddedDeployed);
                }
                catch (DictionaryValueException e) {
                    throw new DeployedApplicationFactory.IncorrectDeployedException(e, "Couldn't generate name for target from [%s]", embeddedDeployable.getId());
                }
            }
            embeddedDeployeds.add(embeddedDeployed);
            this.setProperties((EmbeddedDeployedContainer<?, ?>)embeddedDeployed, null, dictionary);
        }
        deployedPropDesc.set(deployed, (Object)embeddedDeployeds);
    }

    private boolean isEmbeddedProperty(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.isAsContainment() && (propertyDescriptor.getKind() == PropertyKind.SET_OF_CI || propertyDescriptor.getKind() == PropertyKind.LIST_OF_CI) && propertyDescriptor.getReferencedType().isSubTypeOf(Type.valueOf(EmbeddedDeployed.class));
    }

    private /* synthetic */ void lambda$setProperties$3(DeployedApplication currentDeployedApp, DeployedApplication existingDeployedApp, ConfigurationItem currentPackage, ConfigurationItem previousPackage, ConsolidatedDictionary dictionary, PropertyDescriptor pd) {
        this.setProperty((ConfigurationItem)currentDeployedApp, (ConfigurationItem)existingDeployedApp, currentPackage, previousPackage, dictionary, pd);
    }
}

