package com.xebialabs.deployit.core.api;

import java.util.List;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.jboss.resteasy.annotations.ClientResponseType;

import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;

@Path("/internal/reports")
@Consumes({MediaType.APPLICATION_XML})
public interface InternalReportProxy {

    @GET
    @Path("deployments")
    @Produces(MediaType.APPLICATION_XML)
    Report deploymentsForEnvironment(@QueryParam("parent") String environment, @QueryParam("date") Date date, @HeaderParam("Accept") String acceptedContentType);

    @GET
    @Path("download/deployments")
    @Produces(MediaType.APPLICATION_XML)
    String downloadDeploymentsForEnvironment(@QueryParam("parent") String environment, @QueryParam("date") Date date, @HeaderParam("Accept") String acceptedContentType);

    /**
     * Returns archived task by ID for viewing only.
     *
     * @deprecated
     *
     * @permission Available to everyone with report#view
     * @param taskId the ID of the task
     * @return the task.
     */
    @Deprecated
    @GET
    @Path("task/{taskid}")
    TaskWithSteps getTask(@PathParam("taskid") String taskId);

    @GET
    @Path("taskblock/{taskid}")
    TaskWithBlock getTaskWithBlock(@PathParam("taskid") String taskId);

    @POST
    @Path("tasks")
    @Produces(MediaType.APPLICATION_XML)
    Report getTaskReport(
        @QueryParam("begin") Date begin,
        @QueryParam("end") Date end,
        @HeaderParam("Accept") String acceptedContentType,
        @QueryParam("filterType") String filterType,
        List<ConfigurationItemId> configurationItemIds);

    @POST
    @Path("download/tasks")
    @Produces(MediaType.APPLICATION_XML)
    String downloadTaskReport(
        @QueryParam("begin") Date begin,
        @QueryParam("end") Date end,
        @HeaderParam("Accept") String acceptedContentType,
        @QueryParam("filterType") String filterType,
        List<ConfigurationItemId> configurationItemIds);

    @POST
    @Path("cloudtasks")
    @Produces(MediaType.APPLICATION_XML)
    Report getCloudTasksReport(
        @QueryParam("begin") Date begin,
        @QueryParam("end") Date end,
        @HeaderParam("Accept") String acceptedContentType,
        @QueryParam("filterType") String filterType,
        List<ConfigurationItemId> configurationItemIds);

    @POST
    @Path("download/cloudtasks")
    @Produces(MediaType.APPLICATION_XML)
    String downloadCloudTasksReport(
        @QueryParam("begin") Date begin,
        @QueryParam("end") Date end,
        @HeaderParam("Accept") String acceptedContentType,
        @QueryParam("filterType") String filterType,
        List<ConfigurationItemId> configurationItemIds);

    @GET
    @Path("cloudenvironmenttemplates")
    @Produces({MediaType.APPLICATION_XML})
    List<ConfigurationItemId> listCloudEnvironmentTemplates();

    @POST
    @Path("deploymentsstatebreakdown")
    @Produces(MediaType.APPLICATION_XML)
    Report deploymentsStateBreakdown(
            @QueryParam("filterType") String filterType,
            @QueryParam("begin") Date begin,
            @QueryParam("end") Date end,
            @HeaderParam("Accept") String acceptedContentType,
            List<ConfigurationItemId> configurationItemIds);

    @POST
    @Path("download/deploymentsstatebreakdown")
    @Produces(MediaType.APPLICATION_XML)
    String downloadDeploymentsStateBreakdown(
            @QueryParam("filterType") String filterType,
            @QueryParam("begin") Date begin,
            @QueryParam("end") Date end,
            @HeaderParam("Accept") String acceptedContentType,
            List<ConfigurationItemId> configurationItemIds);

    @POST
    @Path("deploymentskeyindicator")
    @Produces(MediaType.APPLICATION_XML)
    Report deploymentsKeyIndicator(
        @QueryParam("begin") Date begin,
        @QueryParam("end") Date end,
        @HeaderParam("Accept") String acceptedContentType,
        @QueryParam("filterType") String filterType,
        List<ConfigurationItemId> configurationItemIds);

    @POST
    @Path("download/deploymentskeyindicator")
    @Produces(MediaType.APPLICATION_XML)
    String downloadDeploymentsKeyIndicator(
            @QueryParam("filterType") String filterType,
            @QueryParam("begin") Date begin,
            @QueryParam("end") Date end,
            @HeaderParam("Accept") String acceptedContentType,
            List<ConfigurationItemId> configurationItemIds);

    @GET
    @Path("controltasks")
    @Produces(MediaType.APPLICATION_XML)
    Report getControlTasksReport(
            @QueryParam("begin") Date begin,
            @QueryParam("end") Date end);

    @GET
    @Path("download/controltasks")
    @Produces(MediaType.APPLICATION_XML)
    String downloadControlTasksReport(
            @QueryParam("begin") Date begin,
            @QueryParam("end") Date end);

    @POST
    @Path("deploymentskeyindicatoraggregatedbyfiltertype")
    @Produces(MediaType.APPLICATION_XML)
    Report deploymentsKeyIndicatorAggregatedByFilterType(
            @QueryParam("filterType") String filterType,
            @QueryParam("begin") Date begin,
            @QueryParam("end") Date end,
            @HeaderParam("Accept") String acceptedContentType,
            List<ConfigurationItemId> configurationItemIds);

    @POST
    @Path("download/deploymentskeyindicatoraggregatedbyfiltertype")
    @Produces(MediaType.APPLICATION_XML)
    String downloadDeploymentsKeyIndicatorAggregatedByFilterType(
            @QueryParam("filterType") String filterType,
            @QueryParam("begin") Date begin,
            @QueryParam("end") Date end,
            @HeaderParam("Accept") String acceptedContentType,
            List<ConfigurationItemId> configurationItemIds);

    @GET
    @Path("widgetdata")
    @Produces({MediaType.APPLICATION_XML})
    @ClientResponseType(entityType = Report.class)
    Response getDashboardWidgetReport(@QueryParam("widgetType") String widgetType, @QueryParam("begin") Date begin, @QueryParam("end") Date end);

    @GET
    @Path("environments")
    @Produces({MediaType.APPLICATION_XML})
    List<ConfigurationItemId> listEnvironments();

}
