/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.api.dto;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.xebialabs.deployit.core.api.dto.AbstractDTO;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="security-settings")
public class PrincipalPermissions
extends AbstractDTO {
    @XmlAttribute
    private String username;
    @XmlElement
    private List<PrincipalPermission> permissions = Lists.newArrayList();

    public PrincipalPermissions() {
    }

    public PrincipalPermissions(String userName, Multimap<String, String> principalPermissions) {
        this.username = userName;
        if (principalPermissions != null) {
            this.convert(principalPermissions);
        }
    }

    private void convert(Multimap<String, String> principalPermissions) {
        for (String node : principalPermissions.keySet()) {
            this.permissions.add(new PrincipalPermission(node, Lists.newArrayList((Iterable)principalPermissions.get((Object)node))));
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String userName) {
        this.username = userName;
    }

    public boolean hasPermissions() {
        return !this.permissions.isEmpty();
    }

    public boolean hasPermission(final String permission) {
        return !Collections2.filter(this.permissions, (Predicate)new Predicate<PrincipalPermission>(){

            public boolean apply(PrincipalPermission input) {
                return Strings.isNullOrEmpty((String)input.node) && input.permissions.contains(permission);
            }
        }).isEmpty();
    }

    public boolean hasPermission(final String node, final String permission) {
        return !Collections2.filter(this.permissions, (Predicate)new Predicate<PrincipalPermission>(){

            public boolean apply(PrincipalPermission input) {
                return (node == input.node || node != null && node.equals(input.node)) && input.permissions.contains(permission);
            }
        }).isEmpty();
    }

    @Override
    public String toString() {
        StringBuilder permissionString = new StringBuilder();
        if ("admin".equals(this.username)) {
            permissionString.append("User admin has all permissions.\n");
        } else if (this.permissions == null || this.permissions.isEmpty()) {
            permissionString.append("No permissions found.\n");
        } else {
            for (PrincipalPermission permissionEntry : this.permissions) {
                if (permissionEntry.node.equals("")) {
                    permissionString.append(String.format("\nGranted global permissions:\n", new Object[0]));
                    this.appendPermissions(permissionString, permissionEntry.permissions);
                    continue;
                }
                permissionString.append(String.format("\nGranted permissions on node '%s':\n", permissionEntry.node));
                this.appendPermissions(permissionString, permissionEntry.permissions);
            }
        }
        return permissionString.toString();
    }

    private void appendPermissions(StringBuilder permissionString, List<String> permissions) {
        for (String permission : permissions) {
            permissionString.append(String.format("\t- %s\n", permission));
        }
    }

    @XmlRootElement
    private static class PrincipalPermission {
        @XmlElement
        private String node;
        @XmlElement
        private List<String> permissions = Lists.newArrayList();

        private PrincipalPermission(String node, List<String> permissions) {
            this.node = node;
            this.permissions = permissions;
        }

        public PrincipalPermission() {
        }
    }
}

