package com.xebialabs.deployit.core.api;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import com.xebialabs.deployit.core.api.dto.ConfigurationItemIds;
import org.jboss.resteasy.annotations.ClientResponseType;

import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.CustomMediaType;
import com.xebialabs.deployit.core.api.resteasy.Date;

@Path("/reports")
@Consumes({MediaType.APPLICATION_XML})
public interface ReportProxy {

	@GET
    @Path("deployments")
    @Produces({MediaType.APPLICATION_XML, CustomMediaType.TEXT_CSV})
    @ClientResponseType(entityType = Report.class)
    Response deploymentsForEnvironment(@QueryParam("parent") String environment, @QueryParam("date") Date date, @HeaderParam("Accept") String acceptedContentType);

    @GET
    @Path("tasks")
    @Produces({MediaType.APPLICATION_XML, CustomMediaType.TEXT_CSV})
    @ClientResponseType(entityType = Report.class)
    Response tasksInDateRange(@QueryParam("begin") Date begin, @QueryParam("end") Date end, @HeaderParam("Accept") String acceptedContentType);
    
	@GET
	@Path("deploymentsstatebreakdown")
	@Produces({MediaType.APPLICATION_XML, CustomMediaType.TEXT_CSV})
	@ClientResponseType(entityType = Report.class)
	Response deploymentsStateBreakdown(@QueryParam("filterType") String filterType, @QueryParam("begin") Date begin, @QueryParam("end") Date end, @HeaderParam("Accept") String acceptedContentType, ConfigurationItemIds configurationItemIds);
	
	@GET
	@Path("deploymentskeyindicator")
	@Produces({MediaType.APPLICATION_XML, CustomMediaType.TEXT_CSV})
	@ClientResponseType(entityType = Report.class)
	Response deploymentsKeyIndicator(@QueryParam("begin") Date begin, @QueryParam("end") Date end, @HeaderParam("Accept") String acceptedContentType);
	
	@GET
	@Path("deploymentskeyindicatoraggregatedbyfiltertype")
	@Produces({MediaType.APPLICATION_XML, CustomMediaType.TEXT_CSV})
	@ClientResponseType(entityType = Report.class)
	Response deploymentsKeyIndicatorAggregatedByFilterType(@QueryParam("filterType") String filterType, @QueryParam("begin") Date begin, @QueryParam("end") Date end, @HeaderParam("Accept") String acceptedContentType, ConfigurationItemIds configurationItemIds);
	
	@GET
	@Path("widgetdata")
	@Produces({MediaType.APPLICATION_XML})
	@ClientResponseType(entityType = Report.class)
	Response getDashboardWidgetReport(@QueryParam("widgetType") String widgetType, @QueryParam("begin") Date begin, @QueryParam("end") Date end);
}
