package com.xebialabs.deployit.core.api.resteasy.http.tunnel;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import java.util.ArrayList;

/**
 */
public class HeaderMultimapAdapter extends XmlAdapter<HeaderMultimapAdapter.HeaderPair[], Multimap<String, String>> {
	@Override
	public Multimap<String, String> unmarshal(final HeaderPair[] v) throws Exception {
		throw new UnsupportedOperationException("Only to XML supported as we don't have a need for the reverse (yet)...");
	}

	@Override
	public HeaderPair[] marshal(final Multimap<String, String> v) throws Exception {
		if (v == null) {
			return new HeaderPair[0];
		}

		final ArrayList<HeaderPair> list = Lists.newArrayList();
		for (String key : v.keySet()) {
			for (String valueOfKey : v.get(key)) {
				list.add(new HeaderPair(key, valueOfKey));
			}
		}

		return list.toArray(new HeaderPair[list.size()]);
	}


	@XmlRootElement(name = "header")
	public static class HeaderPair {

		private String name;
		private String value;

		public HeaderPair() {
		}

		public HeaderPair(final String name, final String value) {
			this.name = name;
			this.value = value;
		}

		public String getName() {
			return name;
		}

		public void setName(final String name) {
			this.name = name;
		}

		public String getValue() {
			return value;
		}

		public void setValue(final String value) {
			this.value = value;
		}
	}
}
