package com.xebialabs.deployit.core.api.dto;

import java.util.List;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(XmlAccessType.NONE)
@XmlRootElement(name="archived-tasks")
public class FullTaskInfos extends AbstractDTO {

	private List<FullTaskInfo> fullTaskInfoList =  new ArrayList<FullTaskInfo>();

	public FullTaskInfos() {
	}

	@XmlElement(name = "task")
	public List<FullTaskInfo> getTasks() {
		return fullTaskInfoList;
	}

	public void setTasks(final List<FullTaskInfo> taskInfoList) {
		this.fullTaskInfoList = taskInfoList;
	}

	public boolean addTask(final FullTaskInfo taskInfo) {
		return (taskInfo != null) ? this.fullTaskInfoList.add(taskInfo) : false;
	}
	
	public boolean addTasks(final Collection<? extends FullTaskInfo> taskInfos) {
		return (taskInfos != null) ? this.fullTaskInfoList.addAll(taskInfos) : false;
	}

	public int size() {
		return this.fullTaskInfoList.size();
	}

	public boolean isEmpty() {
		return this.fullTaskInfoList.isEmpty();
	}
}
