package com.xebialabs.deployit.core.api;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.MediaType;

import org.jboss.resteasy.annotations.ClientResponseType;
import com.xebialabs.deployit.core.api.dto.PrincipalPermissions;
import com.xebialabs.deployit.core.api.dto.RepositoryObjectIds;

@Path("/security")
@Consumes({ MediaType.APPLICATION_XML })
@Produces({ MediaType.APPLICATION_XML })
public interface SecurityProxy {

	@GET
	@Path("retrieve/{user}")
	@Produces({MediaType.APPLICATION_XML})
	@ClientResponseType(entityType = PrincipalPermissions.class)
	public Response retrievePermissions(@PathParam("user") String toUser);

	@POST
	@Path("grant/{user}/{permission}")
	public Response grant(@PathParam("permission") String permission, @PathParam("user") String toUser, RepositoryObjectIds onConfigurationItems);


	@POST
	@Path("deny/{user}/{permission}")
	public Response deny(@PathParam("permission") String permission, @PathParam("user") String toUser, RepositoryObjectIds onConfigurationItems);

	@POST
	@Path("revoke/{user}/{permission}")
	public Response revoke(@PathParam("permission") String permission, @PathParam("user") String fromUser, RepositoryObjectIds onConfigurationItems);
}
