package com.xebialabs.deployit.core.api.jaxb;

import static com.google.common.collect.Lists.newArrayList;

import java.util.Iterator;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "permissions")
public class PrincipalPermissionList implements Iterable<PrincipalPermissionEntry> {

	@XmlAttribute
	private String userName;
	
	@XmlElementRef
	private List<PrincipalPermissionEntry> principalPermissionList = newArrayList();

	public PrincipalPermissionList() {
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(final String userName) {
		this.userName = userName;
	}

	public boolean addPermissionEntry(final PrincipalPermissionEntry principalPermissionsEntry) {
		return (principalPermissionsEntry != null) && this.principalPermissionList.add(principalPermissionsEntry);
	}

	public List<PrincipalPermissionEntry> getPermissionList() {
		return this.principalPermissionList;
	}

	public Iterator<PrincipalPermissionEntry> iterator() {
		return this.principalPermissionList.iterator();
	}

	public boolean hasPermissionEntries() {
		return this.principalPermissionList.isEmpty();
	}
}
