package com.xebialabs.deployit.core.api.dto;

/**
 */
public class PropertyValue {
	String key;
	String value;

	public PropertyValue(String propValue) {
		if (!propValue.contains("=")) {
			throw new IllegalArgumentException("Cannot convert to PropertyValue: " + propValue);
		}
		String[] split = propValue.split("=");
		key = split[0];
		value = split[1];
	}

    public PropertyValue(final String key, final String value) {
        this.key = key;
        this.value = value;
    }

    public String getValue() {
		return value;
	}

	public String getKey() {
		return key;
	}

	@Override
	public String toString() {
		return key + "=" + value;
	}
}
