package com.xebialabs.deployit.core.api.dto;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

@XmlRootElement
public class Deployment {

	private ConfigurationItemDto deployedApplication;

	private List<ConfigurationItemDto> deployeds = newArrayList();
	private boolean upgrade;

	@XmlElement(name = "deployed-application")
	public ConfigurationItemDto getDeployedApplication() {
		return deployedApplication;
	}

	@XmlElement(name = "deployeds")
	public List<ConfigurationItemDto> getDeployeds() {
		return deployeds;
	}

	@XmlElement(name = "upgrade")
	public boolean isUpgrade() {
		return upgrade;
	}

	public void setUpgrade(boolean upgrade) {
		this.upgrade = upgrade;
	}

	public void setDeployedApplication(ConfigurationItemDto deployedApplication) {
		this.deployedApplication = deployedApplication;
	}

	public void setDeployeds(List<ConfigurationItemDto> deployeds) {
		this.deployeds = deployeds;
	}

	public void add(ConfigurationItemDto object) {
		this.deployeds.add(object);
	}

    public void addAll(List<ConfigurationItemDto> deployeds) {
        this.deployeds.addAll(deployeds);
    }

	public String getVersion() {
		return (String) deployedApplication.getValues().get("version");
	}

	public String getEnvironment() {
		return (String) deployedApplication.getValues().get("environment");
	}
}
