package com.xebialabs.deployit.core.api;

import com.xebialabs.deployit.core.api.dto.User;
import org.jboss.resteasy.annotations.ClientResponseType;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path("/user")
@Consumes({MediaType.APPLICATION_XML})
@Produces({MediaType.APPLICATION_XML})
public interface UserProxy {

	@POST
	@Path("{username}")
	@ClientResponseType(entityType = User.class)
	Response create(@PathParam("username") String username, User entity);

	@GET
	@Path("{username}")
	@ClientResponseType(entityType = User.class)
	Response read(@PathParam("username") String username);

	@PUT
	@Path("{username}")
	Response modifyPassword(@PathParam("username") String username, User entity);

	@DELETE
	@Path("{username}")
	Response delete(@PathParam("username") String username);

}
