package com.xebialabs.deployit.core.api.dto;

import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.google.common.collect.Lists;

@XmlRootElement(name = "repository-object-ids")
public class RepositoryObjectIds extends AbstractDTO {

	private List<String> repositoryEntityIds;

	public RepositoryObjectIds() {
		this(Lists.<String>newArrayList());
	}

	public RepositoryObjectIds(List<String> repositoryEntityIds) {
		this.repositoryEntityIds = repositoryEntityIds;
	}

	@XmlElement(name = "repository-object-id")
	public List<String> getRepositoryEntityIds() {
		return repositoryEntityIds;
	}

	public void setRepositoryEntityIds(final List<String> repositoryEntityIds) {
		this.repositoryEntityIds = repositoryEntityIds;		
	}
}
