package com.xebialabs.deployit.core.api.jaxb;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@XmlType(name = "maps")
public class CollectionOfMapsMapElement {

	private Collection<MapEntry[]> mapEntriesCollection;

	public CollectionOfMapsMapElement() {
		//
	}

	public CollectionOfMapsMapElement(final Collection<Map<String, String>> maps) {
		this.mapEntriesCollection = Lists.newArrayList();
		for (Map<String, String> each : maps) {
			List<MapEntry> entries = Lists.newArrayList();
			for (Map.Entry<String, String> eachEntry : each.entrySet()) {
				entries.add(new MapEntry(eachEntry));
			}
			this.mapEntriesCollection.add(entries.toArray(new MapEntry[entries.size()]));
		}
	}

	@XmlElement(name = "map")
	public Collection<MapEntry[]> getMapEntriesCollection() {
		return mapEntriesCollection;
	}

	public void setMapEntriesCollection(Collection<MapEntry[]> maps) {
		this.mapEntriesCollection = maps;
	}

	@XmlTransient
	public Collection<Map<String, String>> getMaps() {
		Collection<Map<String, String>> maps = Lists.newArrayList();
		for (MapEntry[] each : mapEntriesCollection) {
			Map<String, String> m = Maps.newHashMap();
			for (MapEntry eachEntry : each) {
				m.put(eachEntry.getKey(), eachEntry.getValue());
			}
			maps.add(m);
		}
		return maps;
	}

	@XmlRootElement()
	public static class MapEntry {
		private String key;

		private String value;

		public MapEntry() {
			//	
		}

		public MapEntry(Map.Entry<String, String> mapEntry) {
			this.key = mapEntry.getKey();
			this.value = mapEntry.getValue();
		}

		public String getKey() {
			return key;
		}

		public void setKey(String key) {
			this.key = key;
		}

		public String getValue() {
			return value;
		}

		public void setValue(String value) {
			this.value = value;
		}

	}

}
