package com.xebialabs.deployit.core.api.dto;

import com.google.common.collect.Lists;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement(name = "repository-object-ids")
public class RepositoryObjectIds extends AbstractDTO {

	private List<String> repositoryEntityIds;

	public RepositoryObjectIds() {
		this(Lists.<String>newArrayList());
	}

	public RepositoryObjectIds(List<String> objects) {
		repositoryEntityIds = objects;
	}

	@XmlElement(name = "repository-object-id")
	public List<String> getRepositoryEntityIds() {
		return repositoryEntityIds;
	}

	public void setRepositoryEntityIds(final List<String> repositoryEntityIds) {
		this.repositoryEntityIds = repositoryEntityIds;
	}
}
