package com.xebialabs.deployit.core.api.dto;

import java.util.*;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.google.common.collect.Lists;
import org.apache.commons.lang.ArrayUtils;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.core.api.jaxb.MapAdapter;
import com.xebialabs.deployit.core.api.jaxb.MapElement;

import static com.google.common.collect.Lists.newArrayList;

@XmlSeeAlso({ Archetype.class, ConfigurationItem.class, MapElement.class })
public abstract class RepositoryObject extends AbstractDTO {

	private String id;

	private String configurationItemTypeName;

	private String archetypeId;

	private Calendar lastModified;

	private Calendar overrideLastModified;

	private String creatingTaskId;

	private Map<String, Object> values = Maps.newHashMap();

    private List<Message> validations = newArrayList();

	public RepositoryObject() {
		//
	}

	public RepositoryObject(final String configurationItemTypeName) {
		this.configurationItemTypeName = configurationItemTypeName;
	}

	public RepositoryObject(final String configurationItemTypeName, String... properties) {
		this.configurationItemTypeName = configurationItemTypeName;
		setProperties(properties);
	}

	public RepositoryObject(final String id, final String configurationItemTypeName) {
		this.id = id;
		this.configurationItemTypeName = configurationItemTypeName;
	}

	@XmlElement(name = "id")
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	@XmlElement(name = "configuration-item-type-name")
	public String getConfigurationItemTypeName() {
		return configurationItemTypeName;
	}

	public void setConfigurationItemTypeName(final String ciType) {
		this.configurationItemTypeName = ciType;
	}

	@XmlElement(name = "archetype-id")
	public String getArchetypeId() {
		return archetypeId;
	}

	public void setArchetypeId(String archetypeId) {
		this.archetypeId = archetypeId;
	}

	@XmlElement(name = "last-modified")
	public Calendar getLastModified() {
		return lastModified;
	}

	public void setLastModified(Calendar lastModified) {
		this.lastModified = lastModified;
	}

	@XmlElement(name = "override-last-modified")
	public Calendar getOverrideLastModified() {
		return overrideLastModified;
	}

	public void setOverrideLastModified(Calendar overrideLastModified) {
		this.overrideLastModified = overrideLastModified;
	}

	@XmlElement(name = "creating-task-id")
	public String getCreatingTaskId() {
		return creatingTaskId;
	}

	public void setCreatingTaskId(String creatingTaskId) {
		this.creatingTaskId = creatingTaskId;
	}

	@XmlJavaTypeAdapter(MapAdapter.class)
	public Map<String, Object> getValues() {
		return values;
	}

	public void setValues(final Map<String, Object> values) {
		this.values = values;
	}

	public void setProperty(String propertyName, Object propertyValue) {
		values.put(propertyName, propertyValue);
	}

	/**
	 * Adds the propertyValue object to the existing collection/Array value corresponding to the propertyName
	 * 
	 * @param propertyName
	 * @param propertyValue
	 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	// TODO:WIP.. need to test from python
	public void addPropertyValue(String propertyName, Object propertyValue) {
		Object valueFromMap = values.get(propertyName);
		// only consider Collection or Array
		if (valueFromMap instanceof Collection) {
			Collection valueAsCollection = (Collection) valueFromMap;
			valueAsCollection.add(propertyValue);
		} else if (valueFromMap instanceof Object[]) {
			Object[] valueAsObject = (Object[]) valueFromMap;
			ArrayUtils.add(valueAsObject, propertyValue);
		}
	}

	public void setProperties(String... keyValuePairs) {
		for (String each : keyValuePairs) {
			if (!each.contains("="))
				continue;
			String[] keyValue = each.split("=");
			setProperty(keyValue[0], keyValue[1]);
		}
	}

    @XmlElement(name = "validations")
    public List<Message> getValidations() {
        return validations;
    }

    public void setValidations(final List<Message> validations) {
        this.validations = validations;
    }
}
