package com.xebialabs.deployit.core.api.dto;

import static com.google.common.collect.Lists.newArrayList;

import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "repository-objects")
public class RepositoryObjects extends AbstractDTO {

	private List<RepositoryObject> objects = newArrayList();

	@XmlElement(name = "repository-object")
	public List<RepositoryObject> getObjects() {
		return objects;
	}

	public void setObjects(final List<RepositoryObject> objects) {
		this.objects = objects;
	}

	public void clear() {
		this.objects.clear();
	}

	public void add(RepositoryObject object) {
		this.objects.add(object);
	}

}
