package com.xebialabs.deployit.core.api.dto;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;

import java.util.List;
import java.util.Set;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "configuration-item-descriptor")
public class ConfigurationItemDescriptorDto extends AbstractDTO {

	private String type;
	private String simpleName;
	private String rootName;

	private Set<String> interfaces = Sets.newHashSet();
	private List<String> superClasses = Lists.newArrayList();
	
	private String mappingSourceType;
	private String mappingTargetType;

	private List<ConfigurationItemPropertyDescriptorDto> propertyDescriptors = Lists.newArrayList();
    private String description;
    
    private String placeholderFormatName;
	private String placeholdersName;
    
    public ConfigurationItemDescriptorDto() {
	}

	public void setType(final String type) {
		this.type = type;
	}

	public void setSimpleName(final String simpleName) {
		this.simpleName = simpleName;
	}

	public void setInterfaces(final Set<String> interfaces) {
		this.interfaces = interfaces;
	}

	public void setSuperClasses(final List<String> superClasses) {
		this.superClasses = superClasses;
	}

	public void addPropertyDescriptor(final ConfigurationItemPropertyDescriptorDto configurationItemPropertyDescriptorDto) {
		propertyDescriptors.add(configurationItemPropertyDescriptorDto);
	}
	
	@XmlElement
	public String getType() {
    	return type;
    }

	@XmlElement
	public String getSimpleName() {
    	return simpleName;
    }

	@XmlElement
	public Set<String> getInterfaces() {
    	return interfaces;
    }

	@XmlElement
	public List<String> getSuperClasses() {
    	return superClasses;
    }

	@XmlElement
	public List<ConfigurationItemPropertyDescriptorDto> getPropertyDescriptors() {
    	return propertyDescriptors;
    }
	
	public String getMappingSourceType() {
		return mappingSourceType;
	}
	
	public void setMappingSourceType(String mappingSourceType) {
		this.mappingSourceType = mappingSourceType;
	}

	public String getMappingTargetType() {
		return mappingTargetType;
	}
	
	public void setMappingTargetType(String mappingTargetType) {
		this.mappingTargetType = mappingTargetType;
	}

    public void setDescription(final String description) {
        this.description = description;
    }

    @XmlElement
    public String getDescription() {
        return description;
    }
    
    @XmlElement
    public String getPlaceholderFormatName() {
		return placeholderFormatName;
	}

	public void setPlaceholderFormatName(String placeholderFormatName) {
		this.placeholderFormatName = placeholderFormatName;
	}

	@XmlElement
	public String getPlaceholdersName() {
		return placeholdersName;
	}

	public void setPlaceholdersName(String placeholdersName) {
		this.placeholdersName = placeholdersName;
	}
	
	@XmlElement
	public String getRootName() {
		return rootName;
	}

	public void setRootName(String rootName) {
	    this.rootName = rootName;
    }    
}
