package com.xebialabs.deployit.core.api;

import com.xebialabs.deployit.core.api.dto.RepositoryObjectIds;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path("/deployit/security")
@Consumes({ MediaType.APPLICATION_XML })
@Produces({ MediaType.APPLICATION_XML })
public interface SecurityProxy {

	@POST
	@Path("grant/{user}/{permission}")
	public Response grant(@PathParam("permission") String permission, @PathParam("user") String toUser, RepositoryObjectIds onConfigurationItems);


	@POST
	@Path("deny/{user}/{permission}")
	public Response deny(@PathParam("permission") String permission, @PathParam("user") String toUser, RepositoryObjectIds onConfigurationItems);

	@POST
	@Path("revoke/{user}/{permission}")
	public Response revoke(@PathParam("permission") String permission, @PathParam("user") String fromUser, RepositoryObjectIds onConfigurationItems);
}
